/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import org.gradle.composite.internal.IncludedBuildRegistry;
import org.gradle.initialization.DefaultSettingsLoader;
import org.gradle.initialization.ISettingsFinder;
import org.gradle.initialization.NestedBuildFactory;
import org.gradle.initialization.NotifyingSettingsLoader;
import org.gradle.initialization.SettingsLoader;
import org.gradle.initialization.SettingsLoaderFactory;
import org.gradle.initialization.SettingsProcessor;
import org.gradle.initialization.buildsrc.BuildSourceBuilder;
import org.gradle.internal.composite.CompositeBuildSettingsLoader;

public class DefaultSettingsLoaderFactory
implements SettingsLoaderFactory {
    private final ISettingsFinder settingsFinder;
    private final SettingsProcessor settingsProcessor;
    private final BuildSourceBuilder buildSourceBuilder;
    private final NestedBuildFactory nestedBuildFactory;
    private final IncludedBuildRegistry includedBuildRegistry;

    public DefaultSettingsLoaderFactory(ISettingsFinder settingsFinder, SettingsProcessor settingsProcessor, BuildSourceBuilder buildSourceBuilder, NestedBuildFactory nestedBuildFactory, IncludedBuildRegistry includedBuildRegistry) {
        this.settingsFinder = settingsFinder;
        this.settingsProcessor = settingsProcessor;
        this.buildSourceBuilder = buildSourceBuilder;
        this.nestedBuildFactory = nestedBuildFactory;
        this.includedBuildRegistry = includedBuildRegistry;
    }

    public SettingsLoader forTopLevelBuild() {
        return this.notifyingSettingsLoader(this.compositeBuildSettingsLoader());
    }

    public SettingsLoader forNestedBuild() {
        return this.notifyingSettingsLoader(this.defaultSettingsLoader());
    }

    private SettingsLoader compositeBuildSettingsLoader() {
        return new CompositeBuildSettingsLoader(this.defaultSettingsLoader(), this.nestedBuildFactory, this.includedBuildRegistry);
    }

    private SettingsLoader defaultSettingsLoader() {
        return new DefaultSettingsLoader(this.settingsFinder, this.settingsProcessor, this.buildSourceBuilder);
    }

    private SettingsLoader notifyingSettingsLoader(SettingsLoader settingsLoader) {
        return new NotifyingSettingsLoader(settingsLoader);
    }
}

