/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization.buildsrc;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.cache.PersistentCache;
import org.gradle.initialization.buildsrc.BuildSrcBuildListenerFactory;
import org.gradle.internal.Factory;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.internal.invocation.BuildController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildSrcUpdateFactory
implements Factory<DefaultClassPath> {
    private final PersistentCache cache;
    private final BuildController buildController;
    private BuildSrcBuildListenerFactory listenerFactory;
    private static final Logger LOGGER = Logging.getLogger(BuildSrcUpdateFactory.class);

    public BuildSrcUpdateFactory(PersistentCache cache, BuildController buildController, BuildSrcBuildListenerFactory listenerFactory) {
        this.cache = cache;
        this.buildController = buildController;
        this.listenerFactory = listenerFactory;
    }

    @Override
    public DefaultClassPath create() {
        File markerFile = new File(this.cache.getBaseDir(), "built.bin");
        boolean rebuild = !markerFile.exists();
        Collection<File> classpath = this.build(rebuild);
        LOGGER.debug("Gradle source classpath is: {}", classpath);
        try {
            markerFile.createNewFile();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return new DefaultClassPath(classpath);
    }

    private Collection<File> build(boolean rebuild) {
        BuildSrcBuildListenerFactory.Listener listener = this.listenerFactory.create(rebuild);
        GradleInternal gradle = this.buildController.getGradle();
        gradle.addListener(listener);
        this.buildController.run();
        return listener.getRuntimeClasspath();
    }
}

