/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ModuleExclusion;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ModuleExclusions;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.internal.component.external.model.ComponentVariant;
import org.gradle.internal.component.external.model.DefaultModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.DependencyMetadataRules;
import org.gradle.internal.component.model.GradleDependencyMetadata;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.component.model.VariantMetadata;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;

class VariantBackedConfigurationMetadata
implements ConfigurationMetadata {
    private final ModuleComponentIdentifier componentId;
    private final ComponentVariant variant;
    private final ImmutableList<GradleDependencyMetadata> dependencies;
    private final DependencyMetadataRules dependencyMetadataRules;
    private List<GradleDependencyMetadata> calculatedDependencies;

    VariantBackedConfigurationMetadata(ModuleComponentIdentifier componentId, ComponentVariant variant, DependencyMetadataRules dependencyMetadataRules) {
        this.componentId = componentId;
        this.variant = variant;
        ArrayList<GradleDependencyMetadata> dependencies = new ArrayList<GradleDependencyMetadata>(variant.getDependencies().size());
        for (ComponentVariant.Dependency dependency : variant.getDependencies()) {
            dependencies.add(new GradleDependencyMetadata(DefaultModuleComponentSelector.newSelector(dependency.getGroup(), dependency.getModule(), dependency.getVersionConstraint())));
        }
        this.dependencies = ImmutableList.copyOf(dependencies);
        this.dependencyMetadataRules = dependencyMetadataRules;
    }

    @Override
    public String getName() {
        return this.variant.getName();
    }

    @Override
    public Collection<String> getHierarchy() {
        return ImmutableList.of((Object)this.variant.getName());
    }

    public String toString() {
        return this.asDescribable().getDisplayName();
    }

    @Override
    public DisplayName asDescribable() {
        return Describables.of(this.componentId, "variant", this.variant.getName());
    }

    @Override
    public ImmutableAttributes getAttributes() {
        return this.variant.getAttributes().asImmutable();
    }

    @Override
    public Set<? extends VariantMetadata> getVariants() {
        return ImmutableSet.of((Object)this.variant);
    }

    @Override
    public boolean isCanBeConsumed() {
        return true;
    }

    @Override
    public boolean isCanBeResolved() {
        return false;
    }

    @Override
    public boolean isTransitive() {
        return true;
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public ModuleExclusion getExclusions(ModuleExclusions moduleExclusions) {
        return ModuleExclusions.excludeNone();
    }

    @Override
    public ComponentArtifactMetadata artifact(IvyArtifactName artifact) {
        return new DefaultModuleComponentArtifactMetadata(this.componentId, artifact);
    }

    @Override
    public List<? extends ComponentArtifactMetadata> getArtifacts() {
        return ImmutableList.of();
    }

    @Override
    public List<? extends DependencyMetadata> getDependencies() {
        if (this.calculatedDependencies == null) {
            this.calculatedDependencies = this.dependencyMetadataRules == null ? this.dependencies : this.dependencyMetadataRules.execute(this.dependencies);
        }
        return this.calculatedDependencies;
    }
}

