/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.gradle.api.Action;
import org.gradle.internal.graph.DirectedGraph;
import org.gradle.internal.graph.GraphNodeRenderer;
import org.gradle.internal.graph.GraphRenderer;
import org.gradle.internal.logging.text.StreamingStyledTextOutput;
import org.gradle.internal.logging.text.StyledTextOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectedGraphRenderer<N> {
    private final GraphNodeRenderer<N> nodeRenderer;
    private final DirectedGraph<N, ?> graph;
    private boolean omittedDetails;

    public DirectedGraphRenderer(GraphNodeRenderer<N> nodeRenderer, DirectedGraph<N, ?> graph) {
        this.nodeRenderer = nodeRenderer;
        this.graph = graph;
    }

    public void renderTo(N root, Appendable output) {
        this.renderTo(root, new StreamingStyledTextOutput(output));
    }

    public void renderTo(N root, StyledTextOutput output) {
        GraphRenderer renderer = new GraphRenderer(output);
        HashSet rendered = new HashSet();
        this.omittedDetails = false;
        this.renderTo(root, renderer, rendered, false);
        if (this.omittedDetails) {
            output.println();
            output.withStyle(StyledTextOutput.Style.Info).println("(*) - details omitted (listed previously)");
        }
    }

    private void renderTo(final N node, GraphRenderer graphRenderer, Collection<N> rendered, boolean lastChild) {
        final boolean alreadySeen = !rendered.add(node);
        graphRenderer.visit((Action<? super StyledTextOutput>)new Action<StyledTextOutput>(){

            @Override
            public void execute(StyledTextOutput output) {
                DirectedGraphRenderer.this.nodeRenderer.renderTo(node, output);
                if (alreadySeen) {
                    output.text(" (*)");
                }
            }
        }, lastChild);
        if (alreadySeen) {
            this.omittedDetails = true;
            return;
        }
        ArrayList children = new ArrayList();
        this.graph.getNodeValues(node, new HashSet(), children);
        if (children.isEmpty()) {
            return;
        }
        graphRenderer.startChildren();
        for (int i = 0; i < children.size(); ++i) {
            Object child = children.get(i);
            this.renderTo(child, graphRenderer, rendered, i == children.size() - 1);
        }
        graphRenderer.completeChildren();
    }
}

