/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.operations.trace;

import groovy.json.JsonOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.operations.trace.SerializedOperationFinish;
import org.gradle.internal.operations.trace.SerializedOperationProgress;
import org.gradle.internal.operations.trace.SerializedOperationStart;
import org.gradle.internal.progress.BuildOperationDescriptor;
import org.gradle.internal.progress.BuildOperationListener;
import org.gradle.internal.progress.OperationFinishEvent;
import org.gradle.internal.progress.OperationProgressEvent;
import org.gradle.internal.progress.OperationStartEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SerializingBuildOperationListener
implements BuildOperationListener {
    private static final byte[] NEWLINE = "\n".getBytes();
    private static final byte[] INDENT = "    ".getBytes();
    private OutputStream out;

    SerializingBuildOperationListener(OutputStream out) {
        this.out = out;
    }

    @Override
    public void started(BuildOperationDescriptor buildOperation, OperationStartEvent startEvent) {
        this.write(new SerializedOperationStart(buildOperation, startEvent).toMap(), false);
    }

    @Override
    public void progress(BuildOperationDescriptor buildOperation, OperationProgressEvent progressEvent) {
        this.write(new SerializedOperationProgress(buildOperation, progressEvent).toMap(), false);
    }

    @Override
    public void finished(BuildOperationDescriptor buildOperation, OperationFinishEvent finishEvent) {
        this.write(new SerializedOperationFinish(buildOperation, finishEvent).toMap(), true);
    }

    private void write(Map<String, ?> entry, boolean indent) {
        String json = JsonOutput.toJson(entry);
        try {
            if (indent) {
                this.out.write(INDENT);
            }
            this.out.write(json.getBytes("UTF-8"));
            this.out.write(NEWLINE);
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
    }
}

