/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.Transformer;
import org.gradle.api.resources.ResourceException;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.internal.progress.BuildOperationDescriptor;
import org.gradle.internal.resource.ExternalResource;
import org.gradle.internal.resource.ExternalResourceListBuildOperationType;
import org.gradle.internal.resource.ExternalResourceName;
import org.gradle.internal.resource.ExternalResourceReadBuildOperationType;
import org.gradle.internal.resource.ExternalResourceReadMetadataBuildOperationType;
import org.gradle.internal.resource.ExternalResourceReadResult;
import org.gradle.internal.resource.ExternalResourceWriteBuildOperationType;
import org.gradle.internal.resource.ExternalResourceWriteResult;
import org.gradle.internal.resource.ReadableContent;
import org.gradle.internal.resource.metadata.ExternalResourceMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildOperationFiringExternalResourceDecorator
implements ExternalResource {
    private final ExternalResourceName resourceName;
    private final BuildOperationExecutor buildOperationExecutor;
    private final ExternalResource delegate;
    private static final ExternalResourceReadMetadataBuildOperationType.Result METADATA_RESULT = new ExternalResourceReadMetadataBuildOperationType.Result(){};
    private static final ExternalResourceListBuildOperationType.Result LIST_RESULT = new ExternalResourceListBuildOperationType.Result(){};

    public BuildOperationFiringExternalResourceDecorator(ExternalResourceName resourceName, BuildOperationExecutor buildOperationExecutor, ExternalResource delegate) {
        this.resourceName = resourceName;
        this.buildOperationExecutor = buildOperationExecutor;
        this.delegate = delegate;
    }

    @Override
    public URI getURI() {
        return this.delegate.getURI();
    }

    @Override
    public String getDisplayName() {
        return this.delegate.getDisplayName();
    }

    @Override
    public ExternalResourceMetaData getMetaData() {
        return this.buildOperationExecutor.call(new CallableBuildOperation<ExternalResourceMetaData>(){

            @Override
            public ExternalResourceMetaData call(BuildOperationContext context) {
                ExternalResourceMetaData metaData = BuildOperationFiringExternalResourceDecorator.this.delegate.getMetaData();
                context.setResult(METADATA_RESULT);
                return metaData;
            }

            @Override
            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName("Metadata of " + BuildOperationFiringExternalResourceDecorator.this.resourceName.getDisplayName()).details(new MetadataOperationDetails(BuildOperationFiringExternalResourceDecorator.this.resourceName.getUri()));
            }
        });
    }

    @Override
    @Nullable
    public List<String> list() throws ResourceException {
        return this.buildOperationExecutor.call(new CallableBuildOperation<List<String>>(){

            @Override
            public List<String> call(BuildOperationContext context) {
                List<String> list = BuildOperationFiringExternalResourceDecorator.this.delegate.list();
                context.setResult(LIST_RESULT);
                return list;
            }

            @Override
            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName("List " + BuildOperationFiringExternalResourceDecorator.this.resourceName.getDisplayName()).details(new ListOperationDetails(BuildOperationFiringExternalResourceDecorator.this.resourceName.getUri()));
            }
        });
    }

    @Override
    public ExternalResourceWriteResult put(final ReadableContent source) throws ResourceException {
        return this.buildOperationExecutor.call(new CallableBuildOperation<ExternalResourceWriteResult>(){

            @Override
            public ExternalResourceWriteResult call(BuildOperationContext context) {
                final ExternalResourceWriteResult result = BuildOperationFiringExternalResourceDecorator.this.delegate.put(source);
                context.setResult(new ExternalResourceWriteBuildOperationType.Result(){

                    public long getBytesWritten() {
                        return result.getBytesWritten();
                    }
                });
                return result;
            }

            @Override
            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName("Upload " + BuildOperationFiringExternalResourceDecorator.this.resourceName.getDisplayName()).progressDisplayName(BuildOperationFiringExternalResourceDecorator.this.resourceName.getShortDisplayName()).details(new PutOperationDetails(BuildOperationFiringExternalResourceDecorator.this.resourceName.getUri()));
            }
        });
    }

    @Override
    public ExternalResourceReadResult<Void> writeToIfPresent(final File destination) throws ResourceException {
        return this.buildOperationExecutor.call(new CallableBuildOperation<ExternalResourceReadResult<Void>>(){

            @Override
            public BuildOperationDescriptor.Builder description() {
                return BuildOperationFiringExternalResourceDecorator.this.createBuildOperationDetails();
            }

            @Override
            public ExternalResourceReadResult<Void> call(BuildOperationContext buildOperationContext) {
                return BuildOperationFiringExternalResourceDecorator.result(buildOperationContext, BuildOperationFiringExternalResourceDecorator.this.delegate.writeToIfPresent(destination));
            }
        });
    }

    @Override
    public ExternalResourceReadResult<Void> writeTo(final File destination) throws ResourceException {
        return this.buildOperationExecutor.call(new CallableBuildOperation<ExternalResourceReadResult<Void>>(){

            @Override
            public BuildOperationDescriptor.Builder description() {
                return BuildOperationFiringExternalResourceDecorator.this.createBuildOperationDetails();
            }

            @Override
            public ExternalResourceReadResult<Void> call(BuildOperationContext buildOperationContext) {
                return BuildOperationFiringExternalResourceDecorator.result(buildOperationContext, BuildOperationFiringExternalResourceDecorator.this.delegate.writeTo(destination));
            }
        });
    }

    @Override
    public ExternalResourceReadResult<Void> writeTo(final OutputStream destination) throws ResourceException {
        return this.buildOperationExecutor.call(new CallableBuildOperation<ExternalResourceReadResult<Void>>(){

            @Override
            public BuildOperationDescriptor.Builder description() {
                return BuildOperationFiringExternalResourceDecorator.this.createBuildOperationDetails();
            }

            @Override
            public ExternalResourceReadResult<Void> call(BuildOperationContext buildOperationContext) {
                return BuildOperationFiringExternalResourceDecorator.result(buildOperationContext, BuildOperationFiringExternalResourceDecorator.this.delegate.writeTo(destination));
            }
        });
    }

    @Override
    public ExternalResourceReadResult<Void> withContent(final Action<? super InputStream> readAction) throws ResourceException {
        return this.buildOperationExecutor.call(new CallableBuildOperation<ExternalResourceReadResult<Void>>(){

            @Override
            public BuildOperationDescriptor.Builder description() {
                return BuildOperationFiringExternalResourceDecorator.this.createBuildOperationDetails();
            }

            @Override
            public ExternalResourceReadResult<Void> call(BuildOperationContext buildOperationContext) {
                return BuildOperationFiringExternalResourceDecorator.result(buildOperationContext, BuildOperationFiringExternalResourceDecorator.this.delegate.withContent(readAction));
            }
        });
    }

    @Override
    public <T> ExternalResourceReadResult<T> withContent(final Transformer<? extends T, ? super InputStream> readAction) throws ResourceException {
        return (ExternalResourceReadResult)this.buildOperationExecutor.call(new CallableBuildOperation<ExternalResourceReadResult<T>>(){

            @Override
            public BuildOperationDescriptor.Builder description() {
                return BuildOperationFiringExternalResourceDecorator.this.createBuildOperationDetails();
            }

            @Override
            public ExternalResourceReadResult<T> call(BuildOperationContext buildOperationContext) {
                return BuildOperationFiringExternalResourceDecorator.result(buildOperationContext, BuildOperationFiringExternalResourceDecorator.this.delegate.withContent(readAction));
            }
        });
    }

    @Override
    public <T> ExternalResourceReadResult<T> withContent(final ExternalResource.ContentAction<? extends T> readAction) throws ResourceException {
        return (ExternalResourceReadResult)this.buildOperationExecutor.call(new CallableBuildOperation<ExternalResourceReadResult<T>>(){

            @Override
            public BuildOperationDescriptor.Builder description() {
                return BuildOperationFiringExternalResourceDecorator.this.createBuildOperationDetails();
            }

            @Override
            public ExternalResourceReadResult<T> call(BuildOperationContext buildOperationContext) {
                return BuildOperationFiringExternalResourceDecorator.result(buildOperationContext, BuildOperationFiringExternalResourceDecorator.this.delegate.withContent(readAction));
            }
        });
    }

    @Override
    @Nullable
    public <T> ExternalResourceReadResult<T> withContentIfPresent(final Transformer<? extends T, ? super InputStream> readAction) throws ResourceException {
        return (ExternalResourceReadResult)this.buildOperationExecutor.call(new CallableBuildOperation<ExternalResourceReadResult<T>>(){

            @Override
            public BuildOperationDescriptor.Builder description() {
                return BuildOperationFiringExternalResourceDecorator.this.createBuildOperationDetails();
            }

            @Override
            public ExternalResourceReadResult<T> call(BuildOperationContext buildOperationContext) {
                return BuildOperationFiringExternalResourceDecorator.result(buildOperationContext, BuildOperationFiringExternalResourceDecorator.this.delegate.withContentIfPresent(readAction));
            }
        });
    }

    @Override
    @Nullable
    public <T> ExternalResourceReadResult<T> withContentIfPresent(final ExternalResource.ContentAction<? extends T> readAction) throws ResourceException {
        return (ExternalResourceReadResult)this.buildOperationExecutor.call(new CallableBuildOperation<ExternalResourceReadResult<T>>(){

            @Override
            public BuildOperationDescriptor.Builder description() {
                return BuildOperationFiringExternalResourceDecorator.this.createBuildOperationDetails();
            }

            @Override
            public ExternalResourceReadResult<T> call(BuildOperationContext buildOperationContext) {
                return BuildOperationFiringExternalResourceDecorator.result(buildOperationContext, BuildOperationFiringExternalResourceDecorator.this.delegate.withContentIfPresent(readAction));
            }
        });
    }

    private static <T> ExternalResourceReadResult<T> result(BuildOperationContext buildOperationContext, ExternalResourceReadResult<T> result) {
        buildOperationContext.setResult(new ReadOperationResult(result == null ? 0L : result.getBytesRead()));
        return result;
    }

    private BuildOperationDescriptor.Builder createBuildOperationDetails() {
        ReadOperationDetails operationDetails = new ReadOperationDetails(this.resourceName.getUri());
        return BuildOperationDescriptor.displayName("Download " + this.resourceName.getDisplayName()).progressDisplayName(this.resourceName.getShortDisplayName()).details(operationDetails);
    }

    private static class ReadOperationResult
    implements ExternalResourceReadBuildOperationType.Result {
        private final long bytesRead;

        private ReadOperationResult(long bytesRead) {
            this.bytesRead = bytesRead;
        }

        public long getBytesRead() {
            return this.bytesRead;
        }

        public String toString() {
            return "ExternalResourceReadBuildOperationType.Result{bytesRead=" + this.bytesRead + '}';
        }
    }

    private static class PutOperationDetails
    extends LocationDetails
    implements ExternalResourceWriteBuildOperationType.Details {
        private PutOperationDetails(URI location) {
            super(location);
        }

        public String toString() {
            return "ExternalResourceWriteBuildOperationType.Details{location=" + this.getLocation() + ", " + '}';
        }
    }

    private static class ListOperationDetails
    extends LocationDetails
    implements ExternalResourceListBuildOperationType.Details {
        private ListOperationDetails(URI location) {
            super(location);
        }

        public String toString() {
            return "ExternalResourceListBuildOperationType.Details{location=" + this.getLocation() + ", " + '}';
        }
    }

    private static class MetadataOperationDetails
    extends LocationDetails
    implements ExternalResourceReadMetadataBuildOperationType.Details {
        private MetadataOperationDetails(URI location) {
            super(location);
        }

        public String toString() {
            return "ExternalResourceReadMetadataBuildOperationType.Details{location=" + this.getLocation() + ", " + '}';
        }
    }

    private static class ReadOperationDetails
    extends LocationDetails
    implements ExternalResourceReadBuildOperationType.Details {
        private ReadOperationDetails(URI location) {
            super(location);
        }

        public String toString() {
            return "ExternalResourceReadBuildOperationType.Details{location=" + this.getLocation() + ", " + '}';
        }
    }

    private static class LocationDetails {
        private final URI location;

        private LocationDetails(URI location) {
            this.location = location;
        }

        public String getLocation() {
            return this.location.toASCIIString();
        }
    }
}

