/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.work;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.gradle.api.Action;
import org.gradle.api.Describable;
import org.gradle.api.Transformer;
import org.gradle.api.specs.Spec;
import org.gradle.concurrent.ParallelismConfiguration;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.ParallelismConfigurationListener;
import org.gradle.internal.concurrent.ParallelismConfigurationManager;
import org.gradle.internal.impldep.com.google.common.collect.Iterables;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.resources.AbstractResourceLockRegistry;
import org.gradle.internal.resources.AbstractTrackedResourceLock;
import org.gradle.internal.resources.DefaultResourceLockCoordinationService;
import org.gradle.internal.resources.ExclusiveAccessResourceLock;
import org.gradle.internal.resources.ResourceLock;
import org.gradle.internal.resources.ResourceLockCoordinationService;
import org.gradle.internal.resources.ResourceLockState;
import org.gradle.internal.work.NoAvailableWorkerLeaseException;
import org.gradle.internal.work.WorkerLeaseRegistry;
import org.gradle.internal.work.WorkerLeaseService;
import org.gradle.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultWorkerLeaseService
implements WorkerLeaseService,
ParallelismConfigurationListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultWorkerLeaseService.class);
    private volatile int maxWorkerCount;
    private int counter = 1;
    private final Root root = new Root();
    private final ResourceLockCoordinationService coordinationService;
    private final ProjectLockRegistry projectLockRegistry;
    private final WorkerLeaseLockRegistry workerLeaseLockRegistry;
    private final ParallelismConfigurationManager parallelismConfigurationManager;

    public DefaultWorkerLeaseService(ResourceLockCoordinationService coordinationService, ParallelismConfigurationManager parallelismConfigurationManager) {
        this.maxWorkerCount = parallelismConfigurationManager.getParallelismConfiguration().getMaxWorkerCount();
        this.coordinationService = coordinationService;
        this.projectLockRegistry = new ProjectLockRegistry(coordinationService, parallelismConfigurationManager.getParallelismConfiguration().isParallelProjectExecutionEnabled());
        this.workerLeaseLockRegistry = new WorkerLeaseLockRegistry(coordinationService);
        this.parallelismConfigurationManager = parallelismConfigurationManager;
        parallelismConfigurationManager.addListener(this);
        LOGGER.info("Using {} worker leases.", (Object)this.maxWorkerCount);
    }

    @Override
    public void onParallelismConfigurationChange(ParallelismConfiguration parallelismConfiguration) {
        this.maxWorkerCount = parallelismConfiguration.getMaxWorkerCount();
        this.projectLockRegistry.setParallelEnabled(parallelismConfiguration.isParallelProjectExecutionEnabled());
    }

    @Override
    public int getMaxWorkerCount() {
        return this.maxWorkerCount;
    }

    @Override
    public WorkerLeaseRegistry.WorkerLease getCurrentWorkerLease() {
        Collection<ResourceLock> operations = this.workerLeaseLockRegistry.getResourceLocksByCurrentThread();
        if (operations.isEmpty()) {
            throw new NoAvailableWorkerLeaseException("No worker lease associated with the current thread");
        }
        return (DefaultWorkerLease)operations.toArray()[operations.size() - 1];
    }

    private synchronized DefaultWorkerLease getWorkerLease(LeaseHolder parent) {
        int workerId = this.counter++;
        Thread ownerThread = Thread.currentThread();
        return this.workerLeaseLockRegistry.getResourceLock(parent, workerId, ownerThread);
    }

    @Override
    public DefaultWorkerLease getWorkerLease() {
        Collection<ResourceLock> operations = this.workerLeaseLockRegistry.getResourceLocksByCurrentThread();
        Root parent = operations.isEmpty() ? this.root : (DefaultWorkerLease)operations.toArray()[operations.size() - 1];
        return this.getWorkerLease(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void withSharedLease(WorkerLeaseRegistry.WorkerLease sharedLease, Runnable action) {
        this.workerLeaseLockRegistry.associateResourceLock(sharedLease);
        try {
            action.run();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.workerLeaseLockRegistry.unassociatResourceLock(sharedLease);
            this.coordinationService.notifyStateChange();
            throw throwable;
        }
        this.workerLeaseLockRegistry.unassociatResourceLock(sharedLease);
        this.coordinationService.notifyStateChange();
    }

    @Override
    public void stop() {
        this.parallelismConfigurationManager.removeListener(this);
        this.coordinationService.withStateLock(new Transformer<ResourceLockState.Disposition, ResourceLockState>(){

            @Override
            public ResourceLockState.Disposition transform(ResourceLockState resourceLockState) {
                if (DefaultWorkerLeaseService.this.workerLeaseLockRegistry.hasOpenLocks()) {
                    throw new IllegalStateException("Some worker leases have not been marked as completed.");
                }
                if (DefaultWorkerLeaseService.this.projectLockRegistry.hasOpenLocks()) {
                    throw new IllegalStateException("Some project locks have not been unlocked.");
                }
                return ResourceLockState.Disposition.FINISHED;
            }
        });
    }

    @Override
    public ResourceLock getProjectLock(String gradlePath, String projectPath) {
        return this.projectLockRegistry.getResourceLock(gradlePath, projectPath);
    }

    @Override
    public <T> T withoutProjectLock(Callable<T> action) {
        Collection<ResourceLock> projectLocks = this.projectLockRegistry.getResourceLocksByCurrentThread();
        return this.withoutLocks(projectLocks, action);
    }

    @Override
    public void withoutProjectLock(Runnable action) {
        Collection<ResourceLock> projectLocks = this.projectLockRegistry.getResourceLocksByCurrentThread();
        this.withoutLocks(projectLocks, action);
    }

    @Override
    public <T> T withLocks(Iterable<? extends ResourceLock> locks, Callable<T> action) {
        T t;
        this.coordinationService.withStateLock(DefaultResourceLockCoordinationService.lock(locks));
        try {
            t = action.call();
            Object var5_5 = null;
            this.coordinationService.withStateLock(DefaultResourceLockCoordinationService.unlock(locks));
        }
        catch (Exception e) {
            try {
                throw UncheckedException.throwAsUncheckedException(e);
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.coordinationService.withStateLock(DefaultResourceLockCoordinationService.unlock(locks));
                throw throwable;
            }
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void withLocks(Iterable<? extends ResourceLock> locks, Runnable action) {
        this.coordinationService.withStateLock(DefaultResourceLockCoordinationService.lock(locks));
        try {
            action.run();
            Object var4_3 = null;
            this.coordinationService.withStateLock(DefaultResourceLockCoordinationService.unlock(locks));
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.coordinationService.withStateLock(DefaultResourceLockCoordinationService.unlock(locks));
            throw throwable;
        }
    }

    @Override
    public <T> T withoutLocks(Iterable<? extends ResourceLock> locks, Callable<T> action) {
        T t;
        block5: {
            if (!this.allLockedByCurrentThread(locks)) {
                throw new IllegalStateException("Not all of the locks specified are currently held by the current thread.  This could lead to orphaned locks.");
            }
            this.coordinationService.withStateLock(DefaultResourceLockCoordinationService.unlock(locks));
            try {
                t = action.call();
                Object var5_5 = null;
                if (this.coordinationService.withStateLock(DefaultResourceLockCoordinationService.tryLock(locks))) break block5;
                this.releaseWorkerLeaseAndWaitFor(locks);
            }
            catch (Exception e) {
                try {
                    throw new UncheckedException(e);
                }
                catch (Throwable throwable) {
                    block6: {
                        Object var5_6 = null;
                        if (this.coordinationService.withStateLock(DefaultResourceLockCoordinationService.tryLock(locks))) break block6;
                        this.releaseWorkerLeaseAndWaitFor(locks);
                    }
                    throw throwable;
                }
            }
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void withoutLocks(Iterable<? extends ResourceLock> locks, Runnable action) {
        if (!this.allLockedByCurrentThread(locks)) {
            throw new IllegalStateException("Not all of the locks specified are currently held by the current thread.  This could lead to orphaned locks.");
        }
        this.coordinationService.withStateLock(DefaultResourceLockCoordinationService.unlock(locks));
        try {
            action.run();
            Object var4_3 = null;
            if (!this.coordinationService.withStateLock(DefaultResourceLockCoordinationService.tryLock(locks))) {
                this.releaseWorkerLeaseAndWaitFor(locks);
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!this.coordinationService.withStateLock(DefaultResourceLockCoordinationService.tryLock(locks))) {
                this.releaseWorkerLeaseAndWaitFor(locks);
            }
            throw throwable;
        }
    }

    private void releaseWorkerLeaseAndWaitFor(Iterable<? extends ResourceLock> locks) {
        WorkerLeaseRegistry.WorkerLease workerLease = this.getCurrentWorkerLease();
        ArrayList allLocks = Lists.newArrayList();
        allLocks.add(workerLease);
        Iterables.addAll((Collection)allLocks, locks);
        this.coordinationService.withStateLock(DefaultResourceLockCoordinationService.unlock(workerLease));
        this.coordinationService.withStateLock(DefaultResourceLockCoordinationService.lock(allLocks));
    }

    private boolean allLockedByCurrentThread(final Iterable<? extends ResourceLock> locks) {
        final AtomicBoolean allLocked = new AtomicBoolean();
        this.coordinationService.withStateLock(new Transformer<ResourceLockState.Disposition, ResourceLockState>(){

            @Override
            public ResourceLockState.Disposition transform(ResourceLockState resourceLockState) {
                allLocked.set(CollectionUtils.every(locks, new Spec<ResourceLock>(){

                    @Override
                    public boolean isSatisfiedBy(ResourceLock lock) {
                        return lock.isLockedByCurrentThread();
                    }
                }));
                return ResourceLockState.Disposition.FINISHED;
            }
        });
        return allLocked.get();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DefaultWorkerLease
    extends AbstractTrackedResourceLock
    implements LeaseHolder,
    WorkerLeaseRegistry.WorkerLeaseCompletion,
    WorkerLeaseRegistry.WorkerLease {
        private final LeaseHolder parent;
        private final Thread ownerThread;
        int children;
        boolean active;

        public DefaultWorkerLease(String displayName, ResourceLockCoordinationService coordinationService, Action<ResourceLock> lockAction, Action<ResourceLock> unlockAction, LeaseHolder parent, Thread ownerThread) {
            super(displayName, coordinationService, lockAction, unlockAction);
            this.parent = parent;
            this.ownerThread = ownerThread;
        }

        @Override
        protected boolean doIsLocked() {
            return this.active;
        }

        @Override
        protected boolean doIsLockedByCurrentThread() {
            return this.active && Thread.currentThread() == this.ownerThread;
        }

        @Override
        protected boolean acquireLock() {
            if (this.parent.grantLease()) {
                this.active = true;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Worker lease {} started ({} worker(s) in use).", (Object)this.getDisplayName(), (Object)((DefaultWorkerLeaseService)DefaultWorkerLeaseService.this).root.leasesInUse);
                }
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Build operation {} could not be started ({} worker(s) in use).", (Object)this.getDisplayName(), (Object)((DefaultWorkerLeaseService)DefaultWorkerLeaseService.this).root.leasesInUse);
            }
            return this.active;
        }

        @Override
        protected void releaseLock() {
            if (Thread.currentThread() != this.ownerThread) {
                throw new UnsupportedOperationException("Must complete operation from owner thread.");
            }
            this.parent.releaseLease();
            this.active = false;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Worker lease {} completed ({} worker(s) in use)", (Object)this.getDisplayName(), (Object)((DefaultWorkerLeaseService)DefaultWorkerLeaseService.this).root.leasesInUse);
            }
            if (this.children != 0) {
                throw new IllegalStateException("Some child operations have not yet completed.");
            }
        }

        @Override
        public boolean grantLease() {
            if (this.children == 0 || DefaultWorkerLeaseService.this.root.grantLease()) {
                ++this.children;
                return true;
            }
            return false;
        }

        @Override
        public void releaseLease() {
            --this.children;
            if (this.children > 0) {
                DefaultWorkerLeaseService.this.root.releaseLease();
            }
        }

        WorkerLeaseRegistry.WorkerLeaseCompletion start() {
            DefaultWorkerLeaseService.this.coordinationService.withStateLock(DefaultResourceLockCoordinationService.lock(this));
            return this;
        }

        @Override
        public WorkerLeaseRegistry.WorkerLease createChild() {
            return DefaultWorkerLeaseService.this.getWorkerLease(this);
        }

        @Override
        public WorkerLeaseRegistry.WorkerLeaseCompletion startChild() {
            return DefaultWorkerLeaseService.this.getWorkerLease(this).start();
        }

        @Override
        public void leaseFinish() {
            DefaultWorkerLeaseService.this.coordinationService.withStateLock(DefaultResourceLockCoordinationService.unlock(this));
        }
    }

    private class Root
    implements LeaseHolder {
        int leasesInUse;

        private Root() {
        }

        public String getDisplayName() {
            return "root";
        }

        public boolean grantLease() {
            if (this.leasesInUse >= DefaultWorkerLeaseService.this.maxWorkerCount) {
                return false;
            }
            ++this.leasesInUse;
            return true;
        }

        public void releaseLease() {
            --this.leasesInUse;
        }
    }

    private static interface LeaseHolder
    extends Describable {
        public boolean grantLease();

        public void releaseLease();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WorkerLeaseLockRegistry
    extends AbstractResourceLockRegistry<DefaultWorkerLease> {
        WorkerLeaseLockRegistry(ResourceLockCoordinationService coordinationService) {
            super(coordinationService);
        }

        DefaultWorkerLease getResourceLock(final LeaseHolder parent, int workerId, final Thread ownerThread) {
            String displayName = parent.getDisplayName() + '.' + workerId;
            return this.getOrRegisterResourceLock(displayName, new AbstractResourceLockRegistry.ResourceLockProducer<DefaultWorkerLease>(){

                @Override
                public DefaultWorkerLease create(String displayName, ResourceLockCoordinationService coordinationService, Action<ResourceLock> lockAction, Action<ResourceLock> unlockAction) {
                    return new DefaultWorkerLease(displayName, coordinationService, lockAction, unlockAction, parent, ownerThread);
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProjectLockRegistry
    extends AbstractResourceLockRegistry<ExclusiveAccessResourceLock> {
        private volatile boolean parallelEnabled;

        ProjectLockRegistry(ResourceLockCoordinationService coordinationService, boolean parallelEnabled) {
            super(coordinationService);
            this.parallelEnabled = parallelEnabled;
        }

        void setParallelEnabled(boolean parallelEnabled) {
            this.parallelEnabled = parallelEnabled;
        }

        ResourceLock getResourceLock(String gradlePath, String projectPath) {
            String displayName = projectPath;
            if (!this.parallelEnabled) {
                displayName = gradlePath;
            }
            return this.getOrRegisterResourceLock(displayName, new AbstractResourceLockRegistry.ResourceLockProducer<ExclusiveAccessResourceLock>(){

                @Override
                public ExclusiveAccessResourceLock create(String displayName, ResourceLockCoordinationService coordinationService, Action<ResourceLock> lockAction, Action<ResourceLock> unlockAction) {
                    return new ExclusiveAccessResourceLock(displayName, coordinationService, lockAction, unlockAction);
                }
            });
        }
    }
}

