/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.cpp.plugins;

import java.io.File;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.attributes.Usage;
import org.gradle.api.component.SoftwareComponent;
import org.gradle.api.internal.artifacts.publish.ArchivePublishArtifact;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.AppliedPlugin;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.api.publish.maven.internal.publication.MavenPublicationInternal;
import org.gradle.api.tasks.bundling.Zip;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.language.cpp.CppBinary;
import org.gradle.language.cpp.CppLibrary;
import org.gradle.language.cpp.internal.DefaultCppLibrary;
import org.gradle.language.cpp.internal.MainLibraryVariant;
import org.gradle.language.cpp.internal.NativeVariant;
import org.gradle.language.cpp.plugins.CppBasePlugin;

@Incubating
public class CppLibraryPlugin
implements Plugin<ProjectInternal> {
    private final FileOperations fileOperations;

    @Inject
    public CppLibraryPlugin(FileOperations fileOperations) {
        this.fileOperations = fileOperations;
    }

    @Override
    public void apply(final ProjectInternal project) {
        project.getPluginManager().apply(CppBasePlugin.class);
        final TaskContainerInternal tasks = project.getTasks();
        ConfigurationContainer configurations = project.getConfigurations();
        ObjectFactory objectFactory = project.getObjects();
        ProviderFactory providers = project.getProviders();
        final CppLibrary library = project.getExtensions().create(CppLibrary.class, "library", DefaultCppLibrary.class, "main", project.getLayout(), project.getObjects(), this.fileOperations, project.getConfigurations());
        project.getComponents().add(library);
        project.getComponents().add(library.getDebugSharedLibrary());
        project.getComponents().add(library.getReleaseSharedLibrary());
        library.getBaseName().set(project.getName());
        tasks.getByName("assemble").dependsOn(library.getDevelopmentBinary().getRuntimeFile());
        final Usage apiUsage = objectFactory.named(Usage.class, "cplusplus-api");
        final Configuration apiElements = (Configuration)configurations.maybeCreate("cppApiElements");
        apiElements.extendsFrom(library.getApiDependencies());
        apiElements.setCanBeResolved(false);
        apiElements.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, apiUsage);
        Provider<File> publicHeaders = providers.provider(new Callable<File>(){

            @Override
            public File call() throws Exception {
                Set<File> files = library.getPublicHeaderDirs().getFiles();
                if (files.size() != 1) {
                    throw new UnsupportedOperationException(String.format("The C++ library plugin currently requires exactly one public header directory, however there are %d directories configured: %s", files.size(), files));
                }
                return files.iterator().next();
            }
        });
        apiElements.getOutgoing().artifact(publicHeaders);
        Configuration implementation = library.getImplementationDependencies();
        final Usage linkUsage = objectFactory.named(Usage.class, "native-link");
        final Usage runtimeUsage = objectFactory.named(Usage.class, "native-runtime");
        final Configuration debugLinkElements = (Configuration)configurations.maybeCreate("debugLinkElements");
        debugLinkElements.extendsFrom(implementation);
        debugLinkElements.setCanBeResolved(false);
        debugLinkElements.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, linkUsage);
        debugLinkElements.getAttributes().attribute(CppBinary.DEBUGGABLE_ATTRIBUTE, true);
        debugLinkElements.getOutgoing().artifact(library.getDebugSharedLibrary().getLinkFile());
        final Configuration debugRuntimeElements = (Configuration)configurations.maybeCreate("debugRuntimeElements");
        debugRuntimeElements.extendsFrom(implementation);
        debugRuntimeElements.setCanBeResolved(false);
        debugRuntimeElements.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, runtimeUsage);
        debugRuntimeElements.getAttributes().attribute(CppBinary.DEBUGGABLE_ATTRIBUTE, true);
        debugRuntimeElements.getOutgoing().artifact(library.getDebugSharedLibrary().getRuntimeFile());
        final Configuration releaseLinkElements = (Configuration)configurations.maybeCreate("releaseLinkElements");
        releaseLinkElements.extendsFrom(implementation);
        releaseLinkElements.setCanBeResolved(false);
        releaseLinkElements.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, linkUsage);
        releaseLinkElements.getAttributes().attribute(CppBinary.DEBUGGABLE_ATTRIBUTE, false);
        releaseLinkElements.getOutgoing().artifact(library.getReleaseSharedLibrary().getLinkFile());
        final Configuration releaseRuntimeElements = (Configuration)configurations.maybeCreate("releaseRuntimeElements");
        releaseRuntimeElements.extendsFrom(implementation);
        releaseRuntimeElements.setCanBeResolved(false);
        releaseRuntimeElements.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, runtimeUsage);
        releaseRuntimeElements.getAttributes().attribute(CppBinary.DEBUGGABLE_ATTRIBUTE, false);
        releaseRuntimeElements.getOutgoing().artifact(library.getReleaseSharedLibrary().getRuntimeFile());
        project.getPluginManager().withPlugin("maven-publish", (Action<? super AppliedPlugin>)new Action<AppliedPlugin>(){

            @Override
            public void execute(AppliedPlugin appliedPlugin) {
                Zip headersZip = tasks.create("cppHeaders", Zip.class);
                headersZip.from(library.getPublicHeaderFiles());
                headersZip.setDestinationDir(new File(project.getBuildDir(), "headers"));
                headersZip.setClassifier("cpp-api-headers");
                headersZip.setArchiveName("cpp-api-headers.zip");
                final MainLibraryVariant mainVariant = new MainLibraryVariant("api", apiUsage, (Set<? extends PublishArtifact>)ImmutableSet.of((Object)new ArchivePublishArtifact(headersZip)), apiElements);
                NativeVariant debugVariant = new NativeVariant("debug", linkUsage, debugLinkElements, runtimeUsage, debugRuntimeElements);
                mainVariant.addVariant(debugVariant);
                NativeVariant releaseVariant = new NativeVariant("release", linkUsage, releaseLinkElements, runtimeUsage, releaseRuntimeElements);
                mainVariant.addVariant(releaseVariant);
                project.getExtensions().configure(PublishingExtension.class, new Action<PublishingExtension>(){

                    @Override
                    public void execute(PublishingExtension extension) {
                        extension.getPublications().create("main", MavenPublication.class, new Action<MavenPublication>(){

                            @Override
                            public void execute(MavenPublication publication) {
                                publication.setGroupId(project.getGroup().toString());
                                publication.setArtifactId((String)library.getBaseName().get());
                                publication.setVersion(project.getVersion().toString());
                                publication.from(mainVariant);
                                ((MavenPublicationInternal)publication).publishWithOriginalFileName();
                            }
                        });
                        for (final SoftwareComponent softwareComponent : mainVariant.getVariants()) {
                            extension.getPublications().create(softwareComponent.getName(), MavenPublication.class, new Action<MavenPublication>(){

                                @Override
                                public void execute(MavenPublication publication) {
                                    publication.setGroupId(project.getGroup().toString());
                                    publication.setArtifactId((String)library.getBaseName().get() + "_" + softwareComponent.getName());
                                    publication.setVersion(project.getVersion().toString());
                                    publication.from(softwareComponent);
                                    ((MavenPublicationInternal)publication).publishWithOriginalFileName();
                                }
                            });
                        }
                    }
                });
            }
        });
    }
}

