/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.swift.internal;

import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.attributes.Usage;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.language.cpp.CppBinary;
import org.gradle.language.nativeplatform.internal.Names;
import org.gradle.language.swift.SwiftBinary;

public class DefaultSwiftBinary
implements SwiftBinary {
    private final String name;
    private final Provider<String> module;
    private final boolean debuggable;
    private final boolean testable;
    private final FileCollection source;
    private final FileCollection compileModules;
    private final FileCollection linkLibs;
    private final Configuration runtimeLibs;
    private final DirectoryProperty objectsDir;
    private final RegularFileProperty moduleFile;

    public DefaultSwiftBinary(String name, ProjectLayout projectLayout, ObjectFactory objectFactory, Provider<String> module, boolean debuggable, boolean testable, FileCollection source, ConfigurationContainer configurations, Configuration implementation) {
        this.name = name;
        this.module = module;
        this.debuggable = debuggable;
        this.testable = testable;
        this.source = source;
        this.objectsDir = projectLayout.directoryProperty();
        this.moduleFile = projectLayout.fileProperty();
        Names names = Names.of(name);
        Configuration importPathConfig = (Configuration)configurations.maybeCreate(names.withPrefix("swiftCompile"));
        importPathConfig.extendsFrom(implementation);
        importPathConfig.setCanBeConsumed(false);
        importPathConfig.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, objectFactory.named(Usage.class, "swift-api"));
        importPathConfig.getAttributes().attribute(CppBinary.DEBUGGABLE_ATTRIBUTE, debuggable);
        Configuration nativeLink = (Configuration)configurations.maybeCreate(names.withPrefix("nativeLink"));
        nativeLink.extendsFrom(implementation);
        nativeLink.setCanBeConsumed(false);
        nativeLink.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, objectFactory.named(Usage.class, "native-link"));
        nativeLink.getAttributes().attribute(CppBinary.DEBUGGABLE_ATTRIBUTE, debuggable);
        Configuration nativeRuntime = (Configuration)configurations.maybeCreate(names.withPrefix("nativeRuntime"));
        nativeRuntime.extendsFrom(implementation);
        nativeRuntime.setCanBeConsumed(false);
        nativeRuntime.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, objectFactory.named(Usage.class, "native-runtime"));
        nativeRuntime.getAttributes().attribute(CppBinary.DEBUGGABLE_ATTRIBUTE, debuggable);
        this.compileModules = importPathConfig;
        this.linkLibs = nativeLink;
        this.runtimeLibs = nativeRuntime;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Provider<String> getModule() {
        return this.module;
    }

    @Override
    public boolean isDebuggable() {
        return this.debuggable;
    }

    @Override
    public boolean isTestable() {
        return this.testable;
    }

    @Override
    public FileCollection getSwiftSource() {
        return this.source;
    }

    @Override
    public FileCollection getCompileModules() {
        return this.compileModules;
    }

    @Override
    public FileCollection getLinkLibraries() {
        return this.linkLibs;
    }

    @Override
    public FileCollection getRuntimeLibraries() {
        return this.runtimeLibs;
    }

    public DirectoryProperty getObjectsDir() {
        return this.objectsDir;
    }

    public RegularFileProperty getModuleFile() {
        return this.moduleFile;
    }

    @Override
    public FileCollection getObjects() {
        return this.objectsDir.getAsFileTree().matching(new PatternSet().include("**/*.obj", "**/*.o"));
    }
}

