/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.schema.extract;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.concurrent.ExecutionException;
import org.gradle.api.Action;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.impldep.com.google.common.cache.CacheBuilder;
import org.gradle.internal.impldep.com.google.common.cache.CacheLoader;
import org.gradle.internal.impldep.com.google.common.cache.LoadingCache;
import org.gradle.model.ModelMap;
import org.gradle.model.internal.core.NodeBackedModelMap;
import org.gradle.model.internal.manage.schema.ModelSchema;
import org.gradle.model.internal.manage.schema.SpecializedMapSchema;
import org.gradle.model.internal.manage.schema.extract.ManagedCollectionProxyClassGenerator;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaExtractionContext;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaExtractionStrategy;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpecializedMapStrategy
implements ModelSchemaExtractionStrategy {
    private final ManagedCollectionProxyClassGenerator generator = new ManagedCollectionProxyClassGenerator();
    private final LoadingCache<ModelType<?>, Class<?>> generatedImplementationTypes = CacheBuilder.newBuilder().weakValues().build(new CacheLoader<ModelType<?>, Class<?>>(){

        public Class<?> load(ModelType<?> contractType) throws Exception {
            return SpecializedMapStrategy.this.generator.generate(NodeBackedModelMap.class, contractType.getConcreteClass());
        }
    });

    @Override
    public <T> void extract(ModelSchemaExtractionContext<T> extractionContext) {
        Class proxyImpl;
        ModelType<T> modelType = extractionContext.getType();
        if (!modelType.isClass()) {
            return;
        }
        Class<T> contractType = modelType.getConcreteClass();
        if (!contractType.isInterface()) {
            return;
        }
        if (contractType.getGenericInterfaces().length != 1) {
            return;
        }
        Type superType = contractType.getGenericInterfaces()[0];
        if (!(superType instanceof ParameterizedType)) {
            return;
        }
        ParameterizedType parameterizedSuperType = (ParameterizedType)superType;
        if (!parameterizedSuperType.getRawType().equals(ModelMap.class)) {
            return;
        }
        ModelType<?> elementType = ModelType.of(parameterizedSuperType.getActualTypeArguments()[0]);
        try {
            proxyImpl = (Class)this.generatedImplementationTypes.get(modelType);
        }
        catch (ExecutionException e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
        extractionContext.found(this.getModelSchema(extractionContext, elementType, proxyImpl));
    }

    private <T, E> SpecializedMapSchema<T, E> getModelSchema(ModelSchemaExtractionContext<T> extractionContext, ModelType<E> elementType, Class<?> implementationType) {
        final SpecializedMapSchema<T, E> schema = new SpecializedMapSchema<T, E>(extractionContext.getType(), elementType, implementationType);
        extractionContext.child(elementType, "element type", new Action<ModelSchema<E>>(){

            @Override
            public void execute(ModelSchema<E> elementTypeSchema) {
                schema.setElementTypeSchema(elementTypeSchema);
            }
        });
        return schema;
    }
}

