/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.internal;

import java.io.File;
import org.gradle.internal.file.RelativeFilePathResolver;
import org.gradle.internal.hash.HashUtil;
import org.gradle.internal.impldep.org.apache.commons.io.FilenameUtils;

public class CompilerOutputFileNamingScheme {
    private String objectFileNameSuffix;
    private File outputBaseFolder;
    private final RelativeFilePathResolver fileResolver;

    public CompilerOutputFileNamingScheme(RelativeFilePathResolver fileResolver) {
        this.fileResolver = fileResolver;
    }

    public CompilerOutputFileNamingScheme withOutputBaseFolder(File outputBaseFolder) {
        this.outputBaseFolder = outputBaseFolder;
        return this;
    }

    public CompilerOutputFileNamingScheme withObjectFileNameSuffix(String suffix) {
        this.objectFileNameSuffix = suffix;
        return this;
    }

    public File map(File sourceFile) {
        String baseName = FilenameUtils.removeExtension((String)sourceFile.getName());
        String uniqueName = this.generateUniqueNameFor(sourceFile);
        File hashDirectory = new File(this.outputBaseFolder, uniqueName);
        return new File(hashDirectory, baseName + this.objectFileNameSuffix);
    }

    protected String generateUniqueNameFor(File sourceFile) {
        return HashUtil.createCompactMD5(this.fileResolver.resolveAsRelativePath(sourceFile));
    }
}

