/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.test.tasks;

import java.io.File;
import org.gradle.api.GradleException;
import org.gradle.api.Incubating;
import org.gradle.api.tasks.AbstractExecTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.logging.ConsoleRenderer;

@Incubating
public class RunTestExecutable
extends AbstractExecTask<RunTestExecutable> {
    private File outputDir;
    private boolean ignoreFailures;

    public RunTestExecutable() {
        super(RunTestExecutable.class);
    }

    @Override
    @TaskAction
    protected void exec() {
        this.getOutputDir().mkdirs();
        this.setExecutable(this.getExecutable());
        this.setWorkingDir(this.getOutputDir());
        try {
            super.exec();
        }
        catch (Exception e) {
            this.handleTestFailures(e);
        }
    }

    private void handleTestFailures(Exception e) {
        String message = "There were failing tests";
        String resultsUrl = new ConsoleRenderer().asClickableFileUrl(this.getOutputDir());
        message = message.concat(". See the results at: " + resultsUrl);
        if (!this.isIgnoreFailures()) {
            throw new GradleException(message, e);
        }
        this.getLogger().warn(message);
    }

    @Internal
    public File getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(File outputDir) {
        this.outputDir = outputDir;
    }

    @Input
    public boolean getIgnoreFailures() {
        return this.ignoreFailures;
    }

    public boolean isIgnoreFailures() {
        return this.ignoreFailures;
    }

    public void setIgnoreFailures(boolean ignoreFailures) {
        this.ignoreFailures = ignoreFailures;
    }
}

