/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.test.xctest.internal;

import java.io.File;
import java.util.ArrayDeque;
import javax.inject.Inject;
import org.gradle.api.internal.tasks.testing.DefaultTestClassRunInfo;
import org.gradle.api.internal.tasks.testing.TestClassProcessor;
import org.gradle.api.internal.tasks.testing.TestClassRunInfo;
import org.gradle.api.internal.tasks.testing.TestExecuter;
import org.gradle.api.internal.tasks.testing.TestResultProcessor;
import org.gradle.api.internal.tasks.testing.processors.TestMainAction;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.tasks.testing.TestOutputEvent;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.id.LongIdGenerator;
import org.gradle.internal.io.LineBufferingOutputStream;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.time.Clock;
import org.gradle.nativeplatform.test.xctest.internal.XCTestDescriptor;
import org.gradle.nativeplatform.test.xctest.internal.XCTestTestExecutionSpec;
import org.gradle.nativeplatform.test.xctest.internal.XcTestScraper;
import org.gradle.process.internal.DefaultExecHandleBuilder;
import org.gradle.process.internal.ExecHandle;
import org.gradle.process.internal.ExecHandleBuilder;

public class XcTestExecuter
implements TestExecuter<XCTestTestExecutionSpec> {
    public ExecHandleBuilder getExecHandleBuilder() {
        return new DefaultExecHandleBuilder();
    }

    @Inject
    public BuildOperationExecutor getBuildOperationExcecutor() {
        throw new UnsupportedOperationException();
    }

    public IdGenerator<?> getIdGenerator() {
        return new LongIdGenerator();
    }

    @Inject
    public ObjectFactory getObjectFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    public Clock getTimeProvider() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void execute(XCTestTestExecutionSpec testTestExecutionSpec, TestResultProcessor testResultProcessor) {
        ObjectFactory objectFactory = this.getObjectFactory();
        File executable = testTestExecutionSpec.getRunScript();
        File workingDir = testTestExecutionSpec.getWorkingDir();
        TestClassProcessor processor = objectFactory.newInstance(XcTestProcessor.class, executable, workingDir, this.getExecHandleBuilder(), this.getIdGenerator());
        XcTestDetector detector = new XcTestDetector(processor);
        Object testTaskOperationId = this.getBuildOperationExcecutor().getCurrentOperation().getParentId();
        new TestMainAction(detector, processor, testResultProcessor, this.getTimeProvider(), testTaskOperationId, testTestExecutionSpec.getPath(), "Gradle Test Run " + testTestExecutionSpec.getPath()).run();
    }

    static class XcTestProcessor
    implements TestClassProcessor {
        private TestResultProcessor resultProcessor;
        private ExecHandle execHandle;
        private final ExecHandleBuilder execHandleBuilder;
        private final IdGenerator<?> idGenerator;
        private final Clock clock;

        @Inject
        public XcTestProcessor(Clock clock, File executable, File workingDir, ExecHandleBuilder execHandleBuilder, IdGenerator<?> idGenerator) {
            this.execHandleBuilder = execHandleBuilder;
            this.idGenerator = idGenerator;
            this.clock = clock;
            execHandleBuilder.executable(executable);
            execHandleBuilder.setWorkingDir(workingDir);
        }

        @Override
        public void startProcessing(TestResultProcessor resultProcessor) {
            this.resultProcessor = resultProcessor;
        }

        @Override
        public void processTestClass(TestClassRunInfo testClass) {
            this.execHandle = this.executeTest(testClass.getTestClassName());
            this.execHandle.waitForFinish();
        }

        private ExecHandle executeTest(String testName) {
            ArrayDeque<XCTestDescriptor> testDescriptors = new ArrayDeque<XCTestDescriptor>();
            XcTestScraper stdOut = new XcTestScraper(TestOutputEvent.Destination.StdOut, this.resultProcessor, this.idGenerator, this.clock, testDescriptors);
            XcTestScraper stdErr = new XcTestScraper(TestOutputEvent.Destination.StdErr, this.resultProcessor, this.idGenerator, this.clock, testDescriptors);
            this.execHandleBuilder.setStandardOutput(new LineBufferingOutputStream(stdOut));
            this.execHandleBuilder.setErrorOutput(new LineBufferingOutputStream(stdErr));
            ExecHandle handle = this.execHandleBuilder.build();
            return handle.start();
        }

        @Override
        public void stop() {
            if (this.execHandle != null) {
                this.execHandle.abort();
                this.execHandle.waitForFinish();
            }
        }
    }

    private static class XcTestDetector
    implements Runnable {
        private final TestClassProcessor testClassProcessor;

        XcTestDetector(TestClassProcessor testClassProcessor) {
            this.testClassProcessor = testClassProcessor;
        }

        @Override
        public void run() {
            DefaultTestClassRunInfo testClass = new DefaultTestClassRunInfo("All");
            this.testClassProcessor.processTestClass(testClass);
        }
    }
}

