/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal.msvcpp;

import java.io.File;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.work.WorkerLeaseService;
import org.gradle.nativeplatform.internal.CompilerOutputFileNamingSchemeFactory;
import org.gradle.nativeplatform.platform.internal.NativePlatformInternal;
import org.gradle.nativeplatform.toolchain.VisualCpp;
import org.gradle.nativeplatform.toolchain.VisualCppPlatformToolChain;
import org.gradle.nativeplatform.toolchain.internal.ExtendableToolChain;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;
import org.gradle.nativeplatform.toolchain.internal.UnavailablePlatformToolProvider;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.DefaultVisualCppPlatformToolChain;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.Ucrt;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.UcrtLocator;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.VisualCppInstall;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.VisualCppPlatformToolProvider;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.VisualStudioLocator;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.WindowsKitComponentLocator;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.WindowsSdk;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.WindowsSdkLocator;
import org.gradle.platform.base.internal.toolchain.ToolChainAvailability;
import org.gradle.process.internal.ExecActionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VisualCppToolChain
extends ExtendableToolChain<VisualCppPlatformToolChain>
implements VisualCpp,
NativeToolChainInternal {
    private final String name;
    private final OperatingSystem operatingSystem;
    protected static final Logger LOGGER = LoggerFactory.getLogger(VisualCppToolChain.class);
    public static final String DEFAULT_NAME = "visualCpp";
    private final ExecActionFactory execActionFactory;
    private final VisualStudioLocator visualStudioLocator;
    private final WindowsSdkLocator windowsSdkLocator;
    private final UcrtLocator ucrtLocator;
    private final Instantiator instantiator;
    private final CompilerOutputFileNamingSchemeFactory compilerOutputFileNamingSchemeFactory;
    private final WorkerLeaseService workerLeaseService;
    private File installDir;
    private File ucrtDir;
    private File windowsSdkDir;
    private Ucrt ucrt;
    private VisualCppInstall visualCpp;
    private WindowsSdk windowsSdk;
    private ToolChainAvailability availability;

    public VisualCppToolChain(String name, BuildOperationExecutor buildOperationExecutor, OperatingSystem operatingSystem, FileResolver fileResolver, ExecActionFactory execActionFactory, CompilerOutputFileNamingSchemeFactory compilerOutputFileNamingSchemeFactory, VisualStudioLocator visualStudioLocator, WindowsSdkLocator windowsSdkLocator, UcrtLocator ucrtLocator, Instantiator instantiator, WorkerLeaseService workerLeaseService) {
        super(name, buildOperationExecutor, operatingSystem, fileResolver);
        this.name = name;
        this.operatingSystem = operatingSystem;
        this.execActionFactory = execActionFactory;
        this.compilerOutputFileNamingSchemeFactory = compilerOutputFileNamingSchemeFactory;
        this.visualStudioLocator = visualStudioLocator;
        this.windowsSdkLocator = windowsSdkLocator;
        this.ucrtLocator = ucrtLocator;
        this.instantiator = instantiator;
        this.workerLeaseService = workerLeaseService;
    }

    @Override
    protected String getTypeName() {
        return "Visual Studio";
    }

    @Override
    public File getInstallDir() {
        return this.installDir;
    }

    @Override
    public void setInstallDir(Object installDirPath) {
        this.installDir = this.resolve(installDirPath);
    }

    @Override
    public File getWindowsSdkDir() {
        return this.windowsSdkDir;
    }

    @Override
    public void setWindowsSdkDir(Object windowsSdkDirPath) {
        this.windowsSdkDir = this.resolve(windowsSdkDirPath);
    }

    public File getUcrtDir() {
        return this.ucrtDir;
    }

    public void setUcrtDir(Object ucrtDirPath) {
        this.ucrtDir = this.resolve(ucrtDirPath);
    }

    @Override
    public PlatformToolProvider select(NativePlatformInternal targetPlatform) {
        ToolChainAvailability result = new ToolChainAvailability();
        result.mustBeAvailable(this.getAvailability());
        if (this.visualCpp != null && !this.visualCpp.isSupportedPlatform(targetPlatform)) {
            result.unavailable(String.format("Don't know how to build for platform '%s'.", targetPlatform.getName()));
        }
        if (!result.isAvailable()) {
            return new UnavailablePlatformToolProvider(targetPlatform.getOperatingSystem(), result);
        }
        DefaultVisualCppPlatformToolChain configurableToolChain = this.instantiator.newInstance(DefaultVisualCppPlatformToolChain.class, targetPlatform, this.instantiator);
        this.configureActions.execute(configurableToolChain);
        return new VisualCppPlatformToolProvider(this.buildOperationExecutor, targetPlatform.getOperatingSystem(), configurableToolChain.tools, this.visualCpp, this.windowsSdk, this.ucrt, targetPlatform, this.execActionFactory, this.compilerOutputFileNamingSchemeFactory, this.workerLeaseService);
    }

    private ToolChainAvailability getAvailability() {
        if (this.availability == null) {
            this.availability = new ToolChainAvailability();
            this.checkAvailable(this.availability);
        }
        return this.availability;
    }

    private void checkAvailable(ToolChainAvailability availability) {
        if (!this.operatingSystem.isWindows()) {
            availability.unavailable("Visual Studio is not available on this operating system.");
            return;
        }
        VisualStudioLocator.SearchResult visualStudioSearchResult = this.visualStudioLocator.locateDefaultVisualStudioInstall(this.installDir);
        availability.mustBeAvailable(visualStudioSearchResult);
        if (visualStudioSearchResult.isAvailable()) {
            this.visualCpp = visualStudioSearchResult.getVisualStudio().getVisualCpp();
        }
        WindowsSdkLocator.SearchResult windowsSdkSearchResult = this.windowsSdkLocator.locateWindowsSdks(this.windowsSdkDir);
        availability.mustBeAvailable(windowsSdkSearchResult);
        if (windowsSdkSearchResult.isAvailable()) {
            this.windowsSdk = windowsSdkSearchResult.getSdk();
        }
        if (this.isVisualCpp2015()) {
            WindowsKitComponentLocator.SearchResult ucrtSearchResult = this.ucrtLocator.locateComponents(this.ucrtDir);
            availability.mustBeAvailable(ucrtSearchResult);
            if (ucrtSearchResult.isAvailable()) {
                this.ucrt = (Ucrt)ucrtSearchResult.getComponent();
            }
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDisplayName() {
        return "Tool chain '" + this.getName() + "' (" + this.getTypeName() + ")";
    }

    public boolean isVisualCpp2015() {
        return this.visualCpp != null && this.visualCpp.getVersion().getMajor() >= 14;
    }
}

