/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.signing;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.DefaultDomainObjectSet;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputFiles;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.internal.impldep.com.google.common.base.Function;
import org.gradle.internal.impldep.com.google.common.base.Predicate;
import org.gradle.internal.impldep.com.google.common.base.Predicates;
import org.gradle.internal.impldep.com.google.common.collect.ArrayListMultimap;
import org.gradle.internal.impldep.com.google.common.collect.Iterables;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.plugins.signing.Signature;
import org.gradle.plugins.signing.SignatureSpec;
import org.gradle.plugins.signing.signatory.Signatory;
import org.gradle.plugins.signing.signatory.pgp.PgpKeyId;
import org.gradle.plugins.signing.signatory.pgp.PgpSignatory;
import org.gradle.plugins.signing.type.SignatureType;

public class Sign
extends DefaultTask
implements SignatureSpec {
    private static final Pattern JAVA_PARTS = Pattern.compile("[^\\p{javaJavaIdentifierPart}]");
    private static final Function<Signature, File> SIGNATURE_TO_SIGN_FILE_FUNCTION = new Function<Signature, File>(){

        public File apply(Signature input) {
            return input.getToSign();
        }
    };
    private static final Function<Signature, File> SIGNATURE_FILE_FUNCTION = new Function<Signature, File>(){

        public File apply(Signature input) {
            return input.getFile();
        }
    };
    @Internal
    private SignatureType signatureType;
    @Internal
    private Signatory signatory;
    private boolean required = true;
    private final DefaultDomainObjectSet<Signature> signatures = new DefaultDomainObjectSet<Signature>(Signature.class);

    public Sign() {
        this.onlyIf((Spec<? super Task>)new Spec<Task>(){

            @Override
            public boolean isSatisfiedBy(Task element) {
                return Sign.this.isRequired() || Sign.this.getSignatory() != null;
            }
        });
        this.getInputs().property("signatory", new Callable<String>(){

            @Override
            public String call() throws Exception {
                PgpSignatory signatory = (PgpSignatory)Sign.this.getSignatory();
                PgpKeyId id = signatory == null ? null : signatory.getKeyId();
                return id == null ? null : id.getAsHex();
            }
        }).optional(true);
    }

    @InputFiles
    public Iterable<File> getInputFiles() {
        return Iterables.transform(this.signatures, SIGNATURE_TO_SIGN_FILE_FUNCTION);
    }

    @OutputFiles
    public Map<String, File> getOutputFiles() {
        ArrayListMultimap filesWithPotentialNameCollisions = ArrayListMultimap.create();
        for (Signature signature : this.getSignatures()) {
            String name = JAVA_PARTS.matcher(signature.getName()).replaceAll("_");
            if (name.length() > 0 && !Character.isJavaIdentifierStart(name.codePointAt(0))) {
                name = "_" + name.substring(1);
            }
            filesWithPotentialNameCollisions.put((Object)name, (Object)signature.getToSign());
        }
        HashMap files = Maps.newHashMap();
        for (Map.Entry entry : filesWithPotentialNameCollisions.asMap().entrySet()) {
            File[] filesWithSameName = ((Collection)entry.getValue()).toArray(new File[0]);
            boolean hasMoreThanOneFileWithSameName = filesWithSameName.length > 1;
            for (int i = 0; i < filesWithSameName.length; ++i) {
                File file = filesWithSameName[i];
                String key = (String)entry.getKey();
                if (hasMoreThanOneFileWithSameName) {
                    key = key + "$" + (i + 1);
                }
                files.put(key, file);
            }
        }
        return files;
    }

    public void sign(Task ... tasks) {
        for (Task task : tasks) {
            if (!(task instanceof AbstractArchiveTask)) {
                throw new InvalidUserDataException("You cannot sign tasks that are not 'archive' tasks, such as 'jar', 'zip' etc. (you tried to sign " + String.valueOf(task) + ")");
            }
            this.signTask((AbstractArchiveTask)task);
        }
    }

    private void signTask(final AbstractArchiveTask archiveTask) {
        this.dependsOn(archiveTask);
        this.addSignature(new Signature(new Callable<File>(){

            @Override
            public File call() {
                return archiveTask.getArchivePath();
            }
        }, new Callable<String>(){

            @Override
            public String call() {
                return archiveTask.getClassifier();
            }
        }, (SignatureSpec)this, this));
    }

    public void sign(PublishArtifact ... publishArtifacts) {
        for (PublishArtifact publishArtifact : publishArtifacts) {
            this.signArtifact(publishArtifact);
        }
    }

    private void signArtifact(PublishArtifact publishArtifact) {
        this.dependsOn(publishArtifact);
        this.addSignature(new Signature(publishArtifact, (SignatureSpec)this, this));
    }

    public void sign(File ... files) {
        this.addSignatures(null, files);
    }

    public void sign(String classifier, File ... files) {
        this.addSignatures(classifier, files);
    }

    private void addSignatures(String classifier, File[] files) {
        for (File file : files) {
            this.addSignature(new Signature(file, classifier, (SignatureSpec)this, this));
        }
    }

    public void sign(Configuration ... configurations) {
        for (Configuration configuration : configurations) {
            configuration.getAllArtifacts().all(new Action<PublishArtifact>(){

                @Override
                public void execute(PublishArtifact artifact) {
                    if (artifact instanceof Signature) {
                        return;
                    }
                    Sign.this.signArtifact(artifact);
                }
            });
            configuration.getAllArtifacts().whenObjectRemoved(new Action<PublishArtifact>(){

                @Override
                public void execute(final PublishArtifact publishArtifact) {
                    Sign.this.signatures.remove(Iterables.find((Iterable)Sign.this.signatures, (Predicate)new Predicate<Signature>(){

                        public boolean apply(Signature input) {
                            return input.getToSignArtifact().equals(publishArtifact);
                        }
                    }));
                }
            });
        }
    }

    private boolean addSignature(Signature signature) {
        return this.signatures.add(signature);
    }

    public void signatory(Signatory signatory) {
        this.signatory = signatory;
    }

    public void required(boolean required) {
        this.setRequired(required);
    }

    @TaskAction
    public void generate() {
        if (this.getSignatory() == null) {
            throw new InvalidUserDataException("Cannot perform signing task '" + this.getPath() + "' because it has no configured signatory");
        }
        for (Signature signature : this.signatures) {
            signature.generate();
        }
    }

    @Internal
    public DomainObjectSet<Signature> getSignatures() {
        return this.signatures;
    }

    @Internal
    public Signature getSingleSignature() {
        DomainObjectSet<Signature> signatureSet = this.getSignatures();
        if (signatureSet.size() == 0) {
            throw new IllegalStateException("Expected %s to contain exactly one signature, however, it contains no signatures.");
        }
        if (signatureSet.size() == 1) {
            return (Signature)signatureSet.iterator().next();
        }
        throw new IllegalStateException("Expected %s to contain exactly one signature, however, it contains no " + String.valueOf(signatureSet.size()) + " signatures.");
    }

    @Inject
    protected FileCollectionFactory getFileCollectionFactory() {
        throw new UnsupportedOperationException();
    }

    @Internal
    public FileCollection getFilesToSign() {
        return this.getFileCollectionFactory().fixed("Task '" + this.getPath() + "' files to sign", Lists.newLinkedList((Iterable)Iterables.filter(this.getInputFiles(), (Predicate)Predicates.notNull())));
    }

    @Internal
    public FileCollection getSignatureFiles() {
        return this.getFileCollectionFactory().fixed("Task '" + this.getPath() + "' signature files", Lists.newLinkedList((Iterable)Iterables.filter((Iterable)Iterables.transform(this.signatures, SIGNATURE_FILE_FUNCTION), (Predicate)Predicates.notNull())));
    }

    @Override
    public SignatureType getSignatureType() {
        return this.signatureType;
    }

    @Override
    public void setSignatureType(SignatureType signatureType) {
        this.signatureType = signatureType;
    }

    @Override
    public Signatory getSignatory() {
        return this.signatory;
    }

    @Override
    public void setSignatory(Signatory signatory) {
        this.signatory = signatory;
    }

    @Override
    @Input
    public boolean isRequired() {
        return this.required;
    }

    @Override
    public void setRequired(boolean required) {
        this.required = required;
    }
}

