/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.Named;
import org.gradle.api.NamedDomainObjectSet;
import org.gradle.api.internal.DefaultDomainObjectSet;
import org.gradle.api.internal.DefaultNamedDomainObjectSet;
import org.gradle.internal.reflect.DirectInstantiator;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WrapUtil {
    public static <T> Set<T> toSet(T ... items) {
        HashSet coll = new HashSet();
        Collections.addAll(coll, items);
        return coll;
    }

    public static <T> DomainObjectSet<T> toDomainObjectSet(Class<T> type, T ... items) {
        return new DefaultDomainObjectSet<T>(type, WrapUtil.toSet(items));
    }

    public static <T extends Named> NamedDomainObjectSet<T> toNamedDomainObjectSet(Class<T> type, T ... items) {
        DefaultNamedDomainObjectSet<T> domainObjectSet = new DefaultNamedDomainObjectSet<T>(type, DirectInstantiator.INSTANCE);
        CollectionUtils.addAll(domainObjectSet, items);
        return domainObjectSet;
    }

    public static <T> Set<T> toLinkedSet(T ... items) {
        LinkedHashSet coll = new LinkedHashSet();
        Collections.addAll(coll, items);
        return coll;
    }

    public static <T> SortedSet<T> toSortedSet(T ... items) {
        TreeSet coll = new TreeSet();
        Collections.addAll(coll, items);
        return coll;
    }

    public static <T> SortedSet<T> toSortedSet(Comparator<T> comp, T ... items) {
        TreeSet<T> coll = new TreeSet<T>(comp);
        Collections.addAll(coll, items);
        return coll;
    }

    public static <T> List<T> toList(T ... items) {
        ArrayList coll = new ArrayList();
        Collections.addAll(coll, items);
        return coll;
    }

    public static <T> List<T> toList(Iterable<? extends T> items) {
        ArrayList<T> coll = new ArrayList<T>();
        for (T item : items) {
            coll.add(item);
        }
        return coll;
    }

    public static <K, V> Map<K, V> toMap(K key, V value) {
        HashMap<K, V> map = new HashMap<K, V>();
        map.put(key, value);
        return map;
    }

    public static <K, V> SortedMap<K, V> toSortedMap(K key, V value) {
        TreeMap<K, V> map = new TreeMap<K, V>();
        map.put(key, value);
        return map;
    }

    public static <K, V> Map<K, V> toLinkedMap(K key, V value) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        map.put(key, value);
        return map;
    }

    public static Properties toProperties(String key, String value) {
        Properties props = new Properties();
        props.setProperty(key, value);
        return props;
    }

    public static <T> T[] toArray(T ... items) {
        return items;
    }

    public static <T> Set<T> asSet(Collection<T> c) {
        return new LinkedHashSet<T>(c);
    }
}

