/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.workers.internal;

import javax.inject.Inject;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.workers.internal.ActionExecutionSpec;
import org.gradle.workers.internal.DefaultWorkResult;
import org.gradle.workers.internal.WorkerProtocol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultWorkerServer
implements WorkerProtocol<ActionExecutionSpec> {
    private final Instantiator instantiator;

    @Inject
    public DefaultWorkerServer(Instantiator instantiator) {
        this.instantiator = instantiator;
    }

    @Override
    public DefaultWorkResult execute(ActionExecutionSpec spec) {
        try {
            Class<? extends Runnable> implementationClass = spec.getImplementationClass();
            Runnable runnable = this.instantiator.newInstance(implementationClass, spec.getParams(implementationClass.getClassLoader()));
            runnable.run();
            return new DefaultWorkResult(true, null);
        }
        catch (Throwable t) {
            return new DefaultWorkResult(true, t);
        }
    }

    public String toString() {
        return "DefaultWorkerServer{}";
    }
}

