/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.ide.DataManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.net.HttpProxyConfigurable;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.config.SvnConfigureProxiesDialog;

public class NetworkSettingsPanel
implements ConfigurableUi<SvnConfiguration> {
    @NotNull
    private final Project myProject;
    private JPanel myMainPanel;
    private JCheckBox myUseCommonProxy;
    private LinkLabel<Object> myNavigateToCommonProxyLink;
    private JSpinner mySSHConnectionTimeout;
    private JSpinner mySSHReadTimeout;
    private JSpinner myHttpTimeout;
    private JBRadioButton mySSLv3RadioButton;
    private JBRadioButton myTLSv1RadioButton;
    private JBRadioButton myAllRadioButton;
    private JLabel mySSLExplicitly;
    private JButton myEditProxiesButton;

    public NetworkSettingsPanel(@NotNull Project project) {
        boolean jdkBugFixed;
        if (project == null) {
            NetworkSettingsPanel.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myUseCommonProxy.setText(SvnBundle.message("use.idea.proxy.as.default", ApplicationNamesInfo.getInstance().getProductName()));
        this.myNavigateToCommonProxyLink.setListener((aSource, aLinkData) -> {
            Settings settings = (Settings)Settings.KEY.getData(DataManager.getInstance().getDataContext((Component)this.myMainPanel));
            if (settings != null) {
                settings.select(settings.find(HttpProxyConfigurable.class));
            }
        }, null);
        this.myEditProxiesButton.addActionListener(e -> {
            SvnConfigureProxiesDialog dialog = new SvnConfigureProxiesDialog(this.myProject);
            dialog.show();
            this.myHttpTimeout.setValue(SvnConfiguration.getInstance(this.myProject).getHttpTimeout() / 1000L);
        });
        ButtonGroup bg = new ButtonGroup();
        bg.add((AbstractButton)this.mySSLv3RadioButton);
        bg.add((AbstractButton)this.myTLSv1RadioButton);
        bg.add((AbstractButton)this.myAllRadioButton);
        this.mySSLv3RadioButton.setEnabled(true);
        this.myTLSv1RadioButton.setEnabled(true);
        this.myAllRadioButton.setEnabled(true);
        this.mySSLExplicitly.setVisible(false);
        String version = SystemInfo.JAVA_RUNTIME_VERSION;
        boolean bl = jdkBugFixed = version.startsWith("1.7") || version.startsWith("1.8");
        if (!jdkBugFixed) {
            this.mySSLExplicitly.setVisible(true);
            this.mySSLExplicitly.setText("Setting 'All' value in this JDK version (" + version + ") is not recommended.");
        }
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            NetworkSettingsPanel.$$$reportNull$$$0(1);
        }
        return jPanel;
    }

    public void reset(@NotNull SvnConfiguration configuration) {
        if (configuration == null) {
            NetworkSettingsPanel.$$$reportNull$$$0(2);
        }
        this.myUseCommonProxy.setSelected(configuration.isIsUseDefaultProxy());
        this.mySSHConnectionTimeout.setValue(configuration.getSshConnectionTimeout() / 1000L);
        this.mySSHReadTimeout.setValue(configuration.getSshReadTimeout() / 1000L);
        this.myHttpTimeout.setValue(configuration.getHttpTimeout() / 1000L);
        if (SvnConfiguration.SSLProtocols.sslv3.equals((Object)configuration.getSslProtocols())) {
            this.mySSLv3RadioButton.setSelected(true);
        } else if (SvnConfiguration.SSLProtocols.tlsv1.equals((Object)configuration.getSslProtocols())) {
            this.myTLSv1RadioButton.setSelected(true);
        } else {
            this.myAllRadioButton.setSelected(true);
        }
    }

    public boolean isModified(@NotNull SvnConfiguration configuration) {
        if (configuration == null) {
            NetworkSettingsPanel.$$$reportNull$$$0(3);
        }
        if (configuration.isIsUseDefaultProxy() != this.myUseCommonProxy.isSelected()) {
            return true;
        }
        if (configuration.getSshConnectionTimeout() / 1000L != ((SpinnerNumberModel)this.mySSHConnectionTimeout.getModel()).getNumber().longValue()) {
            return true;
        }
        if (configuration.getSshReadTimeout() / 1000L != ((SpinnerNumberModel)this.mySSHReadTimeout.getModel()).getNumber().longValue()) {
            return true;
        }
        if (configuration.getHttpTimeout() / 1000L != ((SpinnerNumberModel)this.myHttpTimeout.getModel()).getNumber().longValue()) {
            return true;
        }
        return !this.getSelectedSSL().equals((Object)configuration.getSslProtocols());
    }

    public void apply(@NotNull SvnConfiguration configuration) {
        if (configuration == null) {
            NetworkSettingsPanel.$$$reportNull$$$0(4);
        }
        configuration.setIsUseDefaultProxy(this.myUseCommonProxy.isSelected());
        configuration.setSshConnectionTimeout(((SpinnerNumberModel)this.mySSHConnectionTimeout.getModel()).getNumber().longValue() * 1000L);
        configuration.setSshReadTimeout(((SpinnerNumberModel)this.mySSHReadTimeout.getModel()).getNumber().longValue() * 1000L);
        configuration.setHttpTimeout(((SpinnerNumberModel)this.myHttpTimeout.getModel()).getNumber().longValue() * 1000L);
        configuration.setSslProtocols(this.getSelectedSSL());
    }

    private SvnConfiguration.SSLProtocols getSelectedSSL() {
        if (this.myAllRadioButton.isSelected()) {
            return SvnConfiguration.SSLProtocols.all;
        }
        if (this.mySSLv3RadioButton.isSelected()) {
            return SvnConfiguration.SSLProtocols.sslv3;
        }
        if (this.myTLSv1RadioButton.isSelected()) {
            return SvnConfiguration.SSLProtocols.tlsv1;
        }
        throw new IllegalStateException();
    }

    private void createUIComponents() {
        SvnConfiguration configuration = SvnConfiguration.getInstance(this.myProject);
        this.myNavigateToCommonProxyLink = new LinkLabel(SvnBundle.message("navigate.to.idea.proxy.settings", new Object[0]), null);
        Long maximum = 1800000L;
        long connection = configuration.getSshConnectionTimeout() <= maximum ? configuration.getSshConnectionTimeout() : maximum.longValue();
        long read = configuration.getSshReadTimeout() <= maximum ? configuration.getSshReadTimeout() : maximum.longValue();
        this.mySSHConnectionTimeout = NetworkSettingsPanel.createSpinner(new SpinnerNumberModel((Number)(connection / 1000L), Long.valueOf(0L), maximum, (Number)10L));
        this.mySSHReadTimeout = NetworkSettingsPanel.createSpinner(new SpinnerNumberModel((Number)(read / 1000L), Long.valueOf(0L), maximum, (Number)10L));
        this.myHttpTimeout = NetworkSettingsPanel.createSpinner(new SpinnerNumberModel((Number)(read / 1000L), Long.valueOf(0L), maximum, (Number)10L));
    }

    private static JSpinner createSpinner(SpinnerModel sm) {
        JSpinner result = new JSpinner(sm);
        JComponent editor = result.getEditor();
        if (UIUtil.isUnderWin10LookAndFeel() && editor instanceof JSpinner.DefaultEditor) {
            ((JSpinner.DefaultEditor)editor).getTextField().setHorizontalAlignment(4);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/NetworkSettingsPanel";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/NetworkSettingsPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JBRadioButton jBRadioButton;
        JBRadioButton jBRadioButton2;
        JBRadioButton jBRadioButton3;
        JButton jButton;
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(10, 31, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(8, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(9, 0, 1, 31, 0, 3, 3, 3, null, null, null));
        this.myEditProxiesButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("button.text.edit.proxies"));
        jPanel2.add((Component)jButton, new GridConstraints(0, 0, 1, 1, 8, 0, 1, 0, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jBLabel.setFontColor(UIUtil.FontColor.BRIGHTER);
        jBLabel.setText("Edit 'servers' Subversion runtime configuration file");
        jPanel2.add((Component)jBLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jBLabel2.setFontColor(UIUtil.FontColor.BRIGHTER);
        this.$$$loadLabelText$$$((JLabel)jBLabel2, ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("use.idea.proxy.as.default.label.text"));
        jPanel.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 30, 8, 0, 0, 0, null, null, null, 3));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("HTTP timeout:");
        jPanel3.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JSpinner jSpinner = this.myHttpTimeout;
        jPanel3.add((Component)jSpinner, new GridConstraints(0, 1, 1, 1, 8, 0, 6, 0, null, new Dimension(70, -1), null));
        JLabel jLabel = new JLabel();
        jLabel.setText("seconds");
        jPanel3.add((Component)jLabel, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel4, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setText("SSH connection timeout:");
        jPanel4.add((Component)jBLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JSpinner jSpinner2 = this.mySSHConnectionTimeout;
        jPanel4.add((Component)jSpinner2, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, new Dimension(70, -1), null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("seconds");
        jPanel4.add((Component)jLabel2, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel5, new GridConstraints(5, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        JBLabel jBLabel5 = new JBLabel();
        jBLabel5.setText("SSH read timeout:");
        jPanel5.add((Component)jBLabel5, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JSpinner jSpinner3 = this.mySSHReadTimeout;
        jPanel5.add((Component)jSpinner3, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, new Dimension(70, -1), null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("seconds");
        jPanel5.add((Component)jLabel3, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel6, new GridConstraints(7, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        JBLabel jBLabel6 = new JBLabel();
        jBLabel6.setText("SSL protocols:");
        jBLabel6.setVerticalAlignment(0);
        jPanel6.add((Component)jBLabel6, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel7, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 3, null, null, null));
        this.mySSLv3RadioButton = jBRadioButton3 = new JBRadioButton();
        jBRadioButton3.setText("SSLv3");
        jPanel7.add((Component)jBRadioButton3, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myTLSv1RadioButton = jBRadioButton2 = new JBRadioButton();
        jBRadioButton2.setText("TLSv1");
        jPanel7.add((Component)jBRadioButton2, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myAllRadioButton = jBRadioButton = new JBRadioButton();
        jBRadioButton.setText("All");
        jPanel7.add((Component)jBRadioButton, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JBLabel jBLabel7 = new JBLabel();
        this.mySSLExplicitly = jBLabel7;
        jBLabel7.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jBLabel7.setFontColor(UIUtil.FontColor.BRIGHTER);
        jBLabel7.setText("");
        jPanel6.add((Component)jBLabel7, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, null, null, 1));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(6, 0, 1, 1, 0, 2, 1, 0, new Dimension(-1, 15), new Dimension(-1, 15), new Dimension(-1, 15)));
        Spacer spacer4 = new Spacer();
        jPanel.add((Component)spacer4, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 0, new Dimension(-1, 15), new Dimension(-1, 15), new Dimension(-1, 15)));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new BorderLayout(0, 0));
        jPanel.add((Component)jPanel8, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myUseCommonProxy = jCheckBox = new JCheckBox();
        jCheckBox.setText("Use IDEA general proxy settings as default for Subversion");
        jPanel8.add((Component)jCheckBox, "West");
        LinkLabel<Object> linkLabel = this.myNavigateToCommonProxyLink;
        linkLabel.setHorizontalAlignment(10);
        this.$$$loadLabelText$$$((JLabel)linkLabel, ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("navigate.to.idea.proxy.settings"));
        jPanel8.add((Component)linkLabel, "East");
        jBLabel3.setAnchor((JComponent)jBLabel4);
        jBLabel5.setAnchor((JComponent)jBLabel4);
        jBLabel6.setAnchor((JComponent)jBLabel4);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

