/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.branchConfig;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.branchConfig.InfoReliability;
import org.jetbrains.idea.svn.branchConfig.InfoStorage;
import org.jetbrains.idea.svn.branchConfig.NewRootBunch;
import org.jetbrains.idea.svn.branchConfig.SvnBranchItem;
import org.jetbrains.idea.svn.browse.BrowseClient;
import org.jetbrains.idea.svn.browse.DirectoryEntryConsumer;

public class BranchesLoader
implements Runnable {
    @NotNull
    private final Project myProject;
    @NotNull
    private final NewRootBunch myBunch;
    @NotNull
    private final VirtualFile myRoot;
    @NotNull
    private final String myUrl;
    @NotNull
    private final InfoReliability myInfoReliability;
    private final boolean myPassive;

    public BranchesLoader(@NotNull Project project, @NotNull NewRootBunch bunch, @NotNull String url, @NotNull InfoReliability infoReliability, @NotNull VirtualFile root, boolean passive) {
        if (project == null) {
            BranchesLoader.$$$reportNull$$$0(0);
        }
        if (bunch == null) {
            BranchesLoader.$$$reportNull$$$0(1);
        }
        if (url == null) {
            BranchesLoader.$$$reportNull$$$0(2);
        }
        if (infoReliability == null) {
            BranchesLoader.$$$reportNull$$$0(3);
        }
        if (root == null) {
            BranchesLoader.$$$reportNull$$$0(4);
        }
        this.myProject = project;
        this.myBunch = bunch;
        this.myUrl = url;
        this.myInfoReliability = infoReliability;
        this.myRoot = root;
        this.myPassive = passive;
    }

    @Override
    public void run() {
        try {
            List<SvnBranchItem> branches = this.loadBranches();
            this.myBunch.updateBranches(this.myRoot, this.myUrl, new InfoStorage<List<SvnBranchItem>>(branches, this.myInfoReliability));
        }
        catch (VcsException e) {
            this.showError((Exception)((Object)e));
        }
    }

    @NotNull
    public List<SvnBranchItem> loadBranches() throws VcsException {
        SvnVcs vcs = SvnVcs.getInstance(this.myProject);
        Url branchesUrl = SvnUtil.createUrl(this.myUrl);
        LinkedList<SvnBranchItem> result = new LinkedList<SvnBranchItem>();
        Target target = Target.on(branchesUrl);
        DirectoryEntryConsumer handler = BranchesLoader.createConsumer(result);
        vcs.getFactory(target).create(BrowseClient.class, !this.myPassive).list(target, Revision.HEAD, Depth.IMMEDIATES, handler);
        Collections.sort(result);
        LinkedList<SvnBranchItem> linkedList = result;
        if (linkedList == null) {
            BranchesLoader.$$$reportNull$$$0(5);
        }
        return linkedList;
    }

    private void showError(Exception e) {
        if (InfoReliability.setByUser.equals((Object)this.myInfoReliability)) {
            VcsBalloonProblemNotifier.showOverChangesView((Project)this.myProject, (String)("Branches load error: " + e.getMessage()), (MessageType)MessageType.ERROR, (NamedRunnable[])new NamedRunnable[0]);
        }
    }

    @NotNull
    private static DirectoryEntryConsumer createConsumer(@NotNull List<SvnBranchItem> result) {
        if (result == null) {
            BranchesLoader.$$$reportNull$$$0(6);
        }
        DirectoryEntryConsumer directoryEntryConsumer = entry -> {
            if (result == null) {
                BranchesLoader.$$$reportNull$$$0(8);
            }
            if (entry.getDate() != null) {
                result.add(new SvnBranchItem(entry.getUrl().toDecodedString(), entry.getDate(), entry.getRevision()));
            }
        };
        if (directoryEntryConsumer == null) {
            BranchesLoader.$$$reportNull$$$0(7);
        }
        return directoryEntryConsumer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bunch";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infoReliability";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/branchConfig/BranchesLoader";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/branchConfig/BranchesLoader";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "loadBranches";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createConsumer";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createConsumer$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

