/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.branchConfig;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.ProgressManagerQueue;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.branchConfig.BranchesLoader;
import org.jetbrains.idea.svn.branchConfig.DefaultBranchConfigInitializer;
import org.jetbrains.idea.svn.branchConfig.InfoReliability;
import org.jetbrains.idea.svn.branchConfig.InfoStorage;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationNew;
import org.jetbrains.idea.svn.branchConfig.SvnBranchItem;
import org.jetbrains.idea.svn.commandLine.SvnBindException;

public class NewRootBunch {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.svn.branchConfig.NewRootBunch");
    private final Object myLock = new Object();
    private final Project myProject;
    private final ProgressManagerQueue myBranchesLoader;
    private final Map<VirtualFile, InfoStorage<SvnBranchConfigurationNew>> myMap;

    public NewRootBunch(Project project, ProgressManagerQueue branchesLoader) {
        this.myProject = project;
        this.myBranchesLoader = branchesLoader;
        this.myMap = new HashMap<VirtualFile, InfoStorage<SvnBranchConfigurationNew>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateForRoot(@NotNull VirtualFile root, @NotNull InfoStorage<SvnBranchConfigurationNew> config, boolean reload) {
        if (root == null) {
            NewRootBunch.$$$reportNull$$$0(0);
        }
        if (config == null) {
            NewRootBunch.$$$reportNull$$$0(1);
        }
        Object object = this.myLock;
        synchronized (object) {
            boolean override;
            SvnBranchConfigurationNew previous;
            InfoStorage<SvnBranchConfigurationNew> existing = this.myMap.get(root);
            if (existing == null) {
                previous = null;
                override = true;
                this.myMap.put(root, config);
            } else {
                previous = existing.getValue();
                override = existing.accept(config);
            }
            if (reload && override) {
                this.myBranchesLoader.run(() -> {
                    if (root == null) {
                        NewRootBunch.$$$reportNull$$$0(20);
                    }
                    if (config == null) {
                        NewRootBunch.$$$reportNull$$$0(21);
                    }
                    this.reloadBranches(root, previous, (SvnBranchConfigurationNew)config.getValue());
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBranches(@NotNull VirtualFile root, @NotNull String branchesParent, @NotNull InfoStorage<List<SvnBranchItem>> items) {
        if (root == null) {
            NewRootBunch.$$$reportNull$$$0(2);
        }
        if (branchesParent == null) {
            NewRootBunch.$$$reportNull$$$0(3);
        }
        if (items == null) {
            NewRootBunch.$$$reportNull$$$0(4);
        }
        Object object = this.myLock;
        synchronized (object) {
            InfoStorage<SvnBranchConfigurationNew> existing = this.myMap.get(root);
            if (existing == null) {
                LOG.info("cannot update branches, branches parent not found: " + branchesParent);
            } else {
                existing.getValue().updateBranch(branchesParent, items);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public SvnBranchConfigurationNew getConfig(@NotNull VirtualFile root) {
        SvnBranchConfigurationNew result;
        if (root == null) {
            NewRootBunch.$$$reportNull$$$0(5);
        }
        Object object = this.myLock;
        // MONITORENTER : object
        InfoStorage<SvnBranchConfigurationNew> value = this.myMap.get(root);
        if (value == null) {
            result = new SvnBranchConfigurationNew();
            this.myMap.put(root, new InfoStorage<SvnBranchConfigurationNew>(result, InfoReliability.empty));
            this.myBranchesLoader.run((Runnable)new DefaultBranchConfigInitializer(this.myProject, this, root));
        } else {
            result = value.getValue();
        }
        SvnBranchConfigurationNew svnBranchConfigurationNew = result;
        // MONITOREXIT : object
        if (svnBranchConfigurationNew != null) return svnBranchConfigurationNew;
        NewRootBunch.$$$reportNull$$$0(6);
        return svnBranchConfigurationNew;
    }

    public void reloadBranchesAsync(@NotNull VirtualFile root, @NotNull String branchLocation, @NotNull InfoReliability reliability) {
        if (root == null) {
            NewRootBunch.$$$reportNull$$$0(7);
        }
        if (branchLocation == null) {
            NewRootBunch.$$$reportNull$$$0(8);
        }
        if (reliability == null) {
            NewRootBunch.$$$reportNull$$$0(9);
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (root == null) {
                NewRootBunch.$$$reportNull$$$0(17);
            }
            if (branchLocation == null) {
                NewRootBunch.$$$reportNull$$$0(18);
            }
            if (reliability == null) {
                NewRootBunch.$$$reportNull$$$0(19);
            }
            this.reloadBranches(root, branchLocation, reliability, true);
        });
    }

    public void reloadBranches(@NotNull VirtualFile root, @Nullable SvnBranchConfigurationNew prev, @NotNull SvnBranchConfigurationNew next) {
        if (root == null) {
            NewRootBunch.$$$reportNull$$$0(10);
        }
        if (next == null) {
            NewRootBunch.$$$reportNull$$$0(11);
        }
        HashSet<String> oldUrls = prev == null ? Collections.emptySet() : new HashSet<String>(prev.getBranchUrls());
        SvnVcs vcs = SvnVcs.getInstance(this.myProject);
        if (!vcs.isVcsBackgroundOperationsAllowed(root)) {
            return;
        }
        for (String newBranchUrl : next.getBranchUrls()) {
            if (!vcs.isVcsBackgroundOperationsAllowed(root)) {
                return;
            }
            if (oldUrls.contains(newBranchUrl)) continue;
            this.reloadBranches(root, newBranchUrl, InfoReliability.defaultValues, true);
        }
    }

    public void reloadBranches(@NotNull VirtualFile root, @NotNull String branchLocation, @NotNull InfoReliability reliability, boolean passive) {
        if (root == null) {
            NewRootBunch.$$$reportNull$$$0(12);
        }
        if (branchLocation == null) {
            NewRootBunch.$$$reportNull$$$0(13);
        }
        if (reliability == null) {
            NewRootBunch.$$$reportNull$$$0(14);
        }
        new BranchesLoader(this.myProject, this, branchLocation, reliability, root, passive).run();
    }

    @Nullable
    public Url getWorkingBranch(@NotNull Url svnurl, @NotNull VirtualFile root) {
        Url result;
        if (svnurl == null) {
            NewRootBunch.$$$reportNull$$$0(15);
        }
        if (root == null) {
            NewRootBunch.$$$reportNull$$$0(16);
        }
        try {
            result = this.myMap.get(root).getValue().getWorkingBranch(svnurl);
        }
        catch (SvnBindException e) {
            result = null;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<VirtualFile, SvnBranchConfigurationNew> getMapCopy() {
        Object object = this.myLock;
        synchronized (object) {
            HashMap<VirtualFile, SvnBranchConfigurationNew> result = new HashMap<VirtualFile, SvnBranchConfigurationNew>();
            for (VirtualFile vf : this.myMap.keySet()) {
                result.put(vf, this.myMap.get(vf).getValue());
            }
            return result;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchesParent";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/branchConfig/NewRootBunch";
                break;
            }
            case 8: 
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchLocation";
                break;
            }
            case 9: 
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reliability";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "next";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "svnurl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/branchConfig/NewRootBunch";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfig";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updateForRoot";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateBranches";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getConfig";
                break;
            }
            case 6: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "reloadBranchesAsync";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "reloadBranches";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getWorkingBranch";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "lambda$reloadBranchesAsync$1";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "lambda$updateForRoot$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

