/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.changes.committed.RepositoryLocationGroup;
import com.intellij.openapi.vcs.changes.committed.VcsCommittedListsZipper;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.history.SvnChangeList;
import org.jetbrains.idea.svn.history.SvnRepositoryLocation;
import org.jetbrains.idea.svn.history.SvnRepositoryLocationGroup;

public class SvnCommittedListsZipper
implements VcsCommittedListsZipper {
    private static final Logger LOG = Logger.getInstance(SvnCommittedListsZipper.class);
    @NotNull
    private final SvnVcs myVcs;

    public SvnCommittedListsZipper(@NotNull SvnVcs vcs) {
        if (vcs == null) {
            SvnCommittedListsZipper.$$$reportNull$$$0(0);
        }
        this.myVcs = vcs;
    }

    public Pair<List<RepositoryLocationGroup>, List<RepositoryLocation>> groupLocations(List<RepositoryLocation> in) {
        ArrayList<SvnRepositoryLocationGroup> groups = new ArrayList<SvnRepositoryLocationGroup>();
        ArrayList<Object> singles = new ArrayList<Object>();
        MultiMap map = new MultiMap();
        for (RepositoryLocation location : in) {
            SvnRepositoryLocation svnLocation = (SvnRepositoryLocation)location;
            String url = svnLocation.getURL();
            Url root = SvnUtil.getRepositoryRoot(this.myVcs, url);
            if (root == null) {
                LOG.info("repository root not found for location:" + location.toPresentableString());
                singles.add(location);
                continue;
            }
            map.putValue((Object)root, (Object)svnLocation);
        }
        Set keys = map.keySet();
        for (Url key : keys) {
            Collection repositoryLocations = map.get((Object)key);
            if (repositoryLocations.size() == 1) {
                singles.add(repositoryLocations.iterator().next());
                continue;
            }
            SvnRepositoryLocationGroup group = new SvnRepositoryLocationGroup(key, repositoryLocations);
            groups.add(group);
        }
        return Pair.create(groups, singles);
    }

    public CommittedChangeList zip(RepositoryLocationGroup group, List<CommittedChangeList> lists) {
        return new SvnChangeList(lists, new SvnRepositoryLocation(group.toPresentableString()));
    }

    public long getNumber(CommittedChangeList list) {
        return list.getNumber();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/history/SvnCommittedListsZipper", "<init>"));
    }
}

