/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.treeConflict;

import com.intellij.openapi.CompositeDisposable;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.BackgroundTaskQueue;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.history.FileHistoryPanelImpl;
import com.intellij.openapi.vcs.history.FileHistoryRefresherI;
import com.intellij.openapi.vcs.history.VcsAbstractHistorySession;
import com.intellij.openapi.vcs.history.VcsAppendableHistoryPartnerAdapter;
import com.intellij.openapi.vcs.history.VcsAppendableHistorySessionPartner;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsHistorySession;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.util.BeforeAfter;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.VcsBackgroundTask;
import com.intellij.vcsUtil.VcsUtil;
import gnu.trove.TLongArrayList;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.ConflictedSvnChange;
import org.jetbrains.idea.svn.SvnRevisionNumber;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.conflict.ConflictAction;
import org.jetbrains.idea.svn.conflict.ConflictReason;
import org.jetbrains.idea.svn.conflict.ConflictVersion;
import org.jetbrains.idea.svn.conflict.TreeConflictDescription;
import org.jetbrains.idea.svn.history.SvnHistoryProvider;
import org.jetbrains.idea.svn.history.SvnHistorySession;
import org.jetbrains.idea.svn.treeConflict.MergeFromTheirsResolver;
import org.jetbrains.idea.svn.treeConflict.SvnTreeConflictResolver;

public class TreeConflictRefreshablePanel
implements Disposable {
    public static final String TITLE = "Resolve tree conflict";
    private final ConflictedSvnChange myChange;
    private final SvnVcs myVcs;
    private SvnRevisionNumber myCommittedRevision;
    private FilePath myPath;
    private final CompositeDisposable myChildDisposables;
    private final TLongArrayList myRightRevisionsList;
    @NotNull
    private final String myLoadingTitle;
    @NotNull
    private final JBLoadingPanel myDetailsPanel;
    @NotNull
    private final BackgroundTaskQueue myQueue;
    private volatile ProgressIndicator myIndicator;

    public TreeConflictRefreshablePanel(@NotNull Project project, @NotNull String loadingTitle, @NotNull BackgroundTaskQueue queue, Change change) {
        if (project == null) {
            TreeConflictRefreshablePanel.$$$reportNull$$$0(0);
        }
        if (loadingTitle == null) {
            TreeConflictRefreshablePanel.$$$reportNull$$$0(1);
        }
        if (queue == null) {
            TreeConflictRefreshablePanel.$$$reportNull$$$0(2);
        }
        this.myChildDisposables = new CompositeDisposable();
        this.myIndicator = new EmptyProgressIndicator();
        this.myVcs = SvnVcs.getInstance(project);
        assert (change instanceof ConflictedSvnChange);
        this.myChange = (ConflictedSvnChange)change;
        this.myPath = ChangesUtil.getFilePath((Change)this.myChange);
        this.myRightRevisionsList = new TLongArrayList();
        this.myLoadingTitle = loadingTitle;
        this.myQueue = queue;
        this.myDetailsPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)this);
    }

    public static boolean descriptionsEqual(TreeConflictDescription d1, TreeConflictDescription d2) {
        if (d1.isPropertyConflict() != d2.isPropertyConflict()) {
            return false;
        }
        if (d1.isTextConflict() != d2.isTextConflict()) {
            return false;
        }
        if (d1.isTreeConflict() != d2.isTreeConflict()) {
            return false;
        }
        if (!d1.getOperation().equals((Object)d2.getOperation())) {
            return false;
        }
        if (!d1.getConflictAction().equals((Object)d2.getConflictAction())) {
            return false;
        }
        if (!Comparing.equal((Object)((Object)d1.getConflictReason()), (Object)((Object)d2.getConflictReason()))) {
            return false;
        }
        if (!Comparing.equal((Object)d1.getPath(), (Object)d2.getPath())) {
            return false;
        }
        if (!Comparing.equal((Object)((Object)d1.getNodeKind()), (Object)((Object)d2.getNodeKind()))) {
            return false;
        }
        if (!TreeConflictRefreshablePanel.compareConflictVersion(d1.getSourceLeftVersion(), d2.getSourceLeftVersion())) {
            return false;
        }
        return TreeConflictRefreshablePanel.compareConflictVersion(d1.getSourceRightVersion(), d2.getSourceRightVersion());
    }

    private static boolean compareConflictVersion(ConflictVersion v1, ConflictVersion v2) {
        if (v1 == null && v2 == null) {
            return true;
        }
        if (v1 == null || v2 == null) {
            return false;
        }
        if (!v1.getKind().equals((Object)v2.getKind())) {
            return false;
        }
        if (!v1.getPath().equals(v2.getPath())) {
            return false;
        }
        if (v1.getPegRevision() != v2.getPegRevision()) {
            return false;
        }
        return Comparing.equal((Object)v1.getRepositoryRoot(), (Object)v2.getRepositoryRoot());
    }

    @NotNull
    public JPanel getPanel() {
        JBLoadingPanel jBLoadingPanel = this.myDetailsPanel;
        if (jBLoadingPanel == null) {
            TreeConflictRefreshablePanel.$$$reportNull$$$0(3);
        }
        return jBLoadingPanel;
    }

    private BeforeAfter<ConflictSidePresentation> processDescription(@NotNull ProgressIndicator indicator, TreeConflictDescription description) throws VcsException {
        ConflictSidePresentation rightSide;
        ConflictSidePresentation leftSide;
        if (indicator == null) {
            TreeConflictRefreshablePanel.$$$reportNull$$$0(4);
        }
        if (description == null) {
            return null;
        }
        if (this.myChange.getBeforeRevision() != null) {
            this.myCommittedRevision = (SvnRevisionNumber)SvnHistorySession.getCurrentCommittedRevision(this.myVcs, this.myChange.getBeforeRevision() != null ? this.myChange.getBeforeRevision().getFile().getIOFile() : this.myPath.getIOFile());
        }
        indicator.checkCanceled();
        if (TreeConflictRefreshablePanel.isDifferentURLs(description)) {
            leftSide = this.createSide(description.getSourceLeftVersion(), null, true);
            rightSide = this.createSide(description.getSourceRightVersion(), null, false);
        } else {
            leftSide = this.createSide(null, null, true);
            rightSide = this.createSide(description.getSourceRightVersion(), this.getPegRevisionFromLeftSide(description), false);
        }
        indicator.checkCanceled();
        leftSide.load();
        indicator.checkCanceled();
        rightSide.load();
        indicator.checkCanceled();
        return new BeforeAfter((Object)leftSide, (Object)rightSide);
    }

    @Nullable
    private Revision getPegRevisionFromLeftSide(@NotNull TreeConflictDescription description) {
        if (description == null) {
            TreeConflictRefreshablePanel.$$$reportNull$$$0(5);
        }
        Revision result = null;
        if (description.getSourceLeftVersion() != null) {
            long committed = description.getSourceLeftVersion().getPegRevision();
            if (this.myCommittedRevision != null && this.myCommittedRevision.getRevision().getNumber() < committed && this.myCommittedRevision.getRevision().isValid()) {
                committed = this.myCommittedRevision.getRevision().getNumber();
            }
            result = Revision.of(committed);
        }
        return result;
    }

    private static boolean isDifferentURLs(TreeConflictDescription description) {
        return description.getSourceLeftVersion() != null && description.getSourceRightVersion() != null && !Comparing.equal((String)description.getSourceLeftVersion().getPath(), (String)description.getSourceRightVersion().getPath());
    }

    @NotNull
    private ConflictSidePresentation createSide(@Nullable ConflictVersion version, @Nullable Revision untilThisOther, boolean isLeft) throws VcsException {
        ConflictSidePresentation result = EmptyConflictSide.getInstance();
        if (!(version == null || this.myChange.getBeforeRevision() != null && this.myCommittedRevision != null && isLeft && this.myCommittedRevision.getRevision().isValid() && this.myCommittedRevision.getRevision().getNumber() == version.getPegRevision())) {
            HistoryConflictSide side = new HistoryConflictSide(this.myVcs, version, untilThisOther);
            if (untilThisOther != null && !isLeft) {
                side.setListToReportLoaded(this.myRightRevisionsList);
            }
            result = side;
        }
        this.myChildDisposables.add((Disposable)result);
        EmptyConflictSide emptyConflictSide = result;
        if (emptyConflictSide == null) {
            TreeConflictRefreshablePanel.$$$reportNull$$$0(6);
        }
        return emptyConflictSide;
    }

    public void refresh() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myDetailsPanel.startLoading();
        Loader task = new Loader(this.myVcs.getProject(), this.myLoadingTitle);
        this.myIndicator = new BackgroundableProcessIndicator((Task.Backgroundable)task);
        this.myQueue.run((Task.Backgroundable)task, ModalityState.defaultModalityState(), this.myIndicator);
    }

    protected JPanel dataToPresentation(BeforeAfter<BeforeAfter<ConflictSidePresentation>> data) {
        JPanel wrapper = new JPanel(new BorderLayout());
        JPanel main = new JPanel(new GridBagLayout());
        GridBagConstraints gb = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.insets((int)1), 0, 0);
        String pathComment = this.myCommittedRevision == null ? "" : " (current: " + this.myChange.getBeforeRevision().getRevisionNumber().asString() + ", committed: " + this.myCommittedRevision.asString() + ")";
        JLabel name = new JLabel(this.myPath.getName() + pathComment);
        name.setFont(name.getFont().deriveFont(1));
        gb.insets.top = 5;
        main.add((Component)name, gb);
        ++gb.gridy;
        gb.insets.top = 10;
        this.appendDescription(this.myChange.getBeforeDescription(), main, gb, (BeforeAfter<ConflictSidePresentation>)((BeforeAfter)data.getBefore()), this.myPath.isDirectory());
        this.appendDescription(this.myChange.getAfterDescription(), main, gb, (BeforeAfter<ConflictSidePresentation>)((BeforeAfter)data.getAfter()), this.myPath.isDirectory());
        wrapper.add((Component)main, "North");
        return wrapper;
    }

    private void appendDescription(TreeConflictDescription description, JPanel main, GridBagConstraints gb, BeforeAfter<ConflictSidePresentation> ba, boolean directory) {
        if (description == null) {
            return;
        }
        JLabel descriptionLbl = new JLabel(description.toPresentableString());
        descriptionLbl.setForeground((Color)JBColor.RED);
        main.add((Component)descriptionLbl, gb);
        ++gb.gridy;
        gb.insets.top = 0;
        this.addResolveButtons(description, main, gb);
        this.addSide(main, gb, (ConflictSidePresentation)ba.getBefore(), description.getSourceLeftVersion(), "Left", directory);
        this.addSide(main, gb, (ConflictSidePresentation)ba.getAfter(), description.getSourceRightVersion(), "Right", directory);
    }

    private void addResolveButtons(TreeConflictDescription description, JPanel main, GridBagConstraints gb) {
        FlowLayout flowLayout = new FlowLayout(0, 5, 5);
        JPanel wrapper = new JPanel(flowLayout);
        JButton both = new JButton("Both");
        JButton merge = new JButton("Merge");
        JButton left = new JButton("Accept Yours");
        JButton right = new JButton("Accept Theirs");
        TreeConflictRefreshablePanel.enableAndSetListener(TreeConflictRefreshablePanel.createBoth(description), both);
        TreeConflictRefreshablePanel.enableAndSetListener(this.createMerge(description), merge);
        TreeConflictRefreshablePanel.enableAndSetListener(this.createLeft(description), left);
        TreeConflictRefreshablePanel.enableAndSetListener(this.createRight(description), right);
        if (merge.isEnabled()) {
            wrapper.add(merge);
        }
        wrapper.add(left);
        wrapper.add(right);
        gb.insets.left = -4;
        main.add((Component)wrapper, gb);
        gb.insets.left = 1;
        ++gb.gridy;
    }

    private ActionListener createRight(final TreeConflictDescription description) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int ok = Messages.showOkCancelDialog((Project)TreeConflictRefreshablePanel.this.myVcs.getProject(), (String)("Accept theirs for " + TreeConflictRefreshablePanel.filePath(TreeConflictRefreshablePanel.this.myPath) + "?"), (String)TreeConflictRefreshablePanel.TITLE, (Icon)Messages.getQuestionIcon());
                if (0 != ok) {
                    return;
                }
                FileDocumentManager.getInstance().saveAllDocuments();
                final Paths paths = TreeConflictRefreshablePanel.this.getPaths(description);
                ProgressManager.getInstance().run((Task)new VcsBackgroundTask<TreeConflictDescription>(TreeConflictRefreshablePanel.this.myVcs.getProject(), "Accepting theirs for: " + TreeConflictRefreshablePanel.filePath(paths.myMainPath), PerformInBackgroundOption.ALWAYS_BACKGROUND, Collections.singletonList(description), true){

                    protected void process(TreeConflictDescription d) throws VcsException {
                        new SvnTreeConflictResolver(TreeConflictRefreshablePanel.this.myVcs, paths.myMainPath, paths.myAdditionalPath).resolveSelectTheirsFull();
                    }

                    public void onSuccess() {
                        super.onSuccess();
                        if (this.executedOk()) {
                            VcsBalloonProblemNotifier.showOverChangesView((Project)this.myProject, (String)("Theirs accepted for " + TreeConflictRefreshablePanel.filePath(paths.myMainPath)), (MessageType)MessageType.INFO, (NamedRunnable[])new NamedRunnable[0]);
                        }
                    }
                });
            }
        };
    }

    private Paths getPaths(TreeConflictDescription description) {
        FilePath mainPath;
        FilePath additionalPath = null;
        if (this.myChange.isMoved() || this.myChange.isRenamed()) {
            if (ConflictAction.ADD.equals((Object)description.getConflictAction())) {
                mainPath = this.myChange.getAfterRevision().getFile();
                additionalPath = this.myChange.getBeforeRevision().getFile();
            } else {
                mainPath = this.myChange.getBeforeRevision().getFile();
                additionalPath = this.myChange.getAfterRevision().getFile();
            }
        } else {
            mainPath = this.myChange.getBeforeRevision() != null ? this.myChange.getBeforeRevision().getFile() : this.myChange.getAfterRevision().getFile();
        }
        return new Paths(mainPath, additionalPath);
    }

    private ActionListener createLeft(final TreeConflictDescription description) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int ok = Messages.showOkCancelDialog((Project)TreeConflictRefreshablePanel.this.myVcs.getProject(), (String)("Accept yours for " + TreeConflictRefreshablePanel.filePath(TreeConflictRefreshablePanel.this.myPath) + "?"), (String)TreeConflictRefreshablePanel.TITLE, (Icon)Messages.getQuestionIcon());
                if (0 != ok) {
                    return;
                }
                FileDocumentManager.getInstance().saveAllDocuments();
                final Paths paths = TreeConflictRefreshablePanel.this.getPaths(description);
                ProgressManager.getInstance().run((Task)new VcsBackgroundTask<TreeConflictDescription>(TreeConflictRefreshablePanel.this.myVcs.getProject(), "Accepting yours for: " + TreeConflictRefreshablePanel.filePath(paths.myMainPath), PerformInBackgroundOption.ALWAYS_BACKGROUND, Collections.singletonList(description), true){

                    protected void process(TreeConflictDescription d) throws VcsException {
                        new SvnTreeConflictResolver(TreeConflictRefreshablePanel.this.myVcs, paths.myMainPath, paths.myAdditionalPath).resolveSelectMineFull();
                    }

                    public void onSuccess() {
                        super.onSuccess();
                        if (this.executedOk()) {
                            VcsBalloonProblemNotifier.showOverChangesView((Project)this.myProject, (String)("Yours accepted for " + TreeConflictRefreshablePanel.filePath(paths.myMainPath)), (MessageType)MessageType.INFO, (NamedRunnable[])new NamedRunnable[0]);
                        }
                    }
                });
            }
        };
    }

    private ActionListener createMerge(TreeConflictDescription description) {
        if (TreeConflictRefreshablePanel.isDifferentURLs(description)) {
            return null;
        }
        if (ConflictAction.EDIT.equals((Object)description.getConflictAction()) && description.getSourceLeftVersion() != null && ConflictReason.DELETED.equals((Object)description.getConflictReason()) && (this.myChange.isMoved() || this.myChange.isRenamed()) && this.myCommittedRevision != null && this.myPath.isDirectory() == description.getSourceRightVersion().isDirectory()) {
            return this.createMergeTheirsForFile(description);
        }
        return null;
    }

    private ActionListener createMergeTheirsForFile(TreeConflictDescription description) {
        return e -> new MergeFromTheirsResolver(this.myVcs, description, this.myChange, this.myCommittedRevision).execute();
    }

    @NotNull
    public static String filePath(@NotNull FilePath newFilePath) {
        if (newFilePath == null) {
            TreeConflictRefreshablePanel.$$$reportNull$$$0(7);
        }
        String string = newFilePath.getName() + " (" + ((FilePath)ObjectUtils.notNull((Object)newFilePath.getParentPath())).getPath() + ")";
        if (string == null) {
            TreeConflictRefreshablePanel.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static ActionListener createBoth(TreeConflictDescription description) {
        return null;
    }

    private static void enableAndSetListener(ActionListener al, JButton b) {
        if (al == null) {
            b.setEnabled(false);
        } else {
            b.addActionListener(al);
        }
    }

    private void addSide(JPanel main, GridBagConstraints gb, ConflictSidePresentation before, ConflictVersion leftVersion, String name, boolean directory) {
        JPanel panel;
        String leftPresentation = leftVersion == null ? name + ": (" + (directory ? "directory" : "file") + (this.myChange.getBeforeRevision() == null ? ") added" : ") unversioned") : name + ": " + FileUtil.toSystemIndependentName((String)ConflictVersion.toPresentableString(leftVersion));
        gb.insets.top = 10;
        main.add((Component)new JLabel(leftPresentation), gb);
        ++gb.gridy;
        gb.insets.top = 0;
        if (before != null && (panel = before.createPanel()) != null) {
            main.add((Component)panel, gb);
            ++gb.gridy;
        }
    }

    public void dispose() {
        this.myIndicator.cancel();
        Disposer.dispose((Disposable)this.myChildDisposables);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loadingTitle";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queue";
                break;
            }
            case 3: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/treeConflict/TreeConflictRefreshablePanel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFilePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/treeConflict/TreeConflictRefreshablePanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPanel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createSide";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "filePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 6: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processDescription";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPegRevisionFromLeftSide";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "filePath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class Loader
    extends Task.Backgroundable {
        private BeforeAfter<BeforeAfter<ConflictSidePresentation>> myData;
        private VcsException myException;

        private Loader(@NotNull Project project, String title) {
            if (title == null) {
                Loader.$$$reportNull$$$0(0);
            }
            super(project, title, false);
        }

        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                Loader.$$$reportNull$$$0(1);
            }
            try {
                this.myData = new BeforeAfter((Object)TreeConflictRefreshablePanel.this.processDescription(indicator, TreeConflictRefreshablePanel.this.myChange.getBeforeDescription()), (Object)TreeConflictRefreshablePanel.this.processDescription(indicator, TreeConflictRefreshablePanel.this.myChange.getAfterDescription()));
            }
            catch (VcsException e) {
                this.myException = e;
            }
        }

        public void onSuccess() {
            if (this.myException != null) {
                VcsBalloonProblemNotifier.showOverChangesView((Project)this.myProject, (String)this.myException.getMessage(), (MessageType)MessageType.ERROR, (NamedRunnable[])new NamedRunnable[0]);
            } else {
                TreeConflictRefreshablePanel.this.myDetailsPanel.add((Component)TreeConflictRefreshablePanel.this.dataToPresentation(this.myData));
                TreeConflictRefreshablePanel.this.myDetailsPanel.stopLoading();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/idea/svn/treeConflict/TreeConflictRefreshablePanel$Loader";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "run";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class HistoryConflictSide
    extends AbstractConflictSide<VcsFileRevision> {
        public static final int LIMIT = 10;
        private final VcsAppendableHistoryPartnerAdapter mySessionAdapter;
        private final SvnHistoryProvider myProvider;
        private final FilePath myPath;
        private final SvnVcs myVcs;
        private final Revision myPeg;
        private FileHistoryPanelImpl myFileHistoryPanel;
        private TLongArrayList myListToReportLoaded;

        private HistoryConflictSide(SvnVcs vcs, ConflictVersion version, Revision peg) throws VcsException {
            super(vcs.getProject(), version);
            this.myVcs = vcs;
            this.myPeg = peg;
            this.myPath = VcsUtil.getFilePathOnNonLocal((String)SvnUtil.append(version.getRepositoryRoot(), FileUtil.toSystemIndependentName((String)version.getPath()), true).toString(), (boolean)version.isDirectory());
            this.mySessionAdapter = new VcsAppendableHistoryPartnerAdapter();
            this.myProvider = (SvnHistoryProvider)this.myVcs.getVcsHistoryProvider();
        }

        public void setListToReportLoaded(TLongArrayList listToReportLoaded) {
            this.myListToReportLoaded = listToReportLoaded;
        }

        public VcsRevisionNumber convert(VcsFileRevision o) {
            return o.getRevisionNumber();
        }

        @Override
        public void load() throws VcsException {
            Revision from = Revision.of(this.myVersion.getPegRevision());
            this.myProvider.reportAppendableHistory(this.myPath, (VcsAppendableHistorySessionPartner)this.mySessionAdapter, from, this.myPeg, this.myPeg == null ? 10 : 0, this.myPeg, true);
            VcsAbstractHistorySession session = this.mySessionAdapter.getSession();
            if (this.myListToReportLoaded != null && session != null) {
                List list = session.getRevisionList();
                for (VcsFileRevision revision : list) {
                    this.myListToReportLoaded.add(((SvnRevisionNumber)revision.getRevisionNumber()).getRevision().getNumber());
                }
            }
        }

        public void dispose() {
            if (this.myFileHistoryPanel != null) {
                Disposer.dispose((Disposable)this.myFileHistoryPanel);
            }
        }

        @Override
        public JPanel createPanel() {
            VcsAbstractHistorySession session = this.mySessionAdapter.getSession();
            if (session == null) {
                return EmptyConflictSide.getInstance().createPanel();
            }
            List list = session.getRevisionList();
            if (list.isEmpty()) {
                return EmptyConflictSide.getInstance().createPanel();
            }
            VcsFileRevision last = null;
            if (!list.isEmpty() && this.myPeg == null && list.size() == 10 || this.myPeg != null && this.myPeg.getNumber() > 0L && this.myPeg.equals(((SvnRevisionNumber)((VcsFileRevision)list.get(list.size() - 1)).getRevisionNumber()).getRevision())) {
                last = (VcsFileRevision)list.remove(list.size() - 1);
            }
            this.myFileHistoryPanel = new FileHistoryPanelImpl((AbstractVcs)this.myVcs, this.myPath, (VcsHistorySession)session, (VcsHistoryProvider)this.myProvider, null, new FileHistoryRefresherI(){

                public void run(boolean isRefresh, boolean canUseCache) {
                }

                public boolean isFirstTime() {
                    return false;
                }
            }, true);
            this.myFileHistoryPanel.setBottomRevisionForShowDiff(last);
            this.myFileHistoryPanel.setBorder(BorderFactory.createLineBorder(UIUtil.getBorderColor()));
            return this.myFileHistoryPanel;
        }
    }

    private static abstract class AbstractConflictSide<T>
    implements ConflictSidePresentation,
    Convertor<T, VcsRevisionNumber> {
        protected final Project myProject;
        protected final ConflictVersion myVersion;

        private AbstractConflictSide(Project project, ConflictVersion version) {
            this.myProject = project;
            this.myVersion = version;
        }
    }

    private static class EmptyConflictSide
    implements ConflictSidePresentation {
        private static final EmptyConflictSide ourInstance = new EmptyConflictSide();

        private EmptyConflictSide() {
        }

        public static EmptyConflictSide getInstance() {
            return ourInstance;
        }

        @Override
        public JPanel createPanel() {
            return null;
        }

        public void dispose() {
        }

        @Override
        public void load() {
        }
    }

    private static interface ConflictSidePresentation
    extends Disposable {
        public JPanel createPanel();

        public void load() throws VcsException;
    }

    private static class Paths {
        public final FilePath myMainPath;
        public final FilePath myAdditionalPath;

        private Paths(FilePath mainPath, FilePath additionalPath) {
            this.myMainPath = mainPath;
            this.myAdditionalPath = additionalPath;
        }
    }
}

