/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.inspections;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.ws.rest.RSBundle;
import com.intellij.ws.rest.inspections.AbstractRestJavaInspection;
import com.intellij.ws.rest.inspections.fixes.ChangeMethodReturnTypeFix;
import org.jetbrains.annotations.NotNull;

public class VoidMethodMarkedWithGETInspection
extends AbstractRestJavaInspection {
    @Override
    protected void checkMethod(@NotNull PsiMethod method, @NotNull ProblemsHolder problemsHolder, @NotNull Module module) {
        if (method == null) {
            VoidMethodMarkedWithGETInspection.$$$reportNull$$$0(0);
        }
        if (problemsHolder == null) {
            VoidMethodMarkedWithGETInspection.$$$reportNull$$$0(1);
        }
        if (module == null) {
            VoidMethodMarkedWithGETInspection.$$$reportNull$$$0(2);
        }
        PsiType type = method.getReturnType();
        PsiTypeElement typeElement = method.getReturnTypeElement();
        if (PsiType.VOID.equals((Object)type) && AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)"javax.ws.rs.GET", (int)1) && typeElement != null && !VoidMethodMarkedWithGETInspection.isSuspendedMethod(method)) {
            problemsHolder.registerProblem((PsiElement)typeElement, RSBundle.message("webservices.inspections.rest.void.method.annotated.as.get.problem", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new ChangeMethodReturnTypeFix((PsiType)PsiType.getJavaLangString((PsiManager)method.getManager(), (GlobalSearchScope)GlobalSearchScope.projectScope((Project)method.getProject())), RSBundle.message("webservices.inspections.rest.void.method.annotated.as.get.fix.name", new Object[0]))});
        }
    }

    private static boolean isSuspendedMethod(@NotNull PsiMethod method) {
        PsiParameter[] parameters;
        if (method == null) {
            VoidMethodMarkedWithGETInspection.$$$reportNull$$$0(3);
        }
        for (PsiParameter parameter : parameters = method.getParameterList().getParameters()) {
            PsiType type;
            if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)parameter, (String)"javax.ws.rs.container.Suspended", (int)1) || !((type = parameter.getType()) instanceof PsiClassType) || !InheritanceUtil.isInheritor((PsiClass)((PsiClassType)type).resolve(), (String)"javax.ws.rs.container.AsyncResponse")) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public String getDisplayName() {
        String string = RSBundle.message("webservices.inspections.rest.void.method.annotated.as.get.display.name", new Object[0]);
        if (string == null) {
            VoidMethodMarkedWithGETInspection.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        String string = RSBundle.message("webservices.inspections.rest.void.method.annotated.as.get.short.name", new Object[0]);
        if (string == null) {
            VoidMethodMarkedWithGETInspection.$$$reportNull$$$0(5);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemsHolder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/rest/inspections/VoidMethodMarkedWithGETInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/rest/inspections/VoidMethodMarkedWithGETInspection";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkMethod";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isSuspendedMethod";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

