/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.run.localRun;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class ScriptUtil {
    private ScriptUtil() {
    }

    public static void appendEnvVariableDeclaration(@NotNull String name, @NotNull String value, @NotNull StringBuilder buffer) {
        if (name == null) {
            ScriptUtil.$$$reportNull$$$0(0);
        }
        if (value == null) {
            ScriptUtil.$$$reportNull$$$0(1);
        }
        if (buffer == null) {
            ScriptUtil.$$$reportNull$$$0(2);
        }
        if (SystemInfo.isWindows) {
            buffer.append("SET ");
        }
        buffer.append(name);
        buffer.append("=");
        buffer.append(value);
        buffer.append("\n");
        if (SystemInfo.isUnix) {
            buffer.append("export ");
            buffer.append(name);
            buffer.append("\n");
        }
    }

    public static void appendEnvVariableReference(@NotNull String name, @NotNull StringBuilder buffer) {
        if (name == null) {
            ScriptUtil.$$$reportNull$$$0(3);
        }
        if (buffer == null) {
            ScriptUtil.$$$reportNull$$$0(4);
        }
        if (SystemInfo.isWindows) {
            buffer.append("%").append(name).append("%");
        } else {
            buffer.append("${").append(name).append("}");
        }
    }

    public static File createScriptFile(File directory, String fileName) throws IOException {
        File result = new File(directory, fileName + ScriptUtil.getScriptExtension());
        FileUtil.createIfDoesntExist((File)result);
        ScriptUtil.makeExecutable(result);
        return result;
    }

    public static void makeExecutable(File result) throws IOException {
        if (SystemInfo.isUnix) {
            result.setExecutable(true);
        }
    }

    public static String getScriptExtension() {
        return SystemInfo.isWindows ? "cmd" : "sh";
    }

    public static GeneralCommandLine createCommandLine(String ... parameters) {
        if (parameters == null) {
            ScriptUtil.$$$reportNull$$$0(5);
        }
        return new GeneralCommandLine(parameters);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javaee/run/localRun/ScriptUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "appendEnvVariableDeclaration";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "appendEnvVariableReference";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createCommandLine";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

