/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.debugger.jdi;

import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.tree.render.ClassRenderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.ThreeState;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.jetbrains.debugger.jdi.JdiObject;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StringReference;
import com.sun.jdi.Type;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.BasicDebuggerViewSupport;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.VariableContext;
import org.jetbrains.debugger.values.ObjectValue;
import org.jetbrains.debugger.values.Value;

public class JavaDebuggerViewSupport
extends BasicDebuggerViewSupport {
    public void computeObjectPresentation(@NotNull ObjectValue value, @NotNull Variable variable, @NotNull VariableContext context, @NotNull XValueNode node, @NotNull Icon icon) {
        if (value == null) {
            JavaDebuggerViewSupport.$$$reportNull$$$0(0);
        }
        if (variable == null) {
            JavaDebuggerViewSupport.$$$reportNull$$$0(1);
        }
        if (context == null) {
            JavaDebuggerViewSupport.$$$reportNull$$$0(2);
        }
        if (node == null) {
            JavaDebuggerViewSupport.$$$reportNull$$$0(3);
        }
        if (icon == null) {
            JavaDebuggerViewSupport.$$$reportNull$$$0(4);
        }
        node.setPresentation(icon, (XValuePresentation)new JavaObjectPresentation(((JdiObject)value).getReference()), value.hasProperties() != ThreeState.NO);
    }

    public void computeArrayPresentation(@NotNull Value value, @NotNull Variable variable, @NotNull VariableContext context, @NotNull XValueNode node, @NotNull Icon icon) {
        if (value == null) {
            JavaDebuggerViewSupport.$$$reportNull$$$0(5);
        }
        if (variable == null) {
            JavaDebuggerViewSupport.$$$reportNull$$$0(6);
        }
        if (context == null) {
            JavaDebuggerViewSupport.$$$reportNull$$$0(7);
        }
        if (node == null) {
            JavaDebuggerViewSupport.$$$reportNull$$$0(8);
        }
        if (icon == null) {
            JavaDebuggerViewSupport.$$$reportNull$$$0(9);
        }
        this.computeObjectPresentation((ObjectValue)value, variable, context, node, icon);
    }

    private static boolean isEnumConstant(ObjectReference objRef) {
        Type type = objRef.type();
        return type instanceof ClassType && ((ClassType)type).isEnum();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/debugger/jdi/JavaDebuggerViewSupport";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "computeObjectPresentation";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "computeArrayPresentation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class JavaObjectPresentation
    extends XValuePresentation {
        private final ObjectReference reference;

        private JavaObjectPresentation(@NotNull ObjectReference reference) {
            if (reference == null) {
                JavaObjectPresentation.$$$reportNull$$$0(0);
            }
            this.reference = reference;
        }

        public void renderValue(@NotNull XValuePresentation.XValueTextRenderer renderer) {
            if (renderer == null) {
                JavaObjectPresentation.$$$reportNull$$$0(1);
            }
            ClassRenderer classRenderer = NodeRendererSettings.getInstance().getClassRenderer();
            boolean showConcreteType = !classRenderer.SHOW_DECLARED_TYPE || !(this.reference instanceof StringReference) && !(this.reference instanceof ClassObjectReference) && !JavaDebuggerViewSupport.isEnumConstant(this.reference);
            boolean isArray = this.reference instanceof ArrayReference;
            if (showConcreteType) {
                String typeName = classRenderer.renderTypeName(this.reference.type().name());
                String postfix = "[]";
                if (isArray && typeName.endsWith(postfix)) {
                    typeName = typeName.substring(0, typeName.length() - postfix.length());
                }
                renderer.renderComment(typeName);
            }
            if (isArray) {
                renderer.renderComment("[");
                renderer.renderComment(Integer.toString(((ArrayReference)this.reference).length()));
                renderer.renderComment("]");
            }
            if (classRenderer.SHOW_OBJECT_ID) {
                renderer.renderComment("@");
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    renderer.renderComment("uniqueID");
                } else {
                    renderer.renderComment(String.valueOf(this.reference.uniqueID()));
                }
            }
            if (this.reference instanceof ClassObjectReference) {
                renderer.renderSpecialSymbol(" ");
                renderer.renderSpecialSymbol(((ClassObjectReference)this.reference).reflectedType().name());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reference";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "renderer";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/debugger/jdi/JavaDebuggerViewSupport$JavaObjectPresentation";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "renderValue";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

