/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.completion;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.cucumber.completion.CucumberPrefixMatcher;
import org.jetbrains.plugins.cucumber.psi.GherkinElementTypes;
import org.jetbrains.plugins.cucumber.psi.GherkinFeature;
import org.jetbrains.plugins.cucumber.psi.GherkinFile;
import org.jetbrains.plugins.cucumber.psi.GherkinKeywordTable;
import org.jetbrains.plugins.cucumber.psi.GherkinScenario;
import org.jetbrains.plugins.cucumber.psi.GherkinStep;
import org.jetbrains.plugins.cucumber.psi.GherkinTokenTypes;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinExamplesBlockImpl;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinScenarioOutlineImpl;
import org.jetbrains.plugins.cucumber.steps.AbstractStepDefinition;
import org.jetbrains.plugins.cucumber.steps.CucumberStepsIndex;

public class CucumberCompletionContributor
extends CompletionContributor {
    private static final Map<String, String> GROUP_TYPE_MAP = new HashMap<String, String>();
    private static final Map<String, String> INTERPOLATION_PARAMETERS_MAP = new HashMap<String, String>();
    private static final int SCENARIO_KEYWORD_PRIORITY = 70;
    private static final int SCENARIO_OUTLINE_KEYWORD_PRIORITY = 60;
    public static final Pattern POSSIBLE_GROUP_PATTERN;
    public static final Pattern QUESTION_MARK_PATTERN;
    public static final Pattern PARAMETERS_PATTERN;
    public static final String INTELLIJ_IDEA_RULEZZZ = "IntellijIdeaRulezzz";

    public CucumberCompletionContributor() {
        PsiElementPattern.Capture inScenario = (PsiElementPattern.Capture)PlatformPatterns.psiElement().inside((ElementPattern)PlatformPatterns.psiElement().withElementType(GherkinElementTypes.SCENARIOS));
        PsiElementPattern.Capture inStep = (PsiElementPattern.Capture)PlatformPatterns.psiElement().inside((ElementPattern)PlatformPatterns.psiElement().withElementType(GherkinElementTypes.STEP));
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().inFile((ElementPattern)PlatformPatterns.psiElement(GherkinFile.class)), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
                PsiFile psiFile;
                if (parameters == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (result == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((psiFile = parameters.getOriginalFile()) instanceof GherkinFile) {
                    PsiElement position = parameters.getPosition();
                    PsiElement coveringElement = PsiTreeUtil.getParentOfType((PsiElement)position, (Class[])new Class[]{GherkinStep.class, GherkinFeature.class, PsiFileSystemItem.class});
                    if (coveringElement instanceof PsiFileSystemItem) {
                        CucumberCompletionContributor.addFeatureKeywords(result, psiFile);
                    } else if (coveringElement instanceof GherkinFeature) {
                        CucumberCompletionContributor.addScenarioKeywords(result, psiFile, position);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/plugins/cucumber/completion/CucumberCompletionContributor$1";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.extend(CompletionType.BASIC, (ElementPattern)inScenario.andNot((ElementPattern)inStep), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
                if (parameters == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (result == null) {
                    2.$$$reportNull$$$0(1);
                }
                CucumberCompletionContributor.addStepKeywords(result, parameters.getOriginalFile());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/plugins/cucumber/completion/CucumberCompletionContributor$2";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.extend(CompletionType.BASIC, (ElementPattern)inStep, (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
                if (parameters == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (result == null) {
                    3.$$$reportNull$$$0(1);
                }
                CucumberCompletionContributor.addStepDefinitions(result, parameters.getOriginalFile());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/plugins/cucumber/completion/CucumberCompletionContributor$3";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static void addScenarioKeywords(CompletionResultSet result, PsiFile originalFile, PsiElement originalPosition) {
        PsiElement prevElement;
        Project project = originalFile.getProject();
        GherkinKeywordTable table = GherkinKeywordTable.getKeywordsTable(originalFile, project);
        ArrayList<String> keywords = new ArrayList<String>();
        if (!CucumberCompletionContributor.haveBackground(originalFile)) {
            keywords.addAll(table.getBackgroundKeywords());
        }
        if ((prevElement = CucumberCompletionContributor.getPreviousElement(originalPosition)) != null && prevElement.getNode().getElementType() == GherkinTokenTypes.SCENARIO_KEYWORD) {
            String scenarioKeyword = (String)table.getScenarioKeywords().toArray()[0];
            result = result.withPrefixMatcher(result.getPrefixMatcher().cloneWithPrefix(scenarioKeyword + " " + result.getPrefixMatcher().getPrefix()));
            boolean haveColon = false;
            String elementText = originalPosition.getText();
            int rulezzIndex = elementText.indexOf(INTELLIJ_IDEA_RULEZZZ);
            if (rulezzIndex >= 0) {
                haveColon = elementText.substring(rulezzIndex + INTELLIJ_IDEA_RULEZZZ.length()).trim().startsWith(":");
            }
            CucumberCompletionContributor.addKeywordsToResult(table.getScenarioOutlineKeywords(), result, !haveColon, 60, !haveColon);
        } else {
            CucumberCompletionContributor.addKeywordsToResult(table.getScenarioKeywords(), result, true, 70, true);
            CucumberCompletionContributor.addKeywordsToResult(table.getScenarioOutlineKeywords(), result, true, 60, true);
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)originalPosition, (Class[])new Class[]{GherkinScenarioOutlineImpl.class, GherkinExamplesBlockImpl.class}) != null) {
            keywords.addAll(table.getExampleSectionKeywords());
        }
        CucumberCompletionContributor.addKeywordsToResult(keywords, result, true);
    }

    private static PsiElement getPreviousElement(PsiElement element) {
        PsiElement prevElement = element.getPrevSibling();
        if (prevElement instanceof PsiWhiteSpace) {
            prevElement = prevElement.getPrevSibling();
        }
        return prevElement;
    }

    private static void addFeatureKeywords(CompletionResultSet result, PsiFile originalFile) {
        Project project = originalFile.getProject();
        GherkinKeywordTable table = GherkinKeywordTable.getKeywordsTable(originalFile, project);
        Collection<String> keywords = table.getFeaturesSectionKeywords();
        CucumberCompletionContributor.addKeywordsToResult(keywords, result, true);
    }

    private static void addKeywordsToResult(Collection<String> keywords, CompletionResultSet result, boolean withColonSuffix) {
        CucumberCompletionContributor.addKeywordsToResult(keywords, result, withColonSuffix, 0, true);
    }

    private static void addKeywordsToResult(Collection<String> keywords, CompletionResultSet result, boolean withColonSuffix, int priority, boolean withSpace) {
        for (String keyword : keywords) {
            LookupElement element = CucumberCompletionContributor.createKeywordLookupElement(withColonSuffix ? keyword + ":" : keyword, withSpace);
            result.addElement(PrioritizedLookupElement.withPriority((LookupElement)element, (double)priority));
        }
    }

    private static LookupElement createKeywordLookupElement(String keyword, boolean withSpace) {
        LookupElementBuilder result = LookupElementBuilder.create((String)keyword);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            result = result.withAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE);
        }
        if (withSpace) {
            result = TailTypeDecorator.withTail((LookupElement)result, (TailType)TailType.SPACE);
        }
        return result;
    }

    private static boolean haveBackground(PsiFile originalFile) {
        GherkinScenario[] scenarios;
        PsiElement scenarioParent = PsiTreeUtil.getChildOfType((PsiElement)originalFile, GherkinFeature.class);
        if (scenarioParent == null) {
            scenarioParent = originalFile;
        }
        if ((scenarios = (GherkinScenario[])PsiTreeUtil.getChildrenOfType((PsiElement)scenarioParent, GherkinScenario.class)) != null) {
            for (GherkinScenario scenario : scenarios) {
                if (!scenario.isBackground()) continue;
                return true;
            }
        }
        return false;
    }

    private static void addStepKeywords(CompletionResultSet result, PsiFile file) {
        if (!(file instanceof GherkinFile)) {
            return;
        }
        GherkinFile gherkinFile = (GherkinFile)file;
        CucumberCompletionContributor.addKeywordsToResult(gherkinFile.getStepKeywords(), result, false);
    }

    private static void addStepDefinitions(CompletionResultSet result, PsiFile file) {
        result = result.withPrefixMatcher((PrefixMatcher)new CucumberPrefixMatcher(result.getPrefixMatcher().getPrefix()));
        List<AbstractStepDefinition> definitions = CucumberStepsIndex.getInstance(file.getProject()).getAllStepDefinitions(file);
        for (AbstractStepDefinition definition : definitions) {
            String text = definition.getCucumberRegex();
            if (text == null) continue;
            text = StringUtil.trimStart((String)text, (String)"^");
            text = StringUtil.trimEnd((String)text, (String)"$");
            text = StringUtil.replace((String)text, (String)"\\\"", (String)"\"");
            for (Map.Entry<String, String> group : GROUP_TYPE_MAP.entrySet()) {
                text = StringUtil.replace((String)text, (String)group.getKey(), (String)group.getValue());
            }
            for (Map.Entry<String, String> group : INTERPOLATION_PARAMETERS_MAP.entrySet()) {
                text = text.replaceAll(group.getKey(), group.getValue());
            }
            ArrayList<TextRange> ranges = new ArrayList<TextRange>();
            Matcher m = QUESTION_MARK_PATTERN.matcher(text);
            if (m.find()) {
                text = m.replaceAll("$1");
            }
            m = POSSIBLE_GROUP_PATTERN.matcher(text);
            while (m.find()) {
                text = m.replaceAll("$1");
            }
            m = PARAMETERS_PATTERN.matcher(text);
            while (m.find()) {
                ranges.add(new TextRange(m.start(), m.end()));
            }
            PsiElement element = definition.getElement();
            LookupElementBuilder lookup = element != null ? LookupElementBuilder.create((Object)element, (String)text).bold() : LookupElementBuilder.create((String)text);
            result.addElement((LookupElement)lookup.withInsertHandler((InsertHandler)new StepInsertHandler(ranges)));
        }
    }

    static {
        GROUP_TYPE_MAP.put("(.*)", "<string>");
        GROUP_TYPE_MAP.put("(.+)", "<string>");
        GROUP_TYPE_MAP.put("([^\"]*)", "<string>");
        GROUP_TYPE_MAP.put("([^\"]+)", "<string>");
        GROUP_TYPE_MAP.put("(\\d*)", "<number>");
        GROUP_TYPE_MAP.put("(\\d)", "<number>");
        GROUP_TYPE_MAP.put("(\\d+)", "<number>");
        GROUP_TYPE_MAP.put("(\\.[\\d]+)", "<number>");
        INTERPOLATION_PARAMETERS_MAP.put("#\\{[^\\}]*\\}", "<param>");
        POSSIBLE_GROUP_PATTERN = Pattern.compile("\\(([^\\)]*)\\)");
        QUESTION_MARK_PATTERN = Pattern.compile("([^\\\\])\\?:?");
        PARAMETERS_PATTERN = Pattern.compile("<string>|<number>|<param>");
    }

    private static class StepInsertHandler
    implements InsertHandler<LookupElement> {
        private final List<TextRange> ranges;

        private StepInsertHandler(List<TextRange> ranges) {
            this.ranges = ranges;
        }

        public void handleInsert(InsertionContext context, LookupElement item) {
            PsiElement element;
            GherkinStep step;
            if (!this.ranges.isEmpty() && (step = (GherkinStep)PsiTreeUtil.getParentOfType((PsiElement)(element = context.getFile().findElementAt(context.getStartOffset())), GherkinStep.class)) != null) {
                TemplateBuilder builder = TemplateBuilderFactory.getInstance().createTemplateBuilder((PsiElement)step);
                int off = context.getStartOffset() - step.getTextRange().getStartOffset();
                String stepText = step.getText();
                for (TextRange groupRange : this.ranges) {
                    TextRange shiftedRange = groupRange.shiftRight(off);
                    String matchedText = shiftedRange.substring(stepText);
                    builder.replaceRange(shiftedRange, matchedText);
                }
                builder.run(context.getEditor(), false);
            }
        }
    }
}

