/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.steps;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.CucumberUtil;
import org.jetbrains.plugins.cucumber.psi.GherkinStep;

public abstract class AbstractStepDefinition {
    private static final Pattern ESCAPE_PATTERN = Pattern.compile("(\\$\\w+|#\\{.+?\\})");
    private static final String CUCUMBER_START_PREFIX = "\\A";
    private static final String CUCUMBER_END_SUFFIX = "\\z";
    private final SmartPsiElementPointer<PsiElement> myElementPointer;
    private volatile String myRegexText;
    private volatile Pattern myRegex;

    public AbstractStepDefinition(@NotNull PsiElement element) {
        if (element == null) {
            AbstractStepDefinition.$$$reportNull$$$0(0);
        }
        this.myElementPointer = SmartPointerManager.getInstance((Project)element.getProject()).createSmartPsiElementPointer(element);
    }

    public abstract List<String> getVariableNames();

    public boolean matches(@NotNull String stepName) {
        Pattern pattern;
        if (stepName == null) {
            AbstractStepDefinition.$$$reportNull$$$0(1);
        }
        return (pattern = this.getPattern()) != null && pattern.matcher(stepName).find();
    }

    @Nullable
    public PsiElement getElement() {
        return this.myElementPointer.getElement();
    }

    @Nullable
    public Pattern getPattern() {
        try {
            String cucumberRegex = this.getCucumberRegex();
            if (cucumberRegex == null) {
                return null;
            }
            if (this.myRegexText == null || !cucumberRegex.equals(this.myRegexText)) {
                StringBuilder patternText = new StringBuilder(ESCAPE_PATTERN.matcher(cucumberRegex).replaceAll("(.*)"));
                if (patternText.toString().startsWith(CUCUMBER_START_PREFIX)) {
                    patternText.replace(0, CUCUMBER_START_PREFIX.length(), "^");
                }
                if (patternText.toString().endsWith(CUCUMBER_END_SUFFIX)) {
                    patternText.replace(patternText.length() - CUCUMBER_END_SUFFIX.length(), patternText.length(), "$");
                }
                this.myRegex = Pattern.compile(patternText.toString(), 2);
                this.myRegexText = cucumberRegex;
            }
            return this.myRegex;
        }
        catch (PatternSyntaxException ignored) {
            return null;
        }
    }

    @Nullable
    public String getCucumberRegex() {
        return this.getCucumberRegexFromElement(this.getElement());
    }

    @Nullable
    protected abstract String getCucumberRegexFromElement(PsiElement var1);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractStepDefinition that = (AbstractStepDefinition)o;
        return this.myElementPointer.equals(that.myElementPointer);
    }

    public int hashCode() {
        return this.myElementPointer.hashCode();
    }

    public void setCucumberRegex(@NotNull String newValue) {
        if (newValue == null) {
            AbstractStepDefinition.$$$reportNull$$$0(2);
        }
    }

    public boolean supportsStep(@NotNull PsiElement step) {
        if (step == null) {
            AbstractStepDefinition.$$$reportNull$$$0(3);
        }
        return true;
    }

    public boolean supportsRename(@Nullable String newName) {
        return true;
    }

    @NotNull
    public Collection<GherkinStep> findSteps(@NotNull SearchScope searchScope) {
        if (searchScope == null) {
            AbstractStepDefinition.$$$reportNull$$$0(4);
        }
        String regex = this.getCucumberRegex();
        PsiElement element = this.getElement();
        if (regex == null || element == null) {
            List<GherkinStep> list = Collections.emptyList();
            if (list == null) {
                AbstractStepDefinition.$$$reportNull$$$0(5);
            }
            return list;
        }
        CommonProcessors.CollectProcessor consumer = new CommonProcessors.CollectProcessor();
        CucumberUtil.findGherkinReferencesToElement(element, regex, (Processor<PsiReference>)consumer, searchScope);
        HashSet<GherkinStep> results = new HashSet<GherkinStep>(consumer.getResults().size());
        for (PsiReference reference : consumer.getResults()) {
            PsiElement step = reference.getElement();
            if (!(step instanceof GherkinStep)) continue;
            results.add((GherkinStep)step);
        }
        HashSet<GherkinStep> hashSet = results;
        if (hashSet == null) {
            AbstractStepDefinition.$$$reportNull$$$0(6);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stepName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newValue";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "step";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/cucumber/steps/AbstractStepDefinition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/cucumber/steps/AbstractStepDefinition";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findSteps";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setCucumberRegex";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "supportsStep";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findSteps";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

