/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.debugger.wip;

import com.intellij.execution.configurations.RunProfile;
import com.intellij.ide.browsers.BrowserLauncher;
import com.intellij.ide.browsers.BrowserSpecificSettings;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.chrome.ChromeSettings;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import com.intellij.util.Url;
import com.intellij.util.io.NettyKt;
import com.intellij.util.net.NetUtils;
import com.jetbrains.debugger.wip.ChromeLocalConnectedTabsService;
import com.jetbrains.debugger.wip.ChromeLocalVmConnection;
import com.jetbrains.debugger.wip.ChromeLocalVmConnectionKt;
import com.jetbrains.debugger.wip.PageConnection;
import com.jetbrains.debugger.wip.WipLocalVmConnection;
import com.jetbrains.debugger.wip.WipVmBootstrap;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.File;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.debugger.MessagingLogger;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.connection.RemoteVmConnection;
import org.jetbrains.io.SimpleChannelInboundHandlerAdapter;
import org.jetbrains.wip.WipVm;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B+\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u001e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0014J\b\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u0010 \u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\"\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J6\u0010#\u001a\u00020\u00052\u0006\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0014R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006,"}, d2={"Lcom/jetbrains/debugger/wip/ChromeLocalVmConnection;", "Lcom/jetbrains/debugger/wip/WipLocalVmConnection;", "url", "Lcom/intellij/util/Url;", "reloadReusedPage", "", "browser", "Lcom/intellij/ide/browsers/WebBrowser;", "runProfile", "Lcom/intellij/execution/configurations/RunProfile;", "(Lcom/intellij/util/Url;ZLcom/intellij/ide/browsers/WebBrowser;Lcom/intellij/execution/configurations/RunProfile;)V", "getBrowser", "()Lcom/intellij/ide/browsers/WebBrowser;", "newPageRequested", "getReloadReusedPage", "()Z", "reusedExistingBrowserInstance", "getRunProfile", "()Lcom/intellij/execution/configurations/RunProfile;", "connect", "", "project", "Lcom/intellij/openapi/project/Project;", "createChannelHandler", "Lio/netty/channel/ChannelHandler;", "port", "", "vmResult", "Lorg/jetbrains/concurrency/AsyncPromise;", "Lorg/jetbrains/debugger/Vm;", "getUserDataPath", "", "launchBrowserAndOpen", "remoteDebuggingPort", "launchBrowserOnNewPortAndOpen", "processPageConnections", "context", "Lio/netty/channel/ChannelHandlerContext;", "debugMessageQueue", "Lorg/jetbrains/debugger/MessagingLogger;", "pageConnections", "", "Lcom/jetbrains/debugger/wip/PageConnection;", "result", "ChromeConnector"})
public class ChromeLocalVmConnection
extends WipLocalVmConnection {
    private boolean reusedExistingBrowserInstance;
    private boolean newPageRequested;
    private final boolean reloadReusedPage;
    @NotNull
    private final WebBrowser browser;
    @Nullable
    private final RunProfile runProfile;

    /*
     * WARNING - void declaration
     */
    public final void connect(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        int savedPort = PropertiesComponent.getInstance().getInt("js.chrome.debugger.port", -1);
        if (savedPort > 0) {
            void f;
            this.reusedExistingBrowserInstance = true;
            InetSocketAddress address = new InetSocketAddress(InetAddress.getLoopbackAddress(), savedPort);
            AsyncPromise result = new AsyncPromise();
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = null;
            result.done((Consumer)new Consumer<Vm>(this, (Ref.ObjectRef)f, address){
                final /* synthetic */ ChromeLocalVmConnection this$0;
                final /* synthetic */ Ref.ObjectRef $f;
                final /* synthetic */ InetSocketAddress $address;

                public final void consume(Vm it) {
                    ScheduledFuture scheduledFuture = (ScheduledFuture)this.$f.element;
                    if (scheduledFuture != null) {
                        scheduledFuture.cancel(true);
                    }
                    Vm vm = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)vm, (String)"it");
                    ChromeLocalVmConnection.access$connectionSucceeded(this.this$0, vm, this.$address);
                }
                {
                    this.this$0 = chromeLocalVmConnection;
                    this.$f = objectRef;
                    this.$address = inetSocketAddress;
                }
            });
            Channel channel = NettyKt.connectRetrying$default((Bootstrap)this.createBootstrap(address, (AsyncPromise<Vm>)result), (InetSocketAddress)address, (int)2, null, (int)4, null).getChannel();
            if (channel != null) {
                f.element = (ScheduledFuture)channel.eventLoop().schedule(new Runnable(this, channel, project){
                    final /* synthetic */ ChromeLocalVmConnection this$0;
                    final /* synthetic */ Channel $channel;
                    final /* synthetic */ Project $project;

                    public final void run() {
                        this.$channel.close();
                        ChromeLocalVmConnection.access$launchBrowserOnNewPortAndOpen(this.this$0, this.$project);
                    }
                    {
                        this.this$0 = chromeLocalVmConnection;
                        this.$channel = channel;
                        this.$project = project;
                    }
                }, 500L, TimeUnit.MILLISECONDS);
            } else {
                this.launchBrowserAndOpen(savedPort, project);
            }
            return;
        }
        this.launchBrowserOnNewPortAndOpen(project);
    }

    private final void launchBrowserOnNewPortAndOpen(Project project) {
        int port = NetUtils.findAvailableSocketPort();
        int oldPort = PropertiesComponent.getInstance().getInt("js.chrome.debugger.port", -1);
        if (oldPort > 0) {
            Logger logger = Logger.getInstance(ChromeLocalVmConnection.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
            logger.warn("Chrome debug port changed from " + oldPort + " to " + port + '.');
        }
        PropertiesComponent.getInstance().setValue("js.chrome.debugger.port", port, -1);
        this.launchBrowserAndOpen(port, project);
    }

    /*
     * WARNING - void declaration
     */
    private final void launchBrowserAndOpen(int remoteDebuggingPort, Project project) {
        void $receiver$iv;
        Object userDataPath;
        List additionalParameters = new ArrayList();
        additionalParameters.add("--remote-debugging-port=" + remoteDebuggingPort);
        BrowserSpecificSettings browserSpecificSettings = this.getBrowser().getSpecificSettings();
        if (!(browserSpecificSettings instanceof ChromeSettings)) {
            browserSpecificSettings = null;
        }
        ChromeSettings chromeSettings = (ChromeSettings)browserSpecificSettings;
        if (chromeSettings == null) {
            throw (Throwable)((Object)new AssertionError((Object)"Browser is not Chrome. Must be checked in Run configuration."));
        }
        ChromeSettings chromeSettings2 = chromeSettings;
        if (!chromeSettings2.isUseCustomProfile()) {
            userDataPath = this.getUserDataPath();
            additionalParameters.add("--user-data-dir=" + (String)userDataPath);
            additionalParameters.add("--no-first-run");
            additionalParameters.add("--disable-fre");
        }
        additionalParameters.add("--no-default-browser-check");
        additionalParameters.add(ChromeLocalVmConnectionKt.access$getEMPTY_PAGE_URL$p());
        userDataPath = additionalParameters;
        boolean bl = true;
        Project project2 = project;
        WebBrowser webBrowser = this.getBrowser();
        String string = null;
        String string2 = null;
        BrowserLauncher browserLauncher = BrowserLauncher.Companion.getInstance();
        void thisCollection$iv = $receiver$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] stringArray2 = stringArray;
        browserLauncher.browseUsingPath(string2, string, webBrowser, project2, bl, stringArray2);
        this.reusedExistingBrowserInstance = false;
        RemoteVmConnection.open$default((RemoteVmConnection)this, (InetSocketAddress)new InetSocketAddress(InetAddress.getLoopbackAddress(), remoteDebuggingPort), null, (int)2, null);
    }

    private final String getUserDataPath() {
        File userDataDir = new File(PathManager.getConfigPath(), "chrome-user-data-debug");
        if (!userDataDir.exists()) {
            userDataDir.mkdir();
        }
        String string = userDataDir.getAbsolutePath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"userDataDir.absolutePath");
        return string;
    }

    @Override
    @NotNull
    protected ChannelHandler createChannelHandler(int port, @NotNull AsyncPromise<Vm> vmResult) {
        Intrinsics.checkParameterIsNotNull(vmResult, (String)"vmResult");
        return (ChannelHandler)new SimpleChannelInboundHandlerAdapter<FullHttpResponse>(this, port, vmResult){
            private final long startTimeMillis;
            final /* synthetic */ ChromeLocalVmConnection this$0;
            final /* synthetic */ int $port;
            final /* synthetic */ AsyncPromise $vmResult;

            public void channelActive(@NotNull ChannelHandlerContext context) {
                Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                super.channelActive(context);
                this.sendGetJson(context);
            }

            private final void sendGetJson(ChannelHandlerContext context) {
                DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/json");
                request.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)("localhost:" + this.$port));
                request.headers().set((CharSequence)HttpHeaderNames.ACCEPT, (Object)"*/*");
                ChannelFuture $receiver$iv = context.channel().writeAndFlush((Object)request);
                $receiver$iv.addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(this){
                    final /* synthetic */ createChannelHandler.1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final void operationComplete(ChannelFuture it) {
                        ChannelFuture channelFuture = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)channelFuture, (String)"it");
                        ChannelFuture it2 = channelFuture;
                        if (!it2.isSuccess()) {
                            AsyncPromise asyncPromise = this.this$0.$vmResult;
                            Throwable throwable = it2.cause();
                            Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"it.cause()");
                            asyncPromise.setError(throwable);
                        }
                    }
                });
            }

            protected void messageReceived(@NotNull ChannelHandlerContext context, @NotNull FullHttpResponse message) {
                Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                try {
                    if (ChromeLocalVmConnection.access$getReusedExistingBrowserInstance$p(this.this$0) && this.this$0.connectToPage(context, message, (AsyncPromise<Vm>)this.$vmResult)) {
                        context.pipeline().remove((ChannelHandler)this);
                        if (this.this$0.getReloadReusedPage() && !ChromeLocalVmConnection.access$getNewPageRequested$p(this.this$0)) {
                            this.$vmResult.done((Consumer)new Consumer<Vm>(this){
                                final /* synthetic */ createChannelHandler.1 this$0;

                                public final void consume(Vm it) {
                                    Vm vm = it;
                                    if (vm == null) {
                                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.wip.WipVm");
                                    }
                                    WipVmBootstrap wipVmBootstrap = new WipVmBootstrap((WipVm)vm);
                                    Url url = this.this$0.this$0.getUrl();
                                    if (url == null) {
                                        Intrinsics.throwNpe();
                                    }
                                    wipVmBootstrap.navigate(url);
                                }
                                {
                                    this.this$0 = var1_1;
                                }
                            });
                        }
                        return;
                    }
                    if (!ChromeLocalVmConnection.access$getReusedExistingBrowserInstance$p(this.this$0)) {
                        ChromeLocalVmConnection.access$setNewPageRequested$p(this.this$0, true);
                    }
                    if (ChromeLocalVmConnection.access$getNewPageRequested$p(this.this$0)) {
                        if (!this.this$0.connectToPage(context, message, (AsyncPromise<Vm>)this.$vmResult) && System.currentTimeMillis() - this.startTimeMillis < (long)5000) {
                            context.executor().schedule(new Runnable(this, context){
                                final /* synthetic */ createChannelHandler.1 this$0;
                                final /* synthetic */ ChannelHandlerContext $context;

                                public final void run() {
                                    createChannelHandler.1.access$sendGetJson(this.this$0, this.$context);
                                }
                                {
                                    this.this$0 = var1_1;
                                    this.$context = channelHandlerContext;
                                }
                            }, 100L, TimeUnit.MILLISECONDS);
                        } else {
                            context.pipeline().remove((ChannelHandler)this);
                        }
                    } else {
                        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/json/new?" + ChromeLocalVmConnectionKt.access$getEMPTY_PAGE_URL$p());
                        request.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)("localhost:" + this.$port));
                        request.headers().set((CharSequence)HttpHeaderNames.ACCEPT, (Object)"*/*");
                        ChannelFuture $receiver$iv = context.channel().writeAndFlush((Object)request);
                        $receiver$iv.addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(this){
                            final /* synthetic */ createChannelHandler.1 this$0;
                            {
                                this.this$0 = var1_1;
                            }

                            public final void operationComplete(ChannelFuture it) {
                                ChannelFuture channelFuture = it;
                                Intrinsics.checkExpressionValueIsNotNull((Object)channelFuture, (String)"it");
                                ChannelFuture it2 = channelFuture;
                                if (!it2.isSuccess()) {
                                    AsyncPromise asyncPromise = this.this$0.$vmResult;
                                    Throwable throwable = it2.cause();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"it.cause()");
                                    asyncPromise.setError(throwable);
                                }
                            }
                        });
                        ChromeLocalVmConnection.access$setNewPageRequested$p(this.this$0, true);
                    }
                }
                catch (Throwable e) {
                    this.$vmResult.setError(e);
                }
            }

            public void exceptionCaught(@NotNull ChannelHandlerContext context, @NotNull Throwable cause) {
                Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                Intrinsics.checkParameterIsNotNull((Object)cause, (String)"cause");
                this.$vmResult.setError(cause);
                context.close();
            }
            {
                this.this$0 = $outer;
                this.$port = $captured_local_variable$1;
                this.$vmResult = $captured_local_variable$2;
                this.startTimeMillis = System.currentTimeMillis();
            }

            public static final /* synthetic */ void access$sendGetJson(createChannelHandler.1 $this, @NotNull ChannelHandlerContext context) {
                $this.sendGetJson(context);
            }
        };
    }

    @Override
    protected boolean processPageConnections(@NotNull ChannelHandlerContext context, @Nullable MessagingLogger debugMessageQueue, @NotNull List<PageConnection> pageConnections, @NotNull AsyncPromise<Vm> result) {
        block7: {
            block6: {
                Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                Intrinsics.checkParameterIsNotNull(pageConnections, (String)"pageConnections");
                Intrinsics.checkParameterIsNotNull(result, (String)"result");
                if (!this.newPageRequested) break block6;
                for (PageConnection p : CollectionsKt.reversed((Iterable)pageConnections)) {
                    if (!Intrinsics.areEqual((Object)p.getUrl(), (Object)ChromeLocalVmConnectionKt.access$getEMPTY_PAGE_URL$p())) continue;
                    if (p.getWebSocketDebuggerUrl() == null) {
                        String string = JSDebuggerBundle.message((String)"js.debug.another.debugger.attached", (Object[])new Object[0]);
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"JSDebuggerBundle.message\u2026other.debugger.attached\")");
                        result.setError(string);
                        return false;
                    }
                    if (this.runProfile != null) {
                        ((ChromeLocalConnectedTabsService)ServiceManager.getService(ChromeLocalConnectedTabsService.class)).addTabToReuse(this.runProfile, p.getId());
                    }
                    this.connectDebugger(p.getUrl(), p.getWebSocketDebuggerUrl(), context, result, debugMessageQueue, Intrinsics.areEqual((Object)p.getType(), (Object)"node"));
                    if (this.getUrl() != null) {
                        result.done((Consumer)new Consumer<Vm>(this){
                            final /* synthetic */ ChromeLocalVmConnection this$0;

                            public final void consume(Vm it) {
                                Vm vm = it;
                                if (vm == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.wip.WipVm");
                                }
                                new WipVmBootstrap((WipVm)vm).navigate(this.this$0.getUrl());
                            }
                            {
                                this.this$0 = chromeLocalVmConnection;
                            }
                        });
                    }
                    return false;
                }
                break block7;
            }
            if (this.runProfile == null) break block7;
            for (PageConnection p : pageConnections) {
                if (!Intrinsics.areEqual((Object)p.getId(), (Object)((ChromeLocalConnectedTabsService)ServiceManager.getService(ChromeLocalConnectedTabsService.class)).getTabToReuse(this.runProfile))) continue;
                if (p.getWebSocketDebuggerUrl() == null) {
                    String string = JSDebuggerBundle.message((String)"js.debug.another.debugger.attached", (Object[])new Object[0]);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"JSDebuggerBundle.message\u2026other.debugger.attached\")");
                    result.setError(string);
                    return false;
                }
                this.connectDebugger(p.getUrl(), p.getWebSocketDebuggerUrl(), context, result, debugMessageQueue, Intrinsics.areEqual((Object)p.getType(), (Object)"node"));
                return false;
            }
        }
        return true;
    }

    public final boolean getReloadReusedPage() {
        return this.reloadReusedPage;
    }

    @NotNull
    public WebBrowser getBrowser() {
        return this.browser;
    }

    @Nullable
    public final RunProfile getRunProfile() {
        return this.runProfile;
    }

    public ChromeLocalVmConnection(@Nullable Url url, boolean reloadReusedPage, @NotNull WebBrowser browser, @Nullable RunProfile runProfile) {
        Intrinsics.checkParameterIsNotNull((Object)browser, (String)"browser");
        super(url);
        this.reloadReusedPage = reloadReusedPage;
        this.browser = browser;
        this.runProfile = runProfile;
    }

    public /* synthetic */ ChromeLocalVmConnection(Url url, boolean bl, WebBrowser webBrowser, RunProfile runProfile, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        this(url, bl, webBrowser, runProfile);
    }

    public static final /* synthetic */ void access$connectionSucceeded(ChromeLocalVmConnection $this, @NotNull Vm it, @NotNull InetSocketAddress address) {
        $this.connectionSucceeded(it, address);
    }

    public static final /* synthetic */ void access$launchBrowserOnNewPortAndOpen(ChromeLocalVmConnection $this, @NotNull Project project) {
        $this.launchBrowserOnNewPortAndOpen(project);
    }

    public static final /* synthetic */ boolean access$getReusedExistingBrowserInstance$p(ChromeLocalVmConnection $this) {
        return $this.reusedExistingBrowserInstance;
    }

    public static final /* synthetic */ void access$setReusedExistingBrowserInstance$p(ChromeLocalVmConnection $this, boolean bl) {
        $this.reusedExistingBrowserInstance = bl;
    }

    public static final /* synthetic */ boolean access$getNewPageRequested$p(ChromeLocalVmConnection $this) {
        return $this.newPageRequested;
    }

    public static final /* synthetic */ void access$setNewPageRequested$p(ChromeLocalVmConnection $this, boolean bl) {
        $this.newPageRequested = bl;
    }
}

