/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.reactnative;

import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.configuration.EnvironmentVariablesTextFieldWithBrowseButton;
import com.intellij.ide.browsers.BrowserSelector;
import com.intellij.javascript.debugger.execution.JavaScriptDebugSettingsEditor;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageField;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunConfigurationEditor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.PortField;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.textCompletion.TextCompletionProvider;
import com.intellij.util.textCompletion.TextFieldWithCompletion;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.RadioButtonEnumModel;
import com.jetbrains.plugins.reactnative.DebuggerProcess;
import com.jetbrains.plugins.reactnative.PackagerRunner;
import com.jetbrains.plugins.reactnative.ReactNativeConfigurationEditorKt;
import com.jetbrains.plugins.reactnative.ReactNativePlatform;
import com.jetbrains.plugins.reactnative.ReactNativeRunConfiguration;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u0002H\u0014J\b\u0010-\u001a\u00020.H\u0014J4\u0010/\u001a\b\u0012\u0004\u0012\u0002H00\u0010\"\u000e\b\u0000\u00100*\b\u0012\u0004\u0012\u0002H0012\f\u00102\u001a\b\u0012\u0004\u0012\u0002H0032\u0006\u00104\u001a\u00020\u0013H\u0002J\u0010\u00105\u001a\u00020+2\u0006\u0010,\u001a\u00020\u0002H\u0014J\b\u00106\u001a\u00020+H\u0002J\b\u00107\u001a\u00020+H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/jetbrains/plugins/reactnative/ReactNativeConfigurationEditor;", "Lcom/intellij/openapi/options/SettingsEditor;", "Lcom/jetbrains/plugins/reactnative/ReactNativeRunConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "browserSelector", "Lcom/intellij/ide/browsers/BrowserSelector;", "browserSelectorLabel", "Ljavax/swing/JLabel;", "buildAndLaunch", "Lcom/intellij/ui/components/JBCheckBox;", "debugPort", "Lcom/intellij/ui/PortField;", "debugPortLabel", "debuggerProcessModel", "Lcom/intellij/util/ui/RadioButtonEnumModel;", "Lcom/jetbrains/plugins/reactnative/DebuggerProcess;", "debuggerProcessPanel", "Ljavax/swing/JPanel;", "envVarsComponent", "Lcom/intellij/execution/configuration/EnvironmentVariablesTextFieldWithBrowseButton;", "nodeInterpreterField", "Lcom/intellij/javascript/nodejs/interpreter/NodeJsInterpreterField;", "packagerArgumentsField", "Lcom/intellij/ui/RawCommandLineEditor;", "packagerRunnerModel", "Lcom/jetbrains/plugins/reactnative/PackagerRunner;", "packagerRunnerPanel", "packagerScriptSelector", "Lcom/intellij/ui/TextFieldWithHistory;", "packagerScriptSelectorLabel", "platformModel", "Lcom/jetbrains/plugins/reactnative/ReactNativePlatform;", "platformPanel", "reactNativeField", "Lcom/intellij/javascript/nodejs/util/NodePackageField;", "runArgumentsField", "Lcom/intellij/util/textCompletion/TextFieldWithCompletion;", "startPackager", "workingDirField", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "applyEditorTo", "", "s", "createEditor", "Ljavax/swing/JComponent;", "createRadioButtonGroup", "T", "", "enumClass", "Ljava/lang/Class;", "buttonPanel", "resetEditorFrom", "updateBrowserSelectorVisibility", "updatePackagerRunnerVisibility", "ReactNativeDebugger"})
public final class ReactNativeConfigurationEditor
extends SettingsEditor<ReactNativeRunConfiguration> {
    private final NodePackageField reactNativeField;
    private final NodeJsInterpreterField nodeInterpreterField;
    private final TextFieldWithBrowseButton workingDirField;
    private final JBCheckBox startPackager;
    private final JPanel packagerRunnerPanel;
    private final RadioButtonEnumModel<PackagerRunner> packagerRunnerModel;
    private final JLabel packagerScriptSelectorLabel;
    private final TextFieldWithHistory packagerScriptSelector;
    private final RawCommandLineEditor packagerArgumentsField;
    private final JBCheckBox buildAndLaunch;
    private final JPanel platformPanel;
    private final RadioButtonEnumModel<ReactNativePlatform> platformModel;
    private final TextFieldWithCompletion runArgumentsField;
    private final EnvironmentVariablesTextFieldWithBrowseButton envVarsComponent;
    private final JPanel debuggerProcessPanel;
    private final RadioButtonEnumModel<DebuggerProcess> debuggerProcessModel;
    private final JLabel browserSelectorLabel;
    private final BrowserSelector browserSelector;
    private final JLabel debugPortLabel;
    private final PortField debugPort;

    private final void updateBrowserSelectorVisibility() {
        boolean isVisible = Intrinsics.areEqual((Object)((DebuggerProcess)this.debuggerProcessModel.getSelected()), (Object)DebuggerProcess.CHROME);
        this.browserSelectorLabel.setVisible(isVisible);
        this.browserSelector.getMainComponent().setVisible(isVisible);
        this.debugPortLabel.setVisible(isVisible);
        this.debugPort.setVisible(isVisible);
    }

    private final void updatePackagerRunnerVisibility() {
        boolean isVisible = Intrinsics.areEqual((Object)((PackagerRunner)this.packagerRunnerModel.getSelected()), (Object)PackagerRunner.NPM);
        this.packagerScriptSelector.setVisible(isVisible);
        this.packagerScriptSelectorLabel.setVisible(isVisible);
    }

    /*
     * WARNING - void declaration
     */
    private final <T extends Enum<T>> RadioButtonEnumModel<T> createRadioButtonGroup(Class<T> enumClass, JPanel buttonPanel) {
        void $receiver$iv$iv;
        T[] $receiver$iv;
        T[] TArray = $receiver$iv = enumClass.getEnumConstants();
        Collection destination$iv$iv = new ArrayList($receiver$iv.length);
        for (void item$iv$iv : $receiver$iv$iv) {
            void it;
            Enum enum_ = (Enum)item$iv$iv;
            Collection collection = destination$iv$iv;
            void v0 = it;
            if (v0 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.function.Supplier<kotlin.String>");
            }
            JRadioButton button = new JRadioButton((String)((Supplier)v0).get());
            button.setMargin(new Insets(0, 0, 0, 20));
            JRadioButton jRadioButton = button;
            collection.add(jRadioButton);
        }
        List buttons = (List)destination$iv$iv;
        ButtonGroup buttonGroup = new ButtonGroup();
        Iterable $receiver$iv2 = buttons;
        for (Object element$iv : $receiver$iv2) {
            JRadioButton it = (JRadioButton)element$iv;
            buttonGroup.add(it);
            buttonPanel.add(it);
        }
        RadioButtonEnumModel radioButtonEnumModel = RadioButtonEnumModel.bindEnum(enumClass, (ButtonGroup)buttonGroup);
        Intrinsics.checkExpressionValueIsNotNull((Object)radioButtonEnumModel, (String)"RadioButtonEnumModel.bin\u2026m(enumClass, buttonGroup)");
        return radioButtonEnumModel;
    }

    protected void resetEditorFrom(@NotNull ReactNativeRunConfiguration s) {
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        this.nodeInterpreterField.setInterpreterRef(s.getNodePath());
        NodePackage sPackage = s.getReactNativePackage();
        if (sPackage != null) {
            this.reactNativeField.setSelected(sPackage);
        } else {
            NodePackage defaultPackage = NodePackage.findDefaultPackage((Project)s.getProject(), (String)ReactNativeConfigurationEditorKt.getREACT_NATIVE_PACKAGE_NAME(), (NodeJsInterpreter)this.nodeInterpreterField.getInterpreter());
            if (defaultPackage != null) {
                this.reactNativeField.setSelected(defaultPackage);
            }
        }
        this.workingDirField.setText(s.getEffectiveWorkingDirectory());
        this.startPackager.setSelected(s.getStartPackager());
        if (s.getPackagerScripts().isEmpty()) {
            this.packagerRunnerModel.setSelected((Enum)PackagerRunner.BUILT_IN);
        } else {
            this.packagerRunnerModel.setSelected((Enum)PackagerRunner.NPM);
            this.packagerScriptSelector.setTextAndAddToHistory(ParametersListUtil.join(s.getPackagerScripts()));
        }
        this.packagerArgumentsField.setText(s.getPackagerArguments());
        this.buildAndLaunch.setSelected(s.getBuildAndLaunch());
        this.platformModel.setSelected((Enum)s.getPlatform());
        this.runArgumentsField.setText(s.getRunArguments());
        this.envVarsComponent.setData(s.getEnvData());
        String browserId = s.getBrowserId();
        if (browserId != null) {
            this.debuggerProcessModel.setSelected((Enum)DebuggerProcess.CHROME);
            JavaScriptDebugSettingsEditor.resetBrowserSelectorFromId((BrowserSelector)this.browserSelector, (String)browserId);
        } else {
            this.debuggerProcessModel.setSelected((Enum)DebuggerProcess.NODE);
        }
        this.debugPort.setNumber(s.getPackagerPort());
        this.updateBrowserSelectorVisibility();
        this.updatePackagerRunnerVisibility();
    }

    protected void applyEditorTo(@NotNull ReactNativeRunConfiguration s) {
        List list;
        String string;
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        s.setReactNativePackage(this.reactNativeField.getSelected());
        NodeJsInterpreterRef nodeJsInterpreterRef = this.nodeInterpreterField.getInterpreterRef();
        Intrinsics.checkExpressionValueIsNotNull((Object)nodeJsInterpreterRef, (String)"nodeInterpreterField.interpreterRef");
        s.setNodePath(nodeJsInterpreterRef);
        if (Intrinsics.areEqual((Object)this.workingDirField.getText(), (Object)s.findWorkingDirectory())) {
            string = "";
        } else {
            String string2 = this.workingDirField.getText();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"workingDirField.text");
        }
        s.setWorkingDirectory(string);
        s.setStartPackager(this.startPackager.isSelected());
        if (Intrinsics.areEqual((Object)((PackagerRunner)this.packagerRunnerModel.getSelected()), (Object)PackagerRunner.NPM)) {
            List list2 = ParametersListUtil.parse((String)this.packagerScriptSelector.getText());
            list = list2;
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"ParametersListUtil.parse\u2026kagerScriptSelector.text)");
        } else {
            list = CollectionsKt.emptyList();
        }
        s.setPackagerScripts(list);
        String string3 = this.packagerArgumentsField.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"packagerArgumentsField.text");
        s.setPackagerArguments(string3);
        s.setBuildAndLaunch(this.buildAndLaunch.isSelected());
        Enum enum_ = this.platformModel.getSelected();
        Intrinsics.checkExpressionValueIsNotNull((Object)enum_, (String)"platformModel.selected");
        s.setPlatform((ReactNativePlatform)enum_);
        String string4 = this.runArgumentsField.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"runArgumentsField.text");
        s.setRunArguments(string4);
        EnvironmentVariablesData environmentVariablesData = this.envVarsComponent.getData();
        Intrinsics.checkExpressionValueIsNotNull((Object)environmentVariablesData, (String)"envVarsComponent.data");
        s.setEnvData(environmentVariablesData);
        s.setBrowserId(Intrinsics.areEqual((Object)((DebuggerProcess)this.debuggerProcessModel.getSelected()), (Object)DebuggerProcess.CHROME) ? this.browserSelector.getSelectedBrowserId() : null);
        s.setPackagerPort(this.debugPort.getNumber());
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel packagerPanel2 = new FormBuilder(){

            protected int getFill(@Nullable JComponent component) {
                return 2;
            }
        }.addComponent((JComponent)this.startPackager).addLabeledComponent("Command:", (JComponent)this.packagerRunnerPanel).addLabeledComponent((JComponent)this.packagerScriptSelectorLabel, (JComponent)this.packagerScriptSelector).addLabeledComponent("Arguments:", (JComponent)this.packagerArgumentsField).getPanel();
        packagerPanel2.setBorder(IdeBorderFactory.createTitledBorder((String)"Packager"));
        JPanel runPanel = FormBuilder.createFormBuilder().addComponent((JComponent)this.buildAndLaunch).addLabeledComponent("Target platform:", (JComponent)this.platformPanel).addLabeledComponent("Arguments:", (JComponent)this.runArgumentsField).getPanel();
        runPanel.setBorder(IdeBorderFactory.createTitledBorder((String)"Build and Launch"));
        JPanel jPanel = FormBuilder.createFormBuilder().addLabeledComponent("Debugger process:", (JComponent)this.debuggerProcessPanel).addLabeledComponent((JComponent)this.browserSelectorLabel, this.browserSelector.getMainComponent()).addLabeledComponent((JComponent)this.debugPortLabel, (JComponent)this.debugPort).addLabeledComponent("Node &interpreter:", (JComponent)this.nodeInterpreterField, 12).addLabeledComponent("&React Native package:", (JComponent)this.reactNativeField).addLabeledComponent("&Working directory:", (JComponent)this.workingDirField).addLabeledComponent("Environment:", (JComponent)this.envVarsComponent).addComponent((JComponent)packagerPanel2).addComponent((JComponent)runPanel).getPanel();
        Intrinsics.checkExpressionValueIsNotNull((Object)jPanel, (String)"FormBuilder.createFormBu\u2026(runPanel)\n        .panel");
        return jPanel;
    }

    public ReactNativeConfigurationEditor(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.nodeInterpreterField = new NodeJsInterpreterField(project, false);
        this.workingDirField = new TextFieldWithBrowseButton();
        this.startPackager = new JBCheckBox("Start (if unchecked, packager must be started manually)");
        this.packagerRunnerPanel = new JPanel(new FlowLayout(3, 0, 0));
        this.packagerRunnerModel = this.createRadioButtonGroup(PackagerRunner.class, this.packagerRunnerPanel);
        this.packagerScriptSelectorLabel = new JLabel("Script:");
        this.packagerScriptSelector = NpmRunConfigurationEditor.createRunScriptsField((Project)this.nodeInterpreterField.getProject(), (Supplier)new Supplier<String>(this){
            final /* synthetic */ ReactNativeConfigurationEditor this$0;

            @NotNull
            public final String get() {
                return FileUtil.join((String[])new String[]{ReactNativeConfigurationEditor.access$getWorkingDirField$p(this.this$0).getText(), "package.json"});
            }
            {
                this.this$0 = reactNativeConfigurationEditor;
            }
        });
        this.packagerArgumentsField = new RawCommandLineEditor();
        this.buildAndLaunch = new JBCheckBox("Run (if unchecked, application must be started manually from the device)");
        this.platformPanel = new JPanel(new FlowLayout(3, 0, 0));
        this.envVarsComponent = new EnvironmentVariablesTextFieldWithBrowseButton();
        this.debuggerProcessPanel = new JPanel(new FlowLayout(3, 0, 0));
        this.reactNativeField = new NodePackageField(this.nodeInterpreterField, ReactNativeConfigurationEditorKt.getREACT_NATIVE_PACKAGE_NAME());
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        this.workingDirField.addBrowseFolderListener(null, null, project, descriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT);
        FileChooserFactory.getInstance().installFileCompletion(this.workingDirField.getTextField(), descriptor, false, (Disposable)this.workingDirField);
        this.packagerScriptSelectorLabel.setLabelFor((Component)this.packagerScriptSelector);
        this.packagerRunnerModel.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent it) {
                this.updatePackagerRunnerVisibility();
            }
        });
        this.platformModel = this.createRadioButtonGroup(ReactNativePlatform.class, this.platformPanel);
        final TextFieldWithAutoCompletion.StringsCompletionProvider provider = new TextFieldWithAutoCompletion.StringsCompletionProvider((Collection)ReactNativePlatform.values()[0].getPossibleArguments(), null);
        this.runArgumentsField = new TextFieldWithCompletion(project, (TextCompletionProvider)provider, "", true, false, false);
        this.platformModel.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent it) {
                provider.setItems((Collection)((ReactNativePlatform)platformModel.getSelected()).getPossibleArguments());
            }
        });
        this.debuggerProcessModel = this.createRadioButtonGroup(DebuggerProcess.class, this.debuggerProcessPanel);
        this.browserSelector = new BrowserSelector((Condition)3.INSTANCE);
        this.browserSelectorLabel = new JLabel("Browser:");
        this.browserSelectorLabel.setLabelFor(this.browserSelector.getMainComponent());
        this.debuggerProcessModel.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent it) {
                this.updateBrowserSelectorVisibility();
            }
        });
        this.debugPort = new PortField();
        this.debugPortLabel = new JLabel("Port:");
        this.debugPortLabel.setLabelFor((Component)this.debugPort);
    }

    @NotNull
    public static final /* synthetic */ TextFieldWithBrowseButton access$getWorkingDirField$p(ReactNativeConfigurationEditor $this) {
        return $this.workingDirField;
    }
}

