/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.reactnative;

import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.ide.browsers.BrowserFamily;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.WebBrowserManager;
import com.intellij.javascript.JSRunProfileWithCompileBeforeLaunchOption;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.jetbrains.nodeJs.NodeJSDebuggableConfiguration;
import com.jetbrains.plugins.reactnative.ReactNativeConfigurationEditor;
import com.jetbrains.plugins.reactnative.ReactNativePlatform;
import com.jetbrains.plugins.reactnative.ReactNativeProcessState;
import com.jetbrains.plugins.reactnative.ReactNativeRunConfigurationKt;
import java.net.InetSocketAddress;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010K\u001a\u00020LH\u0016J*\u0010M\u001a\u00020N2\u0006\u0010O\u001a\u00020P2\u0006\u0010Q\u001a\u00020R2\b\u0010S\u001a\u0004\u0018\u00010T2\u0006\u0010U\u001a\u00020VH\u0016J\u0006\u0010W\u001a\u00020\u000eJ\b\u0010X\u001a\u00020YH\u0016J\u0018\u0010Z\u001a\u00020[2\u0006\u0010\\\u001a\u00020]2\u0006\u0010U\u001a\u00020VH\u0016J\u0010\u0010^\u001a\u00020L2\u0006\u0010_\u001a\u00020`H\u0016J\u0010\u0010a\u001a\u00020L2\u0006\u0010_\u001a\u00020`H\u0016R\u0013\u0010\t\u001a\u0004\u0018\u00010\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0010R\u001a\u0010\u001b\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001a\u0010'\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u0010\"\u0004\b)\u0010\u0012R\u001a\u0010*\u001a\u00020+X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R \u00100\u001a\b\u0012\u0004\u0012\u00020\u000e01X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u001a\u00106\u001a\u000207X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u00109\"\u0004\b:\u0010;R\u001c\u0010<\u001a\u0004\u0018\u00010=X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010?\"\u0004\b@\u0010AR\u001a\u0010B\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bC\u0010\u0010\"\u0004\bD\u0010\u0012R\u001a\u0010E\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bF\u0010\u0016\"\u0004\bG\u0010\u0018R\u001a\u0010H\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bI\u0010\u0010\"\u0004\bJ\u0010\u0012\u00a8\u0006b"}, d2={"Lcom/jetbrains/plugins/reactnative/ReactNativeRunConfiguration;", "Lcom/intellij/execution/configurations/LocatableConfigurationBase;", "Lcom/jetbrains/nodeJs/NodeJSDebuggableConfiguration;", "Lcom/intellij/javascript/JSRunProfileWithCompileBeforeLaunchOption;", "project", "Lcom/intellij/openapi/project/Project;", "factory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/execution/configurations/ConfigurationFactory;)V", "browser", "Lcom/intellij/ide/browsers/WebBrowser;", "getBrowser", "()Lcom/intellij/ide/browsers/WebBrowser;", "browserId", "", "getBrowserId", "()Ljava/lang/String;", "setBrowserId", "(Ljava/lang/String;)V", "buildAndLaunch", "", "getBuildAndLaunch", "()Z", "setBuildAndLaunch", "(Z)V", "effectiveWorkingDirectory", "getEffectiveWorkingDirectory", "envData", "Lcom/intellij/execution/configuration/EnvironmentVariablesData;", "getEnvData", "()Lcom/intellij/execution/configuration/EnvironmentVariablesData;", "setEnvData", "(Lcom/intellij/execution/configuration/EnvironmentVariablesData;)V", "nodePath", "Lcom/intellij/javascript/nodejs/interpreter/NodeJsInterpreterRef;", "getNodePath", "()Lcom/intellij/javascript/nodejs/interpreter/NodeJsInterpreterRef;", "setNodePath", "(Lcom/intellij/javascript/nodejs/interpreter/NodeJsInterpreterRef;)V", "packagerArguments", "getPackagerArguments", "setPackagerArguments", "packagerPort", "", "getPackagerPort", "()I", "setPackagerPort", "(I)V", "packagerScripts", "", "getPackagerScripts", "()Ljava/util/List;", "setPackagerScripts", "(Ljava/util/List;)V", "platform", "Lcom/jetbrains/plugins/reactnative/ReactNativePlatform;", "getPlatform", "()Lcom/jetbrains/plugins/reactnative/ReactNativePlatform;", "setPlatform", "(Lcom/jetbrains/plugins/reactnative/ReactNativePlatform;)V", "reactNativePackage", "Lcom/intellij/javascript/nodejs/util/NodePackage;", "getReactNativePackage", "()Lcom/intellij/javascript/nodejs/util/NodePackage;", "setReactNativePackage", "(Lcom/intellij/javascript/nodejs/util/NodePackage;)V", "runArguments", "getRunArguments", "setRunArguments", "startPackager", "getStartPackager", "setStartPackager", "workingDirectory", "getWorkingDirectory", "setWorkingDirectory", "checkConfiguration", "", "createDebugProcess", "Lcom/intellij/xdebugger/XDebugProcess;", "socketAddress", "Ljava/net/InetSocketAddress;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "executionResult", "Lcom/intellij/execution/ExecutionResult;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "findWorkingDirectory", "getConfigurationEditor", "Lcom/jetbrains/plugins/reactnative/ReactNativeConfigurationEditor;", "getState", "Lcom/intellij/execution/configurations/RunProfileState;", "executor", "Lcom/intellij/execution/Executor;", "readExternal", "element", "Lorg/jdom/Element;", "writeExternal", "ReactNativeDebugger"})
public final class ReactNativeRunConfiguration
extends LocatableConfigurationBase
implements NodeJSDebuggableConfiguration,
JSRunProfileWithCompileBeforeLaunchOption {
    @Nullable
    private String browserId;
    private int packagerPort;
    @Nullable
    private NodePackage reactNativePackage;
    @NotNull
    private NodeJsInterpreterRef nodePath;
    @NotNull
    private String workingDirectory;
    private boolean startPackager;
    @NotNull
    private List<String> packagerScripts;
    @NotNull
    private String packagerArguments;
    private boolean buildAndLaunch;
    @NotNull
    private ReactNativePlatform platform;
    @NotNull
    private String runArguments;
    @NotNull
    private EnvironmentVariablesData envData;

    @Nullable
    public final String getBrowserId() {
        return this.browserId;
    }

    public final void setBrowserId(@Nullable String string) {
        this.browserId = string;
    }

    public final int getPackagerPort() {
        return this.packagerPort;
    }

    public final void setPackagerPort(int n) {
        this.packagerPort = n;
    }

    @Nullable
    public final NodePackage getReactNativePackage() {
        return this.reactNativePackage;
    }

    public final void setReactNativePackage(@Nullable NodePackage nodePackage) {
        this.reactNativePackage = nodePackage;
    }

    @NotNull
    public final NodeJsInterpreterRef getNodePath() {
        return this.nodePath;
    }

    public final void setNodePath(@NotNull NodeJsInterpreterRef nodeJsInterpreterRef) {
        Intrinsics.checkParameterIsNotNull((Object)nodeJsInterpreterRef, (String)"<set-?>");
        this.nodePath = nodeJsInterpreterRef;
    }

    @NotNull
    public final String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public final void setWorkingDirectory(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.workingDirectory = string;
    }

    public final boolean getStartPackager() {
        return this.startPackager;
    }

    public final void setStartPackager(boolean bl) {
        this.startPackager = bl;
    }

    @NotNull
    public final List<String> getPackagerScripts() {
        return this.packagerScripts;
    }

    public final void setPackagerScripts(@NotNull List<String> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"<set-?>");
        this.packagerScripts = list;
    }

    @NotNull
    public final String getPackagerArguments() {
        return this.packagerArguments;
    }

    public final void setPackagerArguments(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.packagerArguments = string;
    }

    public final boolean getBuildAndLaunch() {
        return this.buildAndLaunch;
    }

    public final void setBuildAndLaunch(boolean bl) {
        this.buildAndLaunch = bl;
    }

    @NotNull
    public final ReactNativePlatform getPlatform() {
        return this.platform;
    }

    public final void setPlatform(@NotNull ReactNativePlatform reactNativePlatform) {
        Intrinsics.checkParameterIsNotNull((Object)reactNativePlatform, (String)"<set-?>");
        this.platform = reactNativePlatform;
    }

    @NotNull
    public final String getRunArguments() {
        return this.runArguments;
    }

    public final void setRunArguments(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.runArguments = string;
    }

    @NotNull
    public final EnvironmentVariablesData getEnvData() {
        return this.envData;
    }

    public final void setEnvData(@NotNull EnvironmentVariablesData environmentVariablesData) {
        Intrinsics.checkParameterIsNotNull((Object)environmentVariablesData, (String)"<set-?>");
        this.envData = environmentVariablesData;
    }

    @NotNull
    public final String getEffectiveWorkingDirectory() {
        String string;
        CharSequence charSequence = this.workingDirectory;
        if (charSequence.length() == 0) {
            String string2 = this.findWorkingDirectory();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"findWorkingDirectory()");
        } else {
            string = this.workingDirectory;
        }
        return string;
    }

    @NotNull
    public final String findWorkingDirectory() {
        return StringUtil.notNullize((String)this.getProject().getBasePath());
    }

    @NotNull
    public XDebugProcess createDebugProcess(@NotNull InetSocketAddress socketAddress, @NotNull XDebugSession session2, @Nullable ExecutionResult executionResult, @NotNull ExecutionEnvironment environment) {
        Intrinsics.checkParameterIsNotNull((Object)socketAddress, (String)"socketAddress");
        Intrinsics.checkParameterIsNotNull((Object)session2, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        throw (Throwable)new RuntimeException("should not be called");
    }

    @NotNull
    public ReactNativeConfigurationEditor getConfigurationEditor() {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        return new ReactNativeConfigurationEditor(project);
    }

    @NotNull
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) {
        Intrinsics.checkParameterIsNotNull((Object)executor, (String)"executor");
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        return new ReactNativeProcessState(this, environment);
    }

    public void checkConfiguration() {
        CharSequence charSequence;
        super.checkConfiguration();
        NodeJsInterpreter interpreter = this.nodePath.resolve(this.getProject());
        NodeJsLocalInterpreter.checkForRunConfiguration((NodeJsInterpreter)interpreter);
        NodePackage reactNative = this.reactNativePackage;
        if (reactNative == null || (charSequence = (CharSequence)reactNative.getSystemDependentPath()).length() == 0) {
            throw (Throwable)new RuntimeConfigurationException("react-native is not specified");
        }
        if (!reactNative.isValid()) {
            throw (Throwable)new RuntimeConfigurationException("invalid react-native");
        }
        WebBrowser webBrowser = this.getBrowser();
        if (webBrowser != null && webBrowser.getPath() == null) {
            throw (Throwable)new RuntimeConfigurationException("browser path is empty");
        }
    }

    public void writeExternal(@NotNull Element element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        super.writeExternal(element);
        CharSequence charSequence = this.workingDirectory;
        if (!(charSequence.length() == 0)) {
            JDOMExternalizerUtil.writeCustomField((Element)element, (String)ReactNativeRunConfigurationKt.access$getWORKING_DIR_TAG$p(), (String)this.workingDirectory);
        }
        JDOMExternalizerUtil.writeCustomField((Element)element, (String)ReactNativeRunConfigurationKt.access$getNODE_INTERPRETER_TAG$p(), (String)this.nodePath.getReferenceName());
        if (this.reactNativePackage != null) {
            NodePackage nodePackage = this.reactNativePackage;
            JDOMExternalizerUtil.writeCustomField((Element)element, (String)ReactNativeRunConfigurationKt.access$getREACT_NATIVE_TAG$p(), (String)(nodePackage != null ? nodePackage.getSystemIndependentPath() : null));
        }
        JDOMExternalizerUtil.writeCustomField((Element)element, (String)ReactNativeRunConfigurationKt.access$getPLATFORM_TAG$p(), (String)this.platform.name());
        if (!this.startPackager) {
            JDOMExternalizerUtil.writeCustomField((Element)element, (String)ReactNativeRunConfigurationKt.access$getSTART_PACKAGER$p(), (String)String.valueOf(Boolean.FALSE));
        }
        if (!this.packagerScripts.isEmpty()) {
            Element scriptsElement = new Element(ReactNativeRunConfigurationKt.access$getPACKAGER_SCRIPTS_TAG$p());
            JDOMExternalizerUtil.addChildrenWithValueAttribute((Element)scriptsElement, (String)ReactNativeRunConfigurationKt.access$getPACKAGER_SCRIPTS_TAG$p(), this.packagerScripts);
            element.addContent(scriptsElement);
        }
        if (!((charSequence = (CharSequence)this.packagerArguments).length() == 0)) {
            JDOMExternalizerUtil.writeCustomField((Element)element, (String)ReactNativeRunConfigurationKt.access$getPACKAGER_ARGUMENTS_TAG$p(), (String)this.packagerArguments);
        }
        if (!((charSequence = (CharSequence)this.runArguments).length() == 0)) {
            JDOMExternalizerUtil.writeCustomField((Element)element, (String)ReactNativeRunConfigurationKt.access$getRUN_ARGUMENTS_TAG$p(), (String)this.runArguments);
        }
        this.envData.writeExternal(element);
        JDOMExternalizerUtil.writeCustomField((Element)element, (String)ReactNativeRunConfigurationKt.access$getONLY_START_PACKAGER$p(), null);
        if (!this.buildAndLaunch) {
            JDOMExternalizerUtil.writeCustomField((Element)element, (String)ReactNativeRunConfigurationKt.access$getBUILD_AND_LAUNCH$p(), (String)String.valueOf(Boolean.FALSE));
        }
        if (this.browserId != null) {
            JDOMExternalizerUtil.writeCustomField((Element)element, (String)ReactNativeRunConfigurationKt.access$getBROWSER_TAG$p(), (String)this.browserId);
        }
        if (this.packagerPort != 8081) {
            JDOMExternalizerUtil.writeCustomField((Element)element, (String)ReactNativeRunConfigurationKt.access$getDEBUG_PORT_TAG$p(), (String)String.valueOf(this.packagerPort));
        }
    }

    public void readExternal(@NotNull Element element) {
        int n;
        String runArguments;
        ReactNativeRunConfiguration reactNativeRunConfiguration;
        Object object;
        block16: {
            block15: {
                String startPackager;
                String platformTag;
                String reactNativeTag;
                String interpreterRefName;
                Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                super.readExternal(element);
                String workingDir = JDOMExternalizerUtil.readCustomField((Element)element, (String)ReactNativeRunConfigurationKt.access$getWORKING_DIR_TAG$p());
                if (workingDir != null) {
                    this.workingDirectory = workingDir;
                }
                if ((interpreterRefName = JDOMExternalizerUtil.readCustomField((Element)element, (String)ReactNativeRunConfigurationKt.access$getNODE_INTERPRETER_TAG$p())) != null) {
                    NodeJsInterpreterRef nodeJsInterpreterRef = NodeJsInterpreterRef.create((String)interpreterRefName);
                    Intrinsics.checkExpressionValueIsNotNull((Object)nodeJsInterpreterRef, (String)"NodeJsInterpreterRef.create(interpreterRefName)");
                    this.nodePath = nodeJsInterpreterRef;
                }
                if ((reactNativeTag = JDOMExternalizerUtil.readCustomField((Element)element, (String)ReactNativeRunConfigurationKt.access$getREACT_NATIVE_TAG$p())) != null) {
                    this.reactNativePackage = new NodePackage(reactNativeTag);
                }
                if ((platformTag = JDOMExternalizerUtil.readCustomField((Element)element, (String)ReactNativeRunConfigurationKt.access$getPLATFORM_TAG$p())) != null) {
                    this.platform = ReactNativePlatform.valueOf(platformTag);
                }
                if ((startPackager = JDOMExternalizerUtil.readCustomField((Element)element, (String)ReactNativeRunConfigurationKt.access$getSTART_PACKAGER$p())) != null) {
                    Boolean bl = Boolean.valueOf(startPackager);
                    Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"valueOf(startPackager)");
                    this.startPackager = bl;
                }
                ReactNativeRunConfiguration reactNativeRunConfiguration2 = this;
                object = element.getChild(ReactNativeRunConfigurationKt.access$getPACKAGER_SCRIPTS_TAG$p());
                if (object == null) break block15;
                Element element2 = object;
                reactNativeRunConfiguration = reactNativeRunConfiguration2;
                Element it = element2;
                List list = JDOMExternalizerUtil.getChildrenValueAttributes((Element)it, (String)ReactNativeRunConfigurationKt.access$getPACKAGER_SCRIPTS_TAG$p());
                reactNativeRunConfiguration2 = reactNativeRunConfiguration;
                object = list;
                if (object != null) break block16;
            }
            object = CollectionsKt.emptyList();
        }
        reactNativeRunConfiguration2.packagerScripts = object;
        String packagerArguments = JDOMExternalizerUtil.readCustomField((Element)element, (String)ReactNativeRunConfigurationKt.access$getPACKAGER_ARGUMENTS_TAG$p());
        if (packagerArguments != null) {
            this.packagerArguments = packagerArguments;
        }
        if ((runArguments = JDOMExternalizerUtil.readCustomField((Element)element, (String)ReactNativeRunConfigurationKt.access$getRUN_ARGUMENTS_TAG$p())) != null) {
            this.runArguments = runArguments;
        }
        EnvironmentVariablesData environmentVariablesData = EnvironmentVariablesData.readExternal((Element)element);
        Intrinsics.checkExpressionValueIsNotNull((Object)environmentVariablesData, (String)"EnvironmentVariablesData.readExternal(element)");
        this.envData = environmentVariablesData;
        String buildAndLaunch = JDOMExternalizerUtil.readCustomField((Element)element, (String)ReactNativeRunConfigurationKt.access$getBUILD_AND_LAUNCH$p());
        String onlyStartPackager = JDOMExternalizerUtil.readCustomField((Element)element, (String)ReactNativeRunConfigurationKt.access$getONLY_START_PACKAGER$p());
        if (buildAndLaunch != null) {
            Boolean bl = Boolean.valueOf(buildAndLaunch);
            Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"valueOf(buildAndLaunch)");
            this.buildAndLaunch = bl;
        } else if (onlyStartPackager != null) {
            this.buildAndLaunch = Boolean.valueOf(onlyStartPackager) == false;
        }
        this.browserId = JDOMExternalizerUtil.readCustomField((Element)element, (String)ReactNativeRunConfigurationKt.access$getBROWSER_TAG$p());
        ReactNativeRunConfiguration reactNativeRunConfiguration3 = this;
        String string = JDOMExternalizerUtil.readCustomField((Element)element, (String)ReactNativeRunConfigurationKt.access$getDEBUG_PORT_TAG$p());
        if (string != null) {
            String string2 = string;
            reactNativeRunConfiguration = reactNativeRunConfiguration3;
            int n2 = Integer.parseInt(string2);
            reactNativeRunConfiguration3 = reactNativeRunConfiguration;
            n = n2;
        } else {
            n = 8081;
        }
        reactNativeRunConfiguration3.packagerPort = n;
    }

    @Nullable
    public final WebBrowser getBrowser() {
        return WebBrowserManager.getInstance().findBrowserById(this.browserId);
    }

    public ReactNativeRunConfiguration(@NotNull Project project, @NotNull ConfigurationFactory factory) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)factory, (String)"factory");
        super(project, factory, "");
        this.browserId = WebBrowserManager.getInstance().getFirstBrowser(BrowserFamily.CHROME).getId().toString();
        this.packagerPort = 8081;
        NodeJsInterpreterRef nodeJsInterpreterRef = NodeJsInterpreterRef.createProjectRef();
        Intrinsics.checkExpressionValueIsNotNull((Object)nodeJsInterpreterRef, (String)"NodeJsInterpreterRef.createProjectRef()");
        this.nodePath = nodeJsInterpreterRef;
        this.workingDirectory = "";
        this.startPackager = true;
        this.packagerScripts = CollectionsKt.emptyList();
        this.packagerArguments = "";
        this.buildAndLaunch = true;
        this.platform = ReactNativePlatform.ANDROID;
        this.runArguments = "";
        EnvironmentVariablesData environmentVariablesData = EnvironmentVariablesData.DEFAULT;
        Intrinsics.checkExpressionValueIsNotNull((Object)environmentVariablesData, (String)"EnvironmentVariablesData.DEFAULT");
        this.envData = environmentVariablesData;
    }
}

