/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.ui;

import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.remote.RemoteCredentials;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.util.AsyncProducer;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.plugins.remotesdk.RemoteSdkUtil;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.ui.ServerBrowserDialog;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JTextField;

public class RemoteBrowseActionListener
implements ActionListener {
    private JTextField myPathField;
    private String myTitle;
    private AsyncProducer<RemoteCredentials> mySdkDataProducer;
    private boolean myFoldersOnly = false;

    public RemoteBrowseActionListener(JTextField pathField, String title, AsyncProducer<RemoteCredentials> sdkDataProducer) {
        this.myPathField = pathField;
        this.myTitle = title;
        this.mySdkDataProducer = sdkDataProducer;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.mySdkDataProducer.produce(data -> {
            if (RemoteSdkUtil.testConnection((Component)this.myPathField, data, false)) {
                UIUtil.invokeLaterIfNeeded(() -> {
                    WebServerConfig.RemotePath path;
                    ServerBrowserDialog d = RemoteSdkUtil.showBrowseRemoteDialog(this.myTitle, this.myPathField, this.myFoldersOnly, (Deployable)RemoteSdkUtil.createDeployable(data));
                    if (d.isOK() && (path = d.getPath()) != null) {
                        this.myPathField.setText(path.path);
                    }
                });
            }
        });
    }

    public RemoteBrowseActionListener withFoldersOnly(boolean foldersOnly) {
        this.myFoldersOnly = foldersOnly;
        return this;
    }

    public static void addShowBrowseRemoteDialogAction(TextFieldWithBrowseButton pathField, String title, AsyncProducer<RemoteCredentials> producer) {
        pathField.addActionListener((ActionListener)new RemoteBrowseActionListener(pathField.getTextField(), title, producer));
    }

    public static void addShowBrowseRemoteDialogAction(ComboboxWithBrowseButton pathField, String title, AsyncProducer<RemoteCredentials> producer) {
        Component component = pathField.getComboBox().getEditor().getEditorComponent();
        if (component instanceof JTextField) {
            pathField.addActionListener((ActionListener)new RemoteBrowseActionListener((JTextField)component, title, producer));
        }
    }

    public static void addShowBrowseRemoteDialogAction(JTextField pathField, JButton button, String title, AsyncProducer<RemoteCredentials> producer) {
        button.addActionListener(new RemoteBrowseActionListener(pathField, title, producer));
    }
}

