/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.database;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.android.database.AndroidDataSource;

@com.intellij.openapi.components.State(name="AndroidDataSourceStorage", storages={@Storage(value="$WORKSPACE_FILE$")})
public class AndroidDataSourceStorage
implements PersistentStateComponent<State> {
    private final List<AndroidDataSource> myDataSources = ContainerUtil.createLockFreeCopyOnWriteList();

    public static AndroidDataSourceStorage getInstance(Project project) {
        return (AndroidDataSourceStorage)ServiceManager.getService((Project)project, AndroidDataSourceStorage.class);
    }

    public State getState() {
        State state = new State();
        for (AndroidDataSource dataSource : this.myDataSources) {
            state.myDataSources.add(dataSource.buildFullState());
        }
        return state;
    }

    public void loadState(State state) {
        this.myDataSources.clear();
        for (AndroidDataSource.State dataSourceState : state.myDataSources) {
            AndroidDataSource o = new AndroidDataSource();
            o.loadState(dataSourceState);
            this.addDataSource(o);
        }
        for (AndroidDataSource o : this.myDataSources) {
            o.ensureDriverConfigured();
        }
    }

    public List<AndroidDataSource> getDataSources() {
        return new ArrayList<AndroidDataSource>(this.myDataSources);
    }

    public void removeDataSource(AndroidDataSource dataSource) {
        this.myDataSources.remove((Object)dataSource);
    }

    public void addDataSource(AndroidDataSource dataSource) {
        dataSource.init();
        this.myDataSources.add(dataSource);
    }

    public static class State {
        @XCollection(propertyElementName="data-sources")
        public List<AndroidDataSource.State> myDataSources = new ArrayList<AndroidDataSource.State>();
    }
}

