/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.UI.editorActions.completionProviders;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.coldFusion.model.CfmlUtil;
import com.intellij.coldFusion.model.info.CfmlAttributeDescription;
import com.intellij.coldFusion.model.lexer.CfmlTokenTypes;
import com.intellij.coldFusion.model.psi.CfmlComponent;
import com.intellij.coldFusion.model.psi.CfmlTag;
import com.intellij.coldFusion.model.psi.impl.CfmlAttributeImpl;
import com.intellij.coldFusion.model.psi.impl.CfmlPropertyImpl;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.HashSet;
import org.jetbrains.annotations.NotNull;

class CfmlAttributeNamesCompletionProvider
extends CompletionProvider<CompletionParameters> {
    CfmlAttributeNamesCompletionProvider() {
    }

    public void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
        PsiElement element;
        if (parameters == null) {
            CfmlAttributeNamesCompletionProvider.$$$reportNull$$$0(0);
        }
        if (result == null) {
            CfmlAttributeNamesCompletionProvider.$$$reportNull$$$0(1);
        }
        String tagName = "";
        for (element = parameters.getPosition(); !(element == null || element instanceof CfmlTag || element instanceof CfmlComponent || element instanceof CfmlPropertyImpl); element = element.getParent()) {
            PsiElement superPrevNode;
            PsiElement prevNode = element.getPrevSibling();
            PsiElement psiElement = superPrevNode = prevNode != null ? prevNode.getPrevSibling() : null;
            if (superPrevNode == null || !superPrevNode.getText().equalsIgnoreCase("property")) continue;
            tagName = "cfproperty";
            break;
        }
        if (element == null) {
            return;
        }
        if (tagName.isEmpty()) {
            tagName = element instanceof CfmlTag ? ((CfmlTag)element).getTagName() : (element instanceof CfmlPropertyImpl ? "cfproperty" : "cfcomponent");
        }
        HashSet excluded = new HashSet();
        CfmlAttributeImpl[] attributes = (CfmlAttributeImpl[])PsiTreeUtil.getChildrenOfType((PsiElement)element, CfmlAttributeImpl.class);
        if (attributes != null) {
            for (CfmlAttributeImpl attribute : attributes) {
                excluded.add(attribute.getAttributeName());
            }
        }
        for (CfmlAttributeDescription s : CfmlUtil.getAttributes(tagName, element.getProject())) {
            if (s.getName() == null || excluded.contains(s.getName())) continue;
            result.addElement((LookupElement)TailTypeDecorator.withTail((LookupElement)LookupElementBuilder.create((String)s.getName()).withCaseSensitivity(false), (TailType)new TailType(){

                public int processTail(Editor editor, int tailOffset) {
                    HighlighterIterator iterator = ((EditorEx)editor).getHighlighter().createIterator(tailOffset);
                    if (!iterator.atEnd() && iterator.getTokenType() == CfmlTokenTypes.WHITE_SPACE) {
                        iterator.advance();
                    }
                    if (iterator.atEnd() || iterator.getTokenType() != CfmlTokenTypes.ASSIGN) {
                        editor.getDocument().insertString(tailOffset, (CharSequence)"=\"\"");
                        return 1.moveCaret((Editor)editor, (int)tailOffset, (int)2);
                    }
                    iterator.advance();
                    int offset = iterator.getStart();
                    if (!iterator.atEnd() && iterator.getTokenType() == CfmlTokenTypes.WHITE_SPACE) {
                        iterator.advance();
                    }
                    if (!iterator.atEnd() && CfmlTokenTypes.STRING_ELEMENTS.contains(iterator.getTokenType())) {
                        return tailOffset;
                    }
                    editor.getDocument().insertString(offset, (CharSequence)"\"\"");
                    return 1.moveCaret((Editor)editor, (int)tailOffset, (int)(offset - tailOffset + 1));
                }
            }));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "parameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "com/intellij/coldFusion/UI/editorActions/completionProviders/CfmlAttributeNamesCompletionProvider";
        objectArray[2] = "addCompletions";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

