/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.UI.editorActions.typedHandlers;

import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.coldFusion.UI.editorActions.matchers.CfmlBraceMatcher;
import com.intellij.coldFusion.UI.editorActions.typedHandlers.DocumentUtils;
import com.intellij.coldFusion.UI.editorActions.utils.CfmlEditorUtil;
import com.intellij.coldFusion.model.CfmlLanguage;
import com.intellij.coldFusion.model.CfmlUtil;
import com.intellij.coldFusion.model.files.CfmlFile;
import com.intellij.coldFusion.model.lexer.CfmlTokenTypes;
import com.intellij.coldFusion.model.psi.CfmlTag;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SystemProperties;
import org.jetbrains.annotations.NotNull;

public class CfmlTypedHandler
extends TypedHandlerDelegate {
    static final boolean ourEnableDoublePoundInsertion = SystemProperties.getBooleanProperty((String)"idea.cfml.insert.pair.pound", (boolean)true);

    @NotNull
    public TypedHandlerDelegate.Result checkAutoPopup(char charTyped, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        PsiFile cfmlFile;
        if (project == null) {
            CfmlTypedHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            CfmlTypedHandler.$$$reportNull$$$0(1);
        }
        if (file == null) {
            CfmlTypedHandler.$$$reportNull$$$0(2);
        }
        if (CfmlTypedHandler.isNotCfmlFile(cfmlFile = file.getViewProvider().getPsi((Language)CfmlLanguage.INSTANCE), editor)) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
            if (result == null) {
                CfmlTypedHandler.$$$reportNull$$$0(3);
            }
            return result;
        }
        if (charTyped == '/') {
            CfmlUtil.showCompletion(editor);
        }
        TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
        if (result == null) {
            CfmlTypedHandler.$$$reportNull$$$0(4);
        }
        return result;
    }

    @NotNull
    public TypedHandlerDelegate.Result beforeCharTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, @NotNull FileType fileType) {
        PsiFile cfmlFile;
        if (project == null) {
            CfmlTypedHandler.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            CfmlTypedHandler.$$$reportNull$$$0(6);
        }
        if (file == null) {
            CfmlTypedHandler.$$$reportNull$$$0(7);
        }
        if (fileType == null) {
            CfmlTypedHandler.$$$reportNull$$$0(8);
        }
        if (CfmlTypedHandler.isNotCfmlFile(cfmlFile = file.getViewProvider().getPsi((Language)CfmlLanguage.INSTANCE), editor)) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
            if (result == null) {
                CfmlTypedHandler.$$$reportNull$$$0(9);
            }
            return result;
        }
        int offset = editor.getCaretModel().getOffset();
        if (c == '{') {
            CfmlBraceMatcher braceMatcher = new CfmlBraceMatcher();
            HighlighterIterator iterator = ((EditorEx)editor).getHighlighter().createIterator(offset);
            if (!braceMatcher.isLBraceToken(iterator, editor.getDocument().getCharsSequence(), fileType)) {
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)"}", (boolean)true, (int)0);
            }
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
            if (result == null) {
                CfmlTypedHandler.$$$reportNull$$$0(10);
            }
            return result;
        }
        if (c == '#') {
            if (ourEnableDoublePoundInsertion && CfmlEditorUtil.countSharpsBalance(editor) == 0) {
                char charAtOffset = DocumentUtils.getCharAt(editor.getDocument(), offset);
                if (charAtOffset == '#') {
                    EditorModificationUtil.moveCaretRelatively((Editor)editor, (int)1);
                    TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
                    if (result == null) {
                        CfmlTypedHandler.$$$reportNull$$$0(11);
                    }
                    return result;
                }
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)"#", (boolean)true, (int)0);
            }
        } else if (c == '>') {
            if (((EditorEx)editor).getHighlighter().createIterator(editor.getCaretModel().getOffset()).getTokenType() == CfmlTokenTypes.COMMENT || ((EditorEx)editor).getHighlighter().createIterator(editor.getCaretModel().getOffset()).getTokenType().getLanguage() != CfmlLanguage.INSTANCE) {
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
                if (result == null) {
                    CfmlTypedHandler.$$$reportNull$$$0(12);
                }
                return result;
            }
            CfmlTypedHandler.insertCloseTagIfNeeded(editor, cfmlFile, project);
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
            if (result == null) {
                CfmlTypedHandler.$$$reportNull$$$0(13);
            }
            return result;
        }
        TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
        if (result == null) {
            CfmlTypedHandler.$$$reportNull$$$0(14);
        }
        return result;
    }

    public static boolean insertCloseTagIfNeeded(Editor editor, PsiFile file, Project project) {
        PsiElement tagElement;
        Document document = editor.getDocument();
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        int offset = editor.getCaretModel().getOffset();
        documentManager.commitDocument(document);
        char charAtOffset = DocumentUtils.getCharAt(document, offset);
        if (charAtOffset != '>') {
            EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)">", (boolean)true, (int)0);
        }
        EditorModificationUtil.moveCaretRelatively((Editor)editor, (int)1);
        if (DocumentUtils.getCharAt(document, ++offset - 2) == '/') {
            return false;
        }
        HighlighterIterator iterator = ((EditorEx)editor).getHighlighter().createIterator(offset - 2);
        while (!iterator.atEnd() && !iterator.getTokenType().equals(CfmlTokenTypes.CF_TAG_NAME)) {
            if (CfmlUtil.isControlToken(iterator.getTokenType())) {
                return false;
            }
            iterator.retreat();
        }
        if (!iterator.atEnd()) {
            iterator.retreat();
            if (!iterator.atEnd() && iterator.getTokenType().equals(CfmlTokenTypes.LSLASH_ANGLEBRACKET)) {
                return false;
            }
            iterator.advance();
        }
        if (iterator.atEnd()) {
            return false;
        }
        String tagName = document.getCharsSequence().subSequence(iterator.getStart(), iterator.getEnd()).toString();
        if (CfmlUtil.isSingleCfmlTag(tagName, project) || CfmlUtil.isUserDefined(tagName)) {
            return false;
        }
        for (tagElement = file.findElementAt(iterator.getStart()); tagElement != null && !(tagElement instanceof CfmlTag); tagElement = tagElement.getParent()) {
        }
        if (tagElement == null) {
            return false;
        }
        boolean doInsertion = false;
        if (tagElement.getLastChild() instanceof PsiErrorElement) {
            doInsertion = true;
        } else {
            iterator = ((EditorEx)editor).getHighlighter().createIterator(0);
            while (!iterator.atEnd() && iterator.getStart() < offset) {
                String currentTagName;
                if (iterator.getTokenType() == CfmlTokenTypes.CF_TAG_NAME && tagName.equals(currentTagName = document.getCharsSequence().subSequence(iterator.getStart(), iterator.getEnd()).toString())) {
                    PsiElement currentTagElement = file.findElementAt(iterator.getStart());
                    if ((currentTagElement = PsiTreeUtil.getParentOfType((PsiElement)currentTagElement, CfmlTag.class)).getLastChild() instanceof PsiErrorElement) {
                        doInsertion = true;
                        break;
                    }
                }
                iterator.advance();
            }
        }
        String tagNameFromPsi = ((CfmlTag)tagElement).getTagName();
        if (doInsertion && CfmlUtil.isEndTagRequired(tagNameFromPsi, project)) {
            if (!Comparing.equal((String)tagNameFromPsi, (String)tagName, (boolean)false)) {
                tagName = tagNameFromPsi;
            }
            EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)("</" + tagName + ">"), (boolean)true, (int)0);
            return true;
        }
        return false;
    }

    @NotNull
    public TypedHandlerDelegate.Result charTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            CfmlTypedHandler.$$$reportNull$$$0(15);
        }
        if (editor == null) {
            CfmlTypedHandler.$$$reportNull$$$0(16);
        }
        if (file == null) {
            CfmlTypedHandler.$$$reportNull$$$0(17);
        }
        if (CfmlTypedHandler.isNotCfmlFile(file, editor)) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
            if (result == null) {
                CfmlTypedHandler.$$$reportNull$$$0(18);
            }
            return result;
        }
        TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
        if (result == null) {
            CfmlTypedHandler.$$$reportNull$$$0(19);
        }
        return result;
    }

    static boolean isNotCfmlFile(PsiFile file, Editor editor) {
        return !(file instanceof CfmlFile) || editor.getCaretModel().getOffset() == 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 7: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/coldFusion/UI/editorActions/typedHandlers/CfmlTypedHandler";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/coldFusion/UI/editorActions/typedHandlers/CfmlTypedHandler";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "checkAutoPopup";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "beforeCharTyped";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "charTyped";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkAutoPopup";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 18: 
            case 19: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "beforeCharTyped";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "charTyped";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

