/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.model.formatter;

import com.intellij.coldFusion.model.CfmlLanguage;
import com.intellij.coldFusion.model.files.CfmlFileType;
import com.intellij.coldFusion.model.formatter.CfmlAlignmentProcessor;
import com.intellij.coldFusion.model.formatter.CfmlCodeStyleSettings;
import com.intellij.coldFusion.model.formatter.CfmlFormatterUtil;
import com.intellij.coldFusion.model.formatter.CfmlIndentProcessor;
import com.intellij.coldFusion.model.formatter.CfmlSpacingProcessor;
import com.intellij.coldFusion.model.formatter.CfmlWrappingProcessor;
import com.intellij.coldFusion.model.lexer.CfmlTokenTypes;
import com.intellij.coldFusion.model.lexer.CfscriptTokenTypes;
import com.intellij.coldFusion.model.parsers.CfmlElementTypes;
import com.intellij.coldFusion.model.psi.stubs.CfmlStubElementTypes;
import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.templateLanguages.BlockWithParent;
import com.intellij.formatting.templateLanguages.DataLanguageBlockWrapper;
import com.intellij.formatting.templateLanguages.TemplateLanguageBlock;
import com.intellij.formatting.templateLanguages.TemplateLanguageBlockFactory;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ArrayUtil;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CfmlBlock
extends TemplateLanguageBlock {
    private Indent myIndent;
    private Wrap myChildWrap;
    private CommonCodeStyleSettings mySettings;
    private CodeStyleSettings superSettings;
    private CfmlIndentProcessor myIndentProcessor;
    private CfmlWrappingProcessor myWrappingProcessor;
    private CfmlSpacingProcessor mySpacingProcessor;
    private CfmlAlignmentProcessor myAlignmentProcessor;
    private final TextRange myTextRange;
    private static final IElementType[] WHITESPACE = new IElementType[]{XmlTokenType.XML_WHITE_SPACE, CfmlTokenTypes.WHITE_SPACE};

    public CfmlBlock(ASTNode node, Wrap wrap, Alignment alignment, CodeStyleSettings settings, @NotNull TemplateLanguageBlockFactory blockFactory, @Nullable List<DataLanguageBlockWrapper> foreignChildren) {
        if (blockFactory == null) {
            CfmlBlock.$$$reportNull$$$0(0);
        }
        super(node, wrap, alignment, blockFactory, settings, foreignChildren);
        this.superSettings = settings;
        this.mySettings = this.getSettings().getCommonSettings((Language)CfmlLanguage.INSTANCE);
        CfmlCodeStyleSettings cfmlSettings = (CfmlCodeStyleSettings)this.getSettings().getCustomSettings(CfmlCodeStyleSettings.class);
        this.myIndentProcessor = new CfmlIndentProcessor(this.mySettings, settings.getIndentSize((FileType)CfmlFileType.INSTANCE));
        this.myWrappingProcessor = new CfmlWrappingProcessor(node, this.mySettings);
        this.mySpacingProcessor = new CfmlSpacingProcessor(node, this.mySettings, cfmlSettings);
        this.myAlignmentProcessor = new CfmlAlignmentProcessor(node, this.mySettings);
        this.myIndent = this.getChildIndent();
        this.myTextRange = this.trimRangeToNonWhiteSpaceIfNeeded();
    }

    protected IElementType getTemplateTextElementType() {
        return null;
    }

    @Nullable
    protected Indent getChildIndent() {
        return this.myIndentProcessor.getChildIndent(this.myNode);
    }

    protected List<Block> buildChildren() {
        return super.buildChildren();
    }

    private TextRange trimRangeToNonWhiteSpaceIfNeeded() {
        TextRange defaultRange = this.myNode.getTextRange();
        if (this.myNode.getElementType() != CfmlElementTypes.TEMPLATE_TEXT) {
            return defaultRange;
        }
        PsiFile htmlFile = this.myNode.getPsi().getContainingFile().getViewProvider().getPsi((Language)HTMLLanguage.INSTANCE);
        if (htmlFile == null) {
            return defaultRange;
        }
        TextRange nonWhitespace = null;
        PsiElement commonHtmlParent = CfmlBlock.findCommonHtmlParent(htmlFile.getViewProvider().findElementAt(defaultRange.getStartOffset(), (Language)HTMLLanguage.INSTANCE), htmlFile.getViewProvider().findElementAt(defaultRange.getEndOffset() - 1, (Language)HTMLLanguage.INSTANCE));
        if (commonHtmlParent == null) {
            return defaultRange;
        }
        LinkedList<PsiElement> elements = new LinkedList<PsiElement>(Arrays.asList(commonHtmlParent.getChildren()));
        while (!elements.isEmpty()) {
            PsiElement e = elements.remove();
            if (ArrayUtil.contains((Object)e.getNode().getElementType(), (Object[])WHITESPACE)) continue;
            if (defaultRange.contains(e.getTextRange())) {
                nonWhitespace = nonWhitespace == null ? e.getTextRange() : nonWhitespace.union(e.getTextRange());
                continue;
            }
            if (!defaultRange.intersects(e.getTextRange())) continue;
            elements.addAll(Arrays.asList(e.getChildren()));
        }
        if (nonWhitespace != null) {
            assert (defaultRange.intersects(nonWhitespace));
            return defaultRange.intersection(nonWhitespace);
        }
        return defaultRange;
    }

    @Nullable
    private static PsiElement findCommonHtmlParent(@Nullable PsiElement start, @Nullable PsiElement end) {
        PsiElement parent;
        if (start == null || end == null || start == end) {
            return start;
        }
        TextRange endRange = end.getTextRange();
        for (parent = start.getParent(); parent != null && !parent.getTextRange().contains(endRange); parent = parent.getParent()) {
        }
        return parent;
    }

    @NotNull
    public TextRange getTextRange() {
        TextRange textRange = this.myTextRange;
        if (textRange == null) {
            CfmlBlock.$$$reportNull$$$0(1);
        }
        return textRange;
    }

    public Indent getIndent() {
        return this.myIndent;
    }

    public Wrap getChildWrap() {
        return this.myChildWrap;
    }

    public Spacing getSpacing(Block child1, @NotNull Block child2) {
        if (child2 == null) {
            CfmlBlock.$$$reportNull$$$0(2);
        }
        return this.mySpacingProcessor.getSpacing(child1, child2);
    }

    public Wrap createChildWrap(ASTNode child) {
        Wrap defaultWrap = super.createChildWrap(child);
        IElementType childType = child.getElementType();
        BlockWithParent parent = this.getParent();
        Wrap childWrap = parent instanceof CfmlBlock ? ((CfmlBlock)parent).getChildWrap() : null;
        Wrap wrap = this.myWrappingProcessor.createChildWrap(child, defaultWrap, childWrap);
        if (CfmlFormatterUtil.isAssignmentOperator(childType)) {
            this.myChildWrap = wrap;
        }
        return wrap;
    }

    @Nullable
    protected Alignment createChildAlignment(ASTNode child) {
        if (child.getElementType() != CfscriptTokenTypes.FOR_KEYWORD && child.getElementType() != CfscriptTokenTypes.L_BRACKET && child.getElementType() != CfmlElementTypes.BLOCK_OF_STATEMENTS) {
            return this.myAlignmentProcessor.createChildAlignment();
        }
        return null;
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        ASTBlock prevBlock;
        List childBlockList = this.getSubBlocks();
        if (newChildIndex > 0 && newChildIndex - 1 < childBlockList.size() && (prevBlock = (ASTBlock)childBlockList.get(newChildIndex - 1)) != null) {
            Object indent;
            Alignment alignment = this.myAlignmentProcessor.createChildAlignment();
            ASTNode prevNode = prevBlock.getNode();
            if (prevNode != null) {
                PsiElement prevTreePsiElement = prevNode.getTreePrev() != null ? prevNode.getTreePrev().getPsi() : null;
                IElementType prevBlockType = prevNode.getElementType();
                indent = prevBlockType == CfscriptTokenTypes.L_CURLYBRACKET ? (this.myNode.getElementType() == CfmlElementTypes.FUNCTION_DEFINITION && this.mySettings.METHOD_BRACE_STYLE == 4 || this.mySettings.BRACE_STYLE == 4 ? Indent.getSpaceIndent((int)(this.superSettings.getIndentSize((FileType)CfmlFileType.INSTANCE) * 2)) : Indent.getNormalIndent()) : (this.myNode.getElementType() == CfmlStubElementTypes.CFML_FILE ? Indent.getNoneIndent() : (prevBlockType == CfmlTokenTypes.R_ANGLEBRACKET && prevTreePsiElement != null && !prevTreePsiElement.getText().equalsIgnoreCase("cfscript") ? Indent.getNormalIndent() : (prevBlockType == CfmlTokenTypes.CLOSER && prevTreePsiElement != null && !prevTreePsiElement.getText().equalsIgnoreCase("cfscript") ? null : (prevBlockType == CfmlElementTypes.TAG || prevBlockType == CfmlElementTypes.ARGUMENT_TAG || prevBlockType == CfmlElementTypes.COMPONENT_TAG || prevBlockType == CfmlElementTypes.FUNCTION_TAG || prevBlockType == CfmlElementTypes.SCRIPT_TAG ? Indent.getNormalIndent() : (prevBlockType == CfmlTokenTypes.COMMENT || prevBlockType == CfmlElementTypes.TEMPLATE_TEXT ? prevBlock.getIndent() : Indent.getNormalIndent())))));
            } else {
                indent = ((DataLanguageBlockWrapper)prevBlock).getOriginal().getIndent();
            }
            ChildAttributes childAttributes = new ChildAttributes(indent, alignment);
            if (childAttributes == null) {
                CfmlBlock.$$$reportNull$$$0(3);
            }
            return childAttributes;
        }
        ChildAttributes childAttributes = super.getChildAttributes(newChildIndex);
        if (childAttributes == null) {
            CfmlBlock.$$$reportNull$$$0(4);
        }
        return childAttributes;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockFactory";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/coldFusion/model/formatter/CfmlBlock";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/coldFusion/model/formatter/CfmlBlock";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextRange";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSpacing";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

