/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.model.psi;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.coldFusion.UI.CfmlLookUpItemUtil;
import com.intellij.coldFusion.model.CfmlUtil;
import com.intellij.coldFusion.model.files.CfmlFile;
import com.intellij.coldFusion.model.lexer.CfmlTokenTypes;
import com.intellij.coldFusion.model.lexer.CfscriptTokenTypes;
import com.intellij.coldFusion.model.psi.CfmlAssignmentExpression;
import com.intellij.coldFusion.model.psi.CfmlComponent;
import com.intellij.coldFusion.model.psi.CfmlComponentType;
import com.intellij.coldFusion.model.psi.CfmlExpression;
import com.intellij.coldFusion.model.psi.CfmlFunction;
import com.intellij.coldFusion.model.psi.CfmlFunctionCallExpression;
import com.intellij.coldFusion.model.psi.CfmlProperty;
import com.intellij.coldFusion.model.psi.CfmlPsiUtil;
import com.intellij.coldFusion.model.psi.CfmlReference;
import com.intellij.coldFusion.model.psi.CfmlSuperComponentReference;
import com.intellij.coldFusion.model.psi.CfmlTypedElement;
import com.intellij.coldFusion.model.psi.CfmlVariable;
import com.intellij.coldFusion.model.psi.CfmlVariantsProcessor;
import com.intellij.diagnostic.LogMessageEx;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.AbstractQualifiedReference;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.scope.JavaScopeProcessorEvent;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CfmlReferenceExpression
extends AbstractQualifiedReference<CfmlReferenceExpression>
implements CfmlReference,
CfmlExpression,
CfmlTypedElement {
    private static final Logger LOG = Logger.getInstance((String)CfmlReferenceExpression.class.getName());

    public CfmlReferenceExpression(@NotNull ASTNode node) {
        if (node == null) {
            CfmlReferenceExpression.$$$reportNull$$$0(0);
        }
        super(node);
    }

    protected boolean processUnqualifiedVariants(PsiScopeProcessor processor) {
        PsiFile containingFile = this.getContainingFile();
        if (containingFile instanceof CfmlFile) {
            CfmlFunction[] file;
            CfmlComponent componentDefinition = ((CfmlFile)containingFile).getComponentDefinition();
            CfmlFunction[] functions = componentDefinition != null ? componentDefinition.getFunctionsWithSupers(this.getFirstChild() instanceof CfmlSuperComponentReference) : ((file = this.getContainingFile()) instanceof CfmlFile ? ((CfmlFile)file).getGlobalFunctions().toArray(CfmlFunction.EMPTY_ARRAY) : CfmlFunction.EMPTY_ARRAY);
            for (CfmlFunction function : functions) {
                if (processor.execute((PsiElement)function, ResolveState.initial())) continue;
                return false;
            }
            if (componentDefinition != null) {
                CfmlProperty[] propertiesWithSupers;
                for (CfmlProperty property : propertiesWithSupers = componentDefinition.getPropertiesWithSupers(this.getFirstChild() instanceof CfmlSuperComponentReference)) {
                    if (processor.execute((PsiElement)property, ResolveState.initial())) continue;
                    return false;
                }
            }
        }
        return super.processUnqualifiedVariants(processor);
    }

    protected boolean processVariantsInner(PsiScopeProcessor processor) {
        CfmlTypedElement typedOwner = CfmlPsiUtil.getTypedQualifierInner(this);
        PsiType type = null;
        if (typedOwner == null) {
            return this.processUnqualifiedVariants(processor);
        }
        type = typedOwner.getPsiType();
        if (type instanceof PsiClassType) {
            PsiClass psiClass;
            if (type instanceof CfmlFunctionCallExpression.PsiClassStaticType) {
                psiClass = PsiUtil.resolveClassInType((PsiType)((CfmlFunctionCallExpression.PsiClassStaticType)type).getRawType());
                processor.handleEvent((PsiScopeProcessor.Event)JavaScopeProcessorEvent.START_STATIC, null);
            } else {
                psiClass = PsiUtil.resolveClassInType((PsiType)type);
            }
            processor.handleEvent((PsiScopeProcessor.Event)CfmlVariantsProcessor.CfmlProcessorEvent.SET_INITIAL_CLASS, (Object)psiClass);
            if (psiClass != null && !psiClass.processDeclarations(processor, ResolveState.initial(), null, (PsiElement)this)) {
                return false;
            }
        } else if (type instanceof CfmlComponentType) {
            Collection<CfmlComponent> components = ((CfmlComponentType)type).resolve();
            for (CfmlComponent component : components) {
                if (component.processDeclarations(processor, ResolveState.initial(), null, this)) continue;
                return false;
            }
        }
        if (typedOwner instanceof CfmlFunctionCallExpression) {
            typedOwner = ((CfmlFunctionCallExpression)typedOwner).getReferenceExpression();
        }
        if (typedOwner instanceof CfmlReference) {
            PsiElement psiElement = ((CfmlReference)typedOwner).resolve();
            return psiElement == null || psiElement.processDeclarations(processor, ResolveState.initial(), null, (PsiElement)this);
        }
        return true;
    }

    public boolean isReferenceTo(PsiElement element) {
        if (element instanceof CfmlProperty && element.getContainingFile() == this.getContainingFile()) {
            String name = ((CfmlProperty)element).getName();
            String referenceText = this.getText();
            return (referenceText.toLowerCase().startsWith("get") || referenceText.toLowerCase().startsWith("set")) && referenceText.substring(3).equalsIgnoreCase(name);
        }
        PsiManagerEx manager = this.getManager();
        for (ResolveResult result : this.multiResolve(false)) {
            PsiElement target = result.getElement();
            if (!manager.areElementsEquivalent(element, target)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    protected ResolveResult[] resolveInner() {
        ResolveResult result;
        PsiElement element;
        CfmlAssignmentExpression assignment;
        CfmlVariable var;
        String referenceName = this.getReferenceName();
        if (referenceName == null) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                CfmlReferenceExpression.$$$reportNull$$$0(1);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        CfmlVariantsProcessor<ResolveResult> processor = new CfmlVariantsProcessor<ResolveResult>((PsiElement)this, this.getParent(), referenceName){

            @Override
            protected ResolveResult execute(PsiNamedElement element, boolean error) {
                return new PsiElementResolveResult((PsiElement)element, false);
            }
        };
        boolean ifContinue = true;
        PsiElement parent = this.getParent();
        if (parent instanceof CfmlAssignmentExpression && (var = (assignment = (CfmlAssignmentExpression)parent).getAssignedVariable()) != null && assignment.getAssignedVariableElement() == this) {
            ifContinue = processor.execute((PsiElement)var, ResolveState.initial());
        }
        if (ifContinue) {
            this.processVariantsInner(processor);
        }
        ResolveResult[] variantsResults = processor.getVariants(ResolveResult.EMPTY_ARRAY);
        ArrayList<ResolveResult> results = new ArrayList<ResolveResult>();
        for (ResolveResult variantsResult : variantsResults) {
            PsiElement parentRef;
            if (variantsResult.getElement() == null || (parentRef = variantsResult.getElement().getParent()) instanceof CfmlReferenceExpression && (!(variantsResult.getElement() instanceof CfmlAssignmentExpression.AssignedVariable) || !CfmlUtil.hasEqualScope(this, (CfmlReferenceExpression)parentRef))) continue;
            results.add(variantsResult);
        }
        if (results.isEmpty()) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                CfmlReferenceExpression.$$$reportNull$$$0(2);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        if (results.size() > 1 && (element = (result = (ResolveResult)results.get(results.size() - 1)).getElement()) instanceof CfmlVariable && ((CfmlVariable)element).isTrulyDeclaration()) {
            ResolveResult[] resolveResultArray = new ResolveResult[]{result};
            if (resolveResultArray == null) {
                CfmlReferenceExpression.$$$reportNull$$$0(3);
            }
            return resolveResultArray;
        }
        ResolveResult[] resolveResultArray = new ResolveResult[]{(ResolveResult)results.get(0)};
        if (resolveResultArray == null) {
            CfmlReferenceExpression.$$$reportNull$$$0(4);
        }
        return resolveResultArray;
    }

    @NotNull
    protected CfmlReferenceExpression parseReference(String newText) {
        CfmlReferenceExpression cfmlReferenceExpression = CfmlPsiUtil.createReferenceExpression(newText, this.getProject());
        if (cfmlReferenceExpression == null) {
            CfmlReferenceExpression.$$$reportNull$$$0(5);
        }
        return cfmlReferenceExpression;
    }

    protected PsiElement getSeparator() {
        return this.findChildByType(CfscriptTokenTypes.POINT);
    }

    public TextRange getRangeInElement() {
        if (this.getScope() != null) {
            return new TextRange(0, this.getTextLength());
        }
        return super.getRangeInElement();
    }

    private static boolean checkType(@Nullable PsiElement element, IElementType type) {
        if (element == null) {
            return false;
        }
        ASTNode node = element.getNode();
        return node != null && node.getElementType().equals(type);
    }

    @Nullable
    public PsiElement getScope() {
        PsiElement prevSubling;
        PsiElement identifier = this.findChildByType(CfscriptTokenTypes.IDENTIFIER);
        if (identifier != null && (prevSubling = identifier.getPrevSibling()) != null && CfmlReferenceExpression.checkType(prevSubling, CfscriptTokenTypes.POINT) && CfmlReferenceExpression.checkType(prevSubling.getPrevSibling(), CfscriptTokenTypes.SCOPE_KEYWORD)) {
            return prevSubling.getPrevSibling();
        }
        return null;
    }

    protected PsiElement getReferenceNameElement() {
        PsiElement identifier = this.findChildByType(CfscriptTokenTypes.IDENTIFIER);
        if (identifier == null) {
            return this.findChildByType(CfmlTokenTypes.STRING_TEXT);
        }
        return identifier;
    }

    @NotNull
    public Object[] getVariants() {
        CfmlVariantsProcessor<PsiNamedElement> processor = new CfmlVariantsProcessor<PsiNamedElement>((PsiElement)this, this.getParent(), null){
            Set<String> myVariablesNames;
            {
                this.myVariablesNames = new HashSet();
            }

            @Override
            protected PsiNamedElement execute(PsiNamedElement element, boolean error) {
                if (element instanceof CfmlVariable) {
                    if (this.myVariablesNames.add(element.getName())) {
                        return element;
                    }
                    return null;
                }
                PsiElement scope = CfmlReferenceExpression.this.getScope();
                if (scope != null && !scope.getText().equalsIgnoreCase("this")) {
                    return null;
                }
                return element;
            }
        };
        this.processVariantsInner(processor);
        Object[] variants = processor.getVariants(PsiNamedElement.EMPTY_ARRAY);
        HashSet result = new HashSet();
        for (PsiNamedElement psiNamedElement : variants) {
            if (!(psiNamedElement instanceof CfmlProperty)) continue;
            String capitalizedName = StringUtil.capitalize((String)StringUtil.notNullize((String)psiNamedElement.getName()));
            if (((CfmlProperty)psiNamedElement).hasGetter() || psiNamedElement.getParent() instanceof CfmlComponent && (((CfmlComponent)psiNamedElement.getParent()).hasImplicitAccessors() || ((CfmlComponent)psiNamedElement.getParent()).isPersistent())) {
                result.add((Object)LookupElementBuilder.create((Object)psiNamedElement, (String)("get" + capitalizedName + "()")).withCaseSensitivity(false).withIcon(PlatformIcons.METHOD_ICON));
            }
            if (!((CfmlProperty)psiNamedElement).hasSetter() && (!(psiNamedElement.getParent() instanceof CfmlComponent) || !((CfmlComponent)psiNamedElement.getParent()).hasImplicitAccessors() && !((CfmlComponent)psiNamedElement.getParent()).isPersistent())) continue;
            result.add((Object)LookupElementBuilder.create((Object)psiNamedElement, (String)("set" + capitalizedName + "()")).withCaseSensitivity(false).withIcon(PlatformIcons.METHOD_ICON));
        }
        result.addAll((Collection)ContainerUtil.map2Set((Object[])variants, element -> {
            PsiElement scope = this.getScope();
            return CfmlLookUpItemUtil.namedElementToLookupItem(element, scope != null ? scope.getText() : null);
        }));
        Object[] objectArray = result.toArray();
        if (objectArray == null) {
            CfmlReferenceExpression.$$$reportNull$$$0(6);
        }
        return objectArray;
    }

    @Override
    public PsiType getPsiType() {
        PsiType type;
        if (this.getParent() instanceof CfmlFunctionCallExpression && (type = ((CfmlFunctionCallExpression)this.getParent()).getExternalType()) != null) {
            return type;
        }
        PsiElement element = this.resolve();
        if (element instanceof CfmlVariable) {
            CfmlExpression rightExpr;
            if (element instanceof CfmlAssignmentExpression.AssignedVariable && ((rightExpr = ((CfmlAssignmentExpression.AssignedVariable)element).getRightHandExpr()) == this || rightExpr instanceof CfmlFunctionCallExpression && ((CfmlFunctionCallExpression)rightExpr).getExternalType() == null && ((CfmlFunctionCallExpression)rightExpr).getReferenceExpression() == this)) {
                LOG.error((Object)LogMessageEx.createEvent((String)"CFML parsing problem", (String)("Please report the problem to JetBrains with the file attached\nProblem at" + (rightExpr != null ? rightExpr.getText() : null) + "\n" + DebugUtil.currentStackTrace()), (String)"CFML parsing problem", (String)"CFML parsing problem", (Attachment)new Attachment("problem.cfml", element.getContainingFile().getText())));
                return null;
            }
            return ((CfmlVariable)element).getPsiType();
        }
        if (element instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)element;
            return method.getReturnType();
        }
        if (element instanceof CfmlFunction) {
            return ((CfmlFunction)element).getReturnType();
        }
        return null;
    }

    public String getReferenceName() {
        PsiElement identifier = this.getReferenceNameElement();
        return identifier != null ? identifier.getText() : "";
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        CheckUtil.checkWritable((PsiElement)this);
        PsiElement referenceNameElement = this.getReferenceNameElement();
        if (referenceNameElement != null) {
            ASTNode referenceNode = referenceNameElement.getNode();
            if (referenceNode == null) {
                return this;
            }
            PsiElement newElement = referenceNode.getElementType() == CfmlTokenTypes.STRING_TEXT ? CfmlPsiUtil.createConstantString(newElementName, this.getProject()) : CfmlPsiUtil.createIdentifier(newElementName, this.getProject());
            this.getNode().replaceChild(referenceNode, newElement.getNode());
        }
        return this;
    }

    public String toString() {
        return this.getNode().getElementType().toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/coldFusion/model/psi/CfmlReferenceExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/coldFusion/model/psi/CfmlReferenceExpression";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveInner";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "parseReference";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

