/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.sdk.impl;

import com.intellij.gwt.sdk.GwtSdk;
import com.intellij.gwt.sdk.GwtSdkManager;
import com.intellij.gwt.sdk.GwtSdkType;
import com.intellij.gwt.sdk.impl.GwtSdkImpl;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.util.xmlb.annotations.XCollection;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="GwtSdkManager", storages={@Storage(value="applicationLibraries.xml", roamingType=RoamingType.PER_OS), @Storage(value="other.xml", deprecated=true)})
public class GwtSdkManagerImpl
extends GwtSdkManager
implements PersistentStateComponent<GwtSdkList> {
    private final Map<String, GwtSdk> myGwtSdkMap = new HashMap<String, GwtSdk>();
    private GwtSdkList myGwtSdkList = new GwtSdkList();

    @Override
    @NotNull
    public GwtSdk getGwtSdk(@NotNull String sdkHomeUrl, @Nullable String sdkTypeId) {
        String key;
        GwtSdk gwtSdk;
        if (sdkHomeUrl == null) {
            GwtSdkManagerImpl.$$$reportNull$$$0(0);
        }
        if ((gwtSdk = this.myGwtSdkMap.get(key = sdkTypeId + ":" + sdkHomeUrl)) == null) {
            gwtSdk = GwtSdkManagerImpl.createGwtSdk(sdkHomeUrl, sdkTypeId);
            this.myGwtSdkMap.put(key, gwtSdk);
        }
        GwtSdk gwtSdk2 = gwtSdk;
        if (gwtSdk2 == null) {
            GwtSdkManagerImpl.$$$reportNull$$$0(1);
        }
        return gwtSdk2;
    }

    @Override
    @NotNull
    public GwtSdk getGwtSdk(@NotNull String sdkHomeUrl) {
        GwtSdkType sdkType;
        if (sdkHomeUrl == null) {
            GwtSdkManagerImpl.$$$reportNull$$$0(2);
        }
        GwtSdk gwtSdk = this.getGwtSdk(sdkHomeUrl, (sdkType = this.detectSdkType(sdkHomeUrl)) != null ? sdkType.getId() : null);
        if (gwtSdk == null) {
            GwtSdkManagerImpl.$$$reportNull$$$0(3);
        }
        return gwtSdk;
    }

    private static GwtSdk createGwtSdk(@NotNull String sdkHomeUrl, @Nullable String sdkTypeId) {
        GwtSdkType type;
        if (sdkHomeUrl == null) {
            GwtSdkManagerImpl.$$$reportNull$$$0(4);
        }
        if ((type = GwtSdkType.findType(sdkTypeId)) != null) {
            return type.createSdk(sdkHomeUrl);
        }
        return new GwtSdkImpl(sdkHomeUrl);
    }

    @Override
    public void registerGwtSdk(@NotNull GwtSdk gwtSdk) {
        if (gwtSdk == null) {
            GwtSdkManagerImpl.$$$reportNull$$$0(5);
        }
        String url = gwtSdk.getHomeDirectoryUrl();
        if (gwtSdk.isValid() && !this.myGwtSdkList.getSdkInstallations().contains(url)) {
            this.myGwtSdkList.getSdkInstallations().add(0, StringUtil.trimEnd((String)url, (String)"/"));
        }
    }

    @Override
    public void moveToTop(@NotNull GwtSdk sdk) {
        if (sdk == null) {
            GwtSdkManagerImpl.$$$reportNull$$$0(6);
        }
        if (sdk.isValid()) {
            String url = sdk.getHomeDirectoryUrl();
            List<String> list = this.myGwtSdkList.getSdkInstallations();
            list.remove(url);
            String trimmedUrl = StringUtil.trimEnd((String)url, (String)"/");
            list.remove(trimmedUrl);
            list.add(trimmedUrl);
        }
    }

    @Override
    @Nullable
    public GwtSdk suggestGwtSdk() {
        GwtSdk last = null;
        for (String url : this.myGwtSdkList.getSdkInstallations()) {
            GwtSdk sdk = this.getGwtSdk(url, null);
            if (!sdk.isValid()) continue;
            last = sdk;
        }
        return last;
    }

    @Override
    public List<String> getAllSdkPaths() {
        ArrayList<String> paths = new ArrayList<String>();
        for (String url : this.myGwtSdkList.getSdkInstallations()) {
            paths.add(0, VfsUtil.urlToPath((String)url));
        }
        return paths;
    }

    @Override
    public void removeInvalidSdk() {
        Iterator<String> iterator = this.myGwtSdkList.getSdkInstallations().iterator();
        while (iterator.hasNext()) {
            String url = iterator.next();
            GwtSdk gwtSdk = this.getGwtSdk(url);
            if (gwtSdk.isValid()) continue;
            iterator.remove();
        }
    }

    public GwtSdkList getState() {
        return this.myGwtSdkList;
    }

    public void loadState(GwtSdkList state) {
        this.myGwtSdkList = state;
    }

    @Override
    @Nullable
    public GwtSdkType detectSdkType(String homeDirectoryUrl) {
        for (GwtSdkType sdkType : (GwtSdkType[])GwtSdkType.EP_NAME.getExtensions()) {
            if (!sdkType.isValidSdkHomeDirectory(new File(VfsUtilCore.urlToPath((String)homeDirectoryUrl)))) continue;
            return sdkType;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkHomeUrl";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/gwt/sdk/impl/GwtSdkManagerImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gwtSdk";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/gwt/sdk/impl/GwtSdkManagerImpl";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getGwtSdk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getGwtSdk";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createGwtSdk";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "registerGwtSdk";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "moveToTop";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class GwtSdkList {
        private List<String> mySdkInstallations = new ArrayList<String>();

        @XCollection(elementName="gwt-sdk", valueAttributeName="url", propertyElementName="gwt-sdk-list")
        public List<String> getSdkInstallations() {
            return this.mySdkInstallations;
        }

        public void setSdkInstallations(List<String> sdkInstallations) {
            this.mySdkInstallations = sdkInstallations;
        }
    }
}

