/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.uiBinder.references;

import com.intellij.gwt.uiBinder.references.GwtTagPackageReferenceSet;
import com.intellij.gwt.uiBinder.references.UiXmlTagNameRefactoringUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PackageReferenceSet;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiPackageReference;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

class GwtTagPackageReference
extends PsiPackageReference {
    private final TextRange myRangeInName;

    public GwtTagPackageReference(GwtTagPackageReferenceSet referenceSet, TextRange range, int index) {
        super((PackageReferenceSet)referenceSet, range, index);
        this.myRangeInName = TextRange.create((int)(range.getStartOffset() - 1), (int)(range.getEndOffset() - 1));
    }

    public PsiElement handleElementRename(String newElementName) {
        XmlTag xmlTag = this.getElement();
        return xmlTag.setName(this.myRangeInName.replace(xmlTag.getName(), newElementName));
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            GwtTagPackageReference.$$$reportNull$$$0(0);
        }
        if (!(element instanceof PsiPackage)) {
            throw new IncorrectOperationException("Cannot bind to " + element);
        }
        XmlTag xmlTag = this.getElement();
        String xmlTagName = xmlTag.getName();
        String entityName = xmlTagName.substring(this.myRangeInName.getStartOffset());
        PsiPackage psiPackage = (PsiPackage)element;
        String newQualifiedClassName = psiPackage.getQualifiedName() + xmlTagName.substring(this.myRangeInName.getEndOffset());
        String newPackage = StringUtil.trimEnd((String)newQualifiedClassName, (String)("." + entityName));
        return xmlTag.setName(UiXmlTagNameRefactoringUtil.handleMove(xmlTag, newPackage, entityName));
    }

    public XmlTag getElement() {
        return (XmlTag)super.getElement();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/gwt/uiBinder/references/GwtTagPackageReference", "bindToElement"));
    }
}

