/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.references;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.impl.source.tree.injected.InjectedReferenceVisitor;
import com.intellij.psi.injection.ReferenceInjector;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.inject.InjectedLanguage;
import org.intellij.plugins.intelliLang.inject.InjectorUtils;
import org.intellij.plugins.intelliLang.inject.LanguageInjectionSupport;
import org.intellij.plugins.intelliLang.inject.TemporaryPlacesRegistry;
import org.intellij.plugins.intelliLang.inject.config.BaseInjection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InjectedReferencesContributor
extends PsiReferenceContributor {
    private static final Key<PsiReference[]> INJECTED_REFERENCES = Key.create((String)"injected references");

    public static boolean isInjected(@Nullable PsiReference reference) {
        return reference != null && reference.getElement().getUserData(INJECTED_REFERENCES) != null;
    }

    @Nullable
    public static PsiReference[] getInjectedReferences(PsiElement element) {
        element.getReferences();
        return (PsiReference[])element.getUserData(INJECTED_REFERENCES);
    }

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            InjectedReferencesContributor.$$$reportNull$$$0(0);
        }
        registrar.registerReferenceProvider((ElementPattern)PlatformPatterns.psiElement(), new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(final @NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    1.$$$reportNull$$$0(1);
                }
                ReferenceInjector[] extensions = (ReferenceInjector[])ReferenceInjector.EXTENSION_POINT_NAME.getExtensions();
                SmartList references = new SmartList();
                Project project = element.getProject();
                Configuration configuration = Configuration.getProjectInstance(project);
                final Ref injected = new Ref((Object)Boolean.FALSE);
                for (ReferenceInjector injector : extensions) {
                    Collection<BaseInjection> injections = configuration.getInjectionsByLanguageId(injector.getId());
                    for (BaseInjection injection : injections) {
                        if (!injection.acceptForReference(element)) continue;
                        injected.set((Object)Boolean.TRUE);
                        LanguageInjectionSupport support = InjectorUtils.findInjectionSupport(injection.getSupportId());
                        element.putUserData(LanguageInjectionSupport.INJECTOR_SUPPORT, (Object)support);
                        List<TextRange> area = injection.getInjectedArea(element);
                        for (TextRange range : area) {
                            references.addAll(Arrays.asList(injector.getReferences(element, context, range)));
                        }
                    }
                }
                if (element instanceof PsiLanguageInjectionHost) {
                    final TemporaryPlacesRegistry registry = TemporaryPlacesRegistry.getInstance(project);
                    InjectedLanguage language = registry.getLanguageFor((PsiLanguageInjectionHost)element, element.getContainingFile());
                    if (language != null) {
                        ReferenceInjector injector = ReferenceInjector.findById((String)language.getID());
                        if (injector != null) {
                            injected.set((Object)Boolean.TRUE);
                            element.putUserData(LanguageInjectionSupport.INJECTOR_SUPPORT, (Object)registry.getLanguageInjectionSupport());
                            TextRange range = ElementManipulators.getValueTextRange((PsiElement)element);
                            references.addAll(Arrays.asList(injector.getReferences(element, context, range)));
                        }
                    } else {
                        PsiFile containingFile = element.getContainingFile();
                        InjectedLanguageManager.getInstance((Project)containingFile.getProject()).enumerateEx(element, containingFile, false, (PsiLanguageInjectionHost.InjectedPsiVisitor)new InjectedReferenceVisitor((List)references, context){
                            final /* synthetic */ List val$references;
                            final /* synthetic */ ProcessingContext val$context;
                            {
                                this.val$references = list;
                                this.val$context = processingContext;
                            }

                            public void visitInjectedReference(@NotNull ReferenceInjector injector, @NotNull List<PsiLanguageInjectionHost.Shred> places) {
                                if (injector == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                if (places == null) {
                                    1.$$$reportNull$$$0(1);
                                }
                                injected.set((Object)Boolean.TRUE);
                                element.putUserData(LanguageInjectionSupport.INJECTOR_SUPPORT, (Object)registry.getLanguageInjectionSupport());
                                for (PsiLanguageInjectionHost.Shred place : places) {
                                    if (place.getHost() != element) continue;
                                    this.val$references.addAll(Arrays.asList(injector.getReferences(element, this.val$context, place.getRangeInsideHost())));
                                }
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                Object[] objectArray;
                                Object[] objectArray2 = new Object[3];
                                switch (n) {
                                    default: {
                                        objectArray = objectArray2;
                                        objectArray2[0] = "injector";
                                        break;
                                    }
                                    case 1: {
                                        objectArray = objectArray2;
                                        objectArray2[0] = "places";
                                        break;
                                    }
                                }
                                objectArray[1] = "org/intellij/plugins/intelliLang/references/InjectedReferencesContributor$1$1";
                                objectArray[2] = "visitInjectedReference";
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                            }
                        });
                    }
                }
                PsiReference[] array = references.toArray(new PsiReference[references.size()]);
                element.putUserData(INJECTED_REFERENCES, (Boolean)injected.get() != false ? array : null);
                if (array == null) {
                    1.$$$reportNull$$$0(2);
                }
                return array;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/intellij/plugins/intelliLang/references/InjectedReferencesContributor$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/intellij/plugins/intelliLang/references/InjectedReferencesContributor$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReferencesByElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getReferencesByElement";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "org/intellij/plugins/intelliLang/references/InjectedReferencesContributor", "registerReferenceProviders"));
    }
}

