/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.bundlor.support;

import com.springsource.bundlor.ClassPath;
import com.springsource.bundlor.ClassPathEntry;
import com.springsource.bundlor.EntryScannerListener;
import com.springsource.bundlor.ManifestGenerator;
import com.springsource.bundlor.support.ArtifactAnalyzer;
import com.springsource.bundlor.support.ManifestContributor;
import com.springsource.bundlor.support.ManifestGeneratorContributors;
import com.springsource.bundlor.support.ManifestMerger;
import com.springsource.bundlor.support.ManifestModifier;
import com.springsource.bundlor.support.ManifestReader;
import com.springsource.bundlor.support.ManifestTemplateModifier;
import com.springsource.bundlor.support.PartialManifestModifier;
import com.springsource.bundlor.support.StandardManifestMerger;
import com.springsource.bundlor.support.TemplateHeaderReader;
import com.springsource.bundlor.support.partialmanifest.PartialManifest;
import com.springsource.bundlor.support.partialmanifest.ReadablePartialManifest;
import com.springsource.bundlor.util.BundleManifestUtils;
import com.springsource.bundlor.util.SimpleManifestContents;
import com.springsource.util.parser.manifest.ManifestContents;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class StandardManifestGenerator
implements ManifestGenerator {
    private final ManifestGeneratorContributors contributors;
    private final ManifestMerger manifestMerger;

    public StandardManifestGenerator(ManifestGeneratorContributors contributors) {
        this(contributors, new StandardManifestMerger(contributors.getPartialManifestResolver()));
    }

    StandardManifestGenerator(ManifestGeneratorContributors contributors, ManifestMerger manifestMerger) {
        this.contributors = contributors;
        this.manifestMerger = manifestMerger;
    }

    public ManifestContents generate(ManifestContents manifestTemplate, ClassPath ... classPaths) {
        ReadablePartialManifest partialManifest = this.contributors.getReadablePartialManifest();
        ManifestContents existingManifest = this.getExistingManifest(classPaths);
        for (ManifestReader manifestReader : this.contributors.getManifestReaders()) {
            manifestReader.readJarManifest(existingManifest);
            manifestReader.readManifestTemplate(manifestTemplate);
        }
        for (ManifestModifier manifestModifier : this.contributors.getManifestModifiers()) {
            manifestModifier.modify(existingManifest);
        }
        for (ManifestTemplateModifier manifestTemplateModifier : this.contributors.getManifestTemplateModifiers()) {
            manifestTemplateModifier.modify(manifestTemplate);
        }
        this.analyzeEntries(classPaths, partialManifest);
        for (PartialManifestModifier partialManifestModifier : this.contributors.getPartialManifestModifiers()) {
            partialManifestModifier.modify(partialManifest);
        }
        SimpleManifestContents contributedManifest = new SimpleManifestContents();
        for (ManifestContributor manifestContributor : this.contributors.getManifestContributors()) {
            manifestContributor.contribute(contributedManifest);
        }
        ArrayList<String> templateOnlyHeaderNames = new ArrayList<String>();
        for (TemplateHeaderReader templateHeaderReader : this.contributors.getTemplateHeaderReaders()) {
            templateOnlyHeaderNames.addAll(templateHeaderReader.getTemplateOnlyHeaderNames());
        }
        return this.manifestMerger.merge(existingManifest, manifestTemplate, contributedManifest, partialManifest, templateOnlyHeaderNames);
    }

    private ManifestContents getExistingManifest(ClassPath ... classPaths) {
        ClassPath[] classPathArray = classPaths;
        int n = classPaths.length;
        int n2 = 0;
        while (n2 < n) {
            ClassPath classPath = classPathArray[n2];
            ClassPathEntry classPathEntry = classPath.getEntry("META-INF/MANIFEST.MF");
            if (classPathEntry != null) {
                return BundleManifestUtils.getManifest(classPathEntry.getReader());
            }
            ++n2;
        }
        return new SimpleManifestContents();
    }

    private void analyzeEntries(ClassPath[] classPaths, PartialManifest partialManifest) {
        ClassPath[] classPathArray = classPaths;
        int n = classPaths.length;
        int n2 = 0;
        while (n2 < n) {
            ClassPath classPath = classPathArray[n2];
            try {
                for (ClassPathEntry classPathEntry : classPath) {
                    if (classPathEntry.isDirectory()) continue;
                    this.beginEntry(classPathEntry);
                    this.analyzeEntry(classPathEntry, partialManifest);
                    this.endEntry();
                }
            }
            finally {
                classPath.close();
            }
            ++n2;
        }
    }

    private void analyzeEntry(ClassPathEntry classPathEntry, PartialManifest partialManifest) {
        for (ArtifactAnalyzer artifactAnalyzer : this.contributors.getArtifactAnalyzers()) {
            if (!artifactAnalyzer.canAnalyse(classPathEntry.getName())) continue;
            InputStream inputStream = classPathEntry.getInputStream();
            try {
                try {
                    artifactAnalyzer.analyse(inputStream, classPathEntry.getName(), partialManifest);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (inputStream == null) continue;
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                    continue;
                }
            }
            catch (Throwable throwable) {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (inputStream == null) continue;
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void beginEntry(ClassPathEntry classPathEntry) {
        for (EntryScannerListener entryScannerListener : this.contributors.getEntryScannerListeners()) {
            entryScannerListener.onBeginEntry(classPathEntry.getName());
        }
    }

    private void endEntry() {
        for (EntryScannerListener entryScannerListener : this.contributors.getEntryScannerListeners()) {
            entryScannerListener.onEndEntry();
        }
    }
}

