/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.java;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.java.config.CucumberConfigUtil;
import org.jetbrains.plugins.cucumber.java.steps.reference.CucumberJavaAnnotationProvider;
import org.jetbrains.plugins.cucumber.psi.GherkinFeature;
import org.jetbrains.plugins.cucumber.psi.GherkinFile;
import org.jetbrains.plugins.cucumber.psi.GherkinScenario;
import org.jetbrains.plugins.cucumber.psi.GherkinScenarioOutline;
import org.jetbrains.plugins.cucumber.psi.GherkinStep;

public class CucumberJavaUtil {
    public static final String CUCUMBER_STEP_ANNOTATION_PREFIX_1_0 = "cucumber.annotation.";
    public static final String CUCUMBER_STEP_ANNOTATION_PREFIX_1_1 = "cucumber.api.java.";

    private static String getCucumberAnnotationSuffix(@NotNull String name) {
        if (name == null) {
            CucumberJavaUtil.$$$reportNull$$$0(0);
        }
        if (name.startsWith(CUCUMBER_STEP_ANNOTATION_PREFIX_1_0)) {
            return name.substring(CUCUMBER_STEP_ANNOTATION_PREFIX_1_0.length());
        }
        if (name.startsWith(CUCUMBER_STEP_ANNOTATION_PREFIX_1_1)) {
            return name.substring(CUCUMBER_STEP_ANNOTATION_PREFIX_1_1.length());
        }
        name = "";
        return name;
    }

    public static String getCucumberPendingExceptionFqn(@NotNull PsiElement context) {
        String version;
        if (context == null) {
            CucumberJavaUtil.$$$reportNull$$$0(1);
        }
        if ((version = CucumberConfigUtil.getCucumberCoreVersion(context)) == null || version.compareTo("1.1") >= 0) {
            return "cucumber.api.PendingException";
        }
        return "cucumber.runtime.PendingException";
    }

    @Nullable
    private static String getAnnotationName(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            CucumberJavaUtil.$$$reportNull$$$0(2);
        }
        Ref qualifiedAnnotationName = new Ref();
        ApplicationManager.getApplication().runReadAction(() -> {
            if (annotation == null) {
                CucumberJavaUtil.$$$reportNull$$$0(15);
            }
            String qualifiedName = annotation.getQualifiedName();
            qualifiedAnnotationName.set((Object)qualifiedName);
        });
        return (String)qualifiedAnnotationName.get();
    }

    public static boolean isCucumberStepAnnotation(@NotNull PsiAnnotation annotation) {
        String annotationName;
        if (annotation == null) {
            CucumberJavaUtil.$$$reportNull$$$0(3);
        }
        if ((annotationName = CucumberJavaUtil.getAnnotationName(annotation)) == null) {
            return false;
        }
        String annotationSuffix = CucumberJavaUtil.getCucumberAnnotationSuffix(annotationName);
        if (annotationSuffix.contains(".")) {
            return true;
        }
        for (String providedAnnotations : CucumberJavaAnnotationProvider.getCucumberStepAnnotations()) {
            if (!providedAnnotations.equals(annotationName)) continue;
            return true;
        }
        return false;
    }

    public static boolean isCucumberHookAnnotation(@NotNull PsiAnnotation annotation) {
        String annotationName;
        if (annotation == null) {
            CucumberJavaUtil.$$$reportNull$$$0(4);
        }
        if ((annotationName = CucumberJavaUtil.getAnnotationName(annotation)) == null) {
            return false;
        }
        String annotationSuffix = CucumberJavaUtil.getCucumberAnnotationSuffix(annotationName);
        for (String providedAnnotations : CucumberJavaAnnotationProvider.getCucumberHookAnnotations()) {
            if (!providedAnnotations.equals(annotationSuffix)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static PsiAnnotationMemberValue getAnnotationValue(@NotNull PsiAnnotation stepAnnotation) {
        if (stepAnnotation == null) {
            CucumberJavaUtil.$$$reportNull$$$0(5);
        }
        PsiNameValuePair[] attributes = stepAnnotation.getParameterList().getAttributes();
        PsiNameValuePair valuePair = null;
        if (attributes.length > 0) {
            for (int i = 1; i < attributes.length; ++i) {
                PsiNameValuePair pair = attributes[i];
                String pairName = pair.getName();
                if (pairName == null || !pairName.equals("value")) continue;
                valuePair = pair;
                break;
            }
            if (valuePair == null) {
                valuePair = attributes[0];
            }
        }
        return valuePair != null ? valuePair.getValue() : null;
    }

    public static boolean isStepDefinition(@NotNull PsiMethod method) {
        PsiAnnotation stepAnnotation;
        if (method == null) {
            CucumberJavaUtil.$$$reportNull$$$0(6);
        }
        return (stepAnnotation = CucumberJavaUtil.getCucumberStepAnnotation(method)) != null && CucumberJavaUtil.getAnnotationValue(stepAnnotation) != null;
    }

    public static boolean isHook(@NotNull PsiMethod method) {
        if (method == null) {
            CucumberJavaUtil.$$$reportNull$$$0(7);
        }
        return CucumberJavaUtil.getCucumberHookAnnotation(method) != null;
    }

    public static boolean isStepDefinitionClass(@NotNull PsiClass clazz) {
        PsiMethod[] methods;
        if (clazz == null) {
            CucumberJavaUtil.$$$reportNull$$$0(8);
        }
        for (PsiMethod method : methods = clazz.getAllMethods()) {
            if (CucumberJavaUtil.getCucumberStepAnnotation(method) == null && CucumberJavaUtil.getCucumberHookAnnotation(method) == null) continue;
            return true;
        }
        return false;
    }

    public static PsiAnnotation getCucumberStepAnnotation(@NotNull PsiMethod method) {
        if (method == null) {
            CucumberJavaUtil.$$$reportNull$$$0(9);
        }
        return CucumberJavaUtil.getCucumberStepAnnotation(method, null);
    }

    @Nullable
    public static PsiAnnotation getCucumberStepAnnotation(@NotNull PsiMethod method, @Nullable String annotationClassName) {
        PsiAnnotation[] annotations;
        if (method == null) {
            CucumberJavaUtil.$$$reportNull$$$0(10);
        }
        if (!method.hasModifierProperty("public")) {
            return null;
        }
        for (PsiAnnotation annotation : annotations = method.getModifierList().getAnnotations()) {
            if (annotation == null || annotationClassName != null && !annotationClassName.equals(annotation.getQualifiedName()) || !CucumberJavaUtil.isCucumberStepAnnotation(annotation)) continue;
            return annotation;
        }
        return null;
    }

    @Nullable
    public static PsiAnnotation getCucumberHookAnnotation(PsiMethod method) {
        PsiAnnotation[] annotations;
        if (!method.hasModifierProperty("public")) {
            return null;
        }
        for (PsiAnnotation annotation : annotations = method.getModifierList().getAnnotations()) {
            if (annotation == null || !CucumberJavaUtil.isCucumberHookAnnotation(annotation)) continue;
            return annotation;
        }
        return null;
    }

    @Nullable
    public static String getPatternFromStepDefinition(@NotNull PsiAnnotation stepAnnotation) {
        PsiElement patternLiteral;
        PsiAnnotationMemberValue annotationValue;
        if (stepAnnotation == null) {
            CucumberJavaUtil.$$$reportNull$$$0(11);
        }
        String result = null;
        if (stepAnnotation.getParameterList().getAttributes().length > 0 && (annotationValue = stepAnnotation.getParameterList().getAttributes()[0].getValue()) != null && (patternLiteral = annotationValue.getFirstChild()) != null) {
            String patternContainer = patternLiteral.getText();
            result = patternContainer.substring(1, patternContainer.length() - 1).replace("\\\\", "\\");
        }
        return result;
    }

    @Nullable
    private static String getPackageOfStepDef(GherkinStep[] steps) {
        for (GherkinStep step : steps) {
            String pack = CucumberJavaUtil.getPackageOfStep(step);
            if (pack == null) continue;
            return pack;
        }
        return null;
    }

    @NotNull
    public static String getPackageOfStepDef(PsiElement element) {
        GherkinFeature feature;
        PsiFile file = element.getContainingFile();
        if (file instanceof GherkinFile && (feature = (GherkinFeature)PsiTreeUtil.getChildOfType((PsiElement)file, GherkinFeature.class)) != null) {
            List scenarioList = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)feature, GherkinScenario.class);
            for (GherkinScenario scenario : scenarioList) {
                String result = CucumberJavaUtil.getPackageOfStepDef(scenario.getSteps());
                if (result == null) continue;
                String string = result;
                if (string == null) {
                    CucumberJavaUtil.$$$reportNull$$$0(12);
                }
                return string;
            }
            List scenarioOutlineList = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)feature, GherkinScenarioOutline.class);
            for (GherkinScenarioOutline scenario : scenarioOutlineList) {
                String result = CucumberJavaUtil.getPackageOfStepDef(scenario.getSteps());
                if (result == null) continue;
                String string = result;
                if (string == null) {
                    CucumberJavaUtil.$$$reportNull$$$0(13);
                }
                return string;
            }
        }
        if ("" == null) {
            CucumberJavaUtil.$$$reportNull$$$0(14);
        }
        return "";
    }

    public static String getPackageOfStep(GherkinStep step) {
        for (PsiReference ref : step.getReferences()) {
            PsiClassOwner file;
            String packageName;
            PsiElement refElement = ref.resolve();
            if (!(refElement instanceof PsiMethod) || !StringUtil.isNotEmpty((String)(packageName = (file = (PsiClassOwner)refElement.getContainingFile()).getPackageName()))) continue;
            return packageName;
        }
        return null;
    }

    public static void addGlue(String glue, Set<String> glues) {
        boolean covered = false;
        HashSet toRemove = ContainerUtil.newHashSet();
        for (String existedGlue : glues) {
            if (glue.startsWith(existedGlue + ".")) {
                covered = true;
                break;
            }
            if (!existedGlue.startsWith(glue + ".")) continue;
            toRemove.add(existedGlue);
        }
        for (String removing : toRemove) {
            glues.remove(removing);
        }
        if (!covered) {
            glues.add(glue);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stepAnnotation";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/cucumber/java/CucumberJavaUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/cucumber/java/CucumberJavaUtil";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageOfStepDef";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCucumberAnnotationSuffix";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCucumberPendingExceptionFqn";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isCucumberStepAnnotation";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isCucumberHookAnnotation";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationValue";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isStepDefinition";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isHook";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isStepDefinitionClass";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getCucumberStepAnnotation";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getPatternFromStepDefinition";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getAnnotationName$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

