/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.java.run;

import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.junit.JavaRunConfigurationProducerBase;
import com.intellij.execution.junit2.info.LocationUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedElementsSearch;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.java.CucumberJavaUtil;
import org.jetbrains.plugins.cucumber.java.run.CucumberJavaRunConfiguration;
import org.jetbrains.plugins.cucumber.java.run.CucumberJavaRunConfigurationType;

public abstract class CucumberJavaRunConfigurationProducer
extends JavaRunConfigurationProducerBase<CucumberJavaRunConfiguration>
implements Cloneable {
    public static final String FORMATTER_OPTIONS = " --format org.jetbrains.plugins.cucumber.java.run.CucumberJvmSMFormatter --monochrome";
    public static final String FORMATTER_OPTIONS_1_2 = " --plugin org.jetbrains.plugins.cucumber.java.run.CucumberJvmSMFormatter --monochrome";
    public static final String FORMATTER_OPTIONS_2 = " --plugin org.jetbrains.plugins.cucumber.java.run.CucumberJvm2SMFormatter --monochrome";
    public static final String CUCUMBER_1_0_MAIN_CLASS = "cucumber.cli.Main";
    public static final String CUCUMBER_1_1_MAIN_CLASS = "cucumber.api.cli.Main";
    public static final String CUCUMBER_1_2_PLUGIN_CLASS = "cucumber.api.Plugin";
    public static final String CUCUMBER_2_CLASS_MARKER = "cucumber.api.formatter.Formatter";
    public static final Set<String> HOOK_ANNOTATION_NAMES = ContainerUtil.newHashSet((Object[])new String[]{"cucumber.annotation.Before", "cucumber.annotation.After", "cucumber.api.java.Before", "cucumber.api.java.After"});

    protected CucumberJavaRunConfigurationProducer() {
        super((ConfigurationType)CucumberJavaRunConfigurationType.getInstance());
    }

    @Nullable
    protected abstract NullableComputable<String> getStepsGlue(@NotNull PsiElement var1);

    protected abstract String getConfigurationName(@NotNull ConfigurationContext var1);

    protected String getNameFilter(@NotNull ConfigurationContext context) {
        if (context == null) {
            CucumberJavaRunConfigurationProducer.$$$reportNull$$$0(0);
        }
        return "";
    }

    @Nullable
    protected abstract VirtualFile getFileToRun(ConfigurationContext var1);

    protected boolean setupConfigurationFromContext(CucumberJavaRunConfiguration configuration, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        VirtualFile virtualFile = this.getFileToRun(context);
        if (virtualFile == null) {
            return false;
        }
        Project project = configuration.getProject();
        PsiElement element = context.getPsiLocation();
        if (element == null) {
            return false;
        }
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile, (Project)project);
        if (module == null) {
            return false;
        }
        String mainClassName = null;
        String formatterOptions = null;
        Location location = context.getLocation();
        if (location != null) {
            if (LocationUtil.isJarAttached((Location)location, (PsiDirectory[])PsiDirectory.EMPTY_ARRAY, (String[])new String[]{CUCUMBER_1_0_MAIN_CLASS})) {
                mainClassName = CUCUMBER_1_0_MAIN_CLASS;
            } else if (LocationUtil.isJarAttached((Location)location, (PsiDirectory[])PsiDirectory.EMPTY_ARRAY, (String[])new String[]{CUCUMBER_1_1_MAIN_CLASS})) {
                mainClassName = CUCUMBER_1_1_MAIN_CLASS;
            }
            formatterOptions = LocationUtil.isJarAttached((Location)location, (PsiDirectory[])PsiDirectory.EMPTY_ARRAY, (String[])new String[]{CUCUMBER_2_CLASS_MARKER}) ? FORMATTER_OPTIONS_2 : (LocationUtil.isJarAttached((Location)location, (PsiDirectory[])PsiDirectory.EMPTY_ARRAY, (String[])new String[]{CUCUMBER_1_2_PLUGIN_CLASS}) ? FORMATTER_OPTIONS_1_2 : FORMATTER_OPTIONS);
        }
        if (mainClassName == null) {
            return false;
        }
        VirtualFile file = this.getFileToRun(context);
        if (file == null) {
            return false;
        }
        if (StringUtil.isEmpty((String)configuration.getGlue())) {
            NullableComputable<String> glue = this.getStepsGlue(element);
            configuration.setGlue(glue);
        }
        configuration.setNameFilter(this.getNameFilter(context));
        configuration.setFilePath(file.getPath());
        configuration.setProgramParameters(formatterOptions);
        if (configuration.getMainClassName() == null) {
            configuration.setMainClassName(mainClassName);
        }
        if (configuration.getNameFilter() != null && configuration.getNameFilter().length() > 0) {
            String newProgramParameters = configuration.getProgramParameters() + " --name \"" + configuration.getNameFilter() + "\"";
            configuration.setProgramParameters(newProgramParameters);
        }
        configuration.myGeneratedName = this.getConfigurationName(context);
        configuration.setGeneratedName();
        this.setupConfigurationModule(context, (ModuleBasedConfiguration)configuration);
        JavaRunConfigurationExtensionManager.getInstance().extendCreatedConfiguration((RunConfigurationBase)configuration, location);
        return true;
    }

    public boolean isConfigurationFromContext(CucumberJavaRunConfiguration runConfiguration, ConfigurationContext context) {
        Location location = JavaExecutionUtil.stepIntoSingleClass((Location)context.getLocation());
        if (location == null) {
            return false;
        }
        VirtualFile fileToRun = this.getFileToRun(context);
        if (fileToRun == null) {
            return false;
        }
        if (!fileToRun.getPath().equals(runConfiguration.getFilePath())) {
            return false;
        }
        if (!Comparing.strEqual((String)this.getNameFilter(context), (String)runConfiguration.getNameFilter())) {
            return false;
        }
        Module configurationModule = ((JavaRunConfigurationModule)runConfiguration.getConfigurationModule()).getModule();
        return Comparing.equal((Object)location.getModule(), (Object)configurationModule);
    }

    protected Set<String> getHookGlue(PsiElement element) {
        LinkedHashSet packages = ContainerUtil.newLinkedHashSet();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            return packages;
        }
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)element.getProject());
        GlobalSearchScope dependenciesScope = module.getModuleWithDependenciesAndLibrariesScope(true);
        for (String fullyQualifiedAnnotationName : HOOK_ANNOTATION_NAMES) {
            PsiClass psiClass = javaPsiFacade.findClass(fullyQualifiedAnnotationName, dependenciesScope);
            if (psiClass == null) continue;
            Query psiMethods = AnnotatedElementsSearch.searchPsiMethods((PsiClass)psiClass, (SearchScope)GlobalSearchScope.allScope((Project)element.getProject()));
            Collection methods = psiMethods.findAll();
            CucumberJavaRunConfigurationProducer.addPackagesOfMethods(methods, packages);
        }
        return packages;
    }

    private static Set<String> addPackagesOfMethods(Collection<PsiMethod> psiMethods, Set<String> packages) {
        for (PsiMethod psiMethod : psiMethods) {
            PsiClassOwner file = (PsiClassOwner)psiMethod.getContainingFile();
            String packageName = file.getPackageName();
            if (!StringUtil.isNotEmpty((String)packageName)) continue;
            CucumberJavaUtil.addGlue(packageName, packages);
        }
        return packages;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/cucumber/java/run/CucumberJavaRunConfigurationProducer", "getNameFilter"));
    }
}

