/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph;

import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.base.NodeCursor;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.GraphDataModel;
import com.intellij.openapi.graph.geom.YPoint;
import com.intellij.openapi.graph.layout.Layouter;
import com.intellij.openapi.graph.settings.GraphSettings;
import com.intellij.openapi.graph.settings.GraphSettingsProvider;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class GraphUtil {
    public static boolean setBestPopupSizeForGraph(JBPopup popup, GraphBuilder<?, ?> builder) {
        Dimension size = GraphUtil.calcGraphSize(builder);
        Dimension best = new Dimension(size.width + 40, size.height + 60);
        Dimension screenSize = popup.getContent().getToolkit().getScreenSize();
        boolean canFit = true;
        if (best.width > screenSize.width - 200) {
            canFit = false;
            best.width = screenSize.width - 200;
        }
        if (best.height > screenSize.height - 200) {
            canFit = false;
            best.height = screenSize.height - 200;
        }
        popup.setSize(best);
        return canFit;
    }

    public static Dimension calcGraphSize(GraphBuilder builder) {
        Object layout;
        double x0 = 0.0;
        double y0 = 0.0;
        double xx = 0.0;
        double yy = 0.0;
        for (Object nodeObject : builder.getNodeObjects()) {
            Node node = builder.getNode(nodeObject);
            if (node == null || (layout = builder.getGraph().getNodeLayout(node)) == null) continue;
            x0 = Math.min(x0, layout.getX());
            y0 = Math.min(y0, layout.getY());
            xx = Math.max(xx, layout.getX() + layout.getWidth());
            yy = Math.max(yy, layout.getY() + layout.getHeight());
        }
        for (Object edgeObject : builder.getEdgeObjects()) {
            Edge edge = builder.getEdge(edgeObject);
            if (edge == null || (layout = builder.getGraph().getEdgeLayout(edge)) == null) continue;
            for (int i = 0; i < layout.pointCount(); ++i) {
                YPoint p = layout.getPoint(i);
                x0 = Math.min(x0, p.getX());
                y0 = Math.min(y0, p.getY());
                xx = Math.max(xx, p.getX());
                yy = Math.max(yy, p.getY());
            }
        }
        int width = (int)(xx - x0);
        int height = (int)(yy - y0);
        if (width == 0) {
            width = JBUI.scale((int)400);
        }
        if (height == 0) {
            height = JBUI.scale((int)400);
        }
        return x0 == 0.0 && y0 == 0.0 && xx == 0.0 && yy == 0.0 ? JBUI.size((int)400) : new Dimension(width, height);
    }

    public static <NODE_TYPE> List<NODE_TYPE> getSelectedNodes(GraphBuilder<NODE_TYPE, ?> builder) {
        ArrayList<NODE_TYPE> selectedNodes = new ArrayList<NODE_TYPE>();
        NodeCursor nc = builder.getGraph().selectedNodes();
        while (nc.ok()) {
            Node node = nc.node();
            NODE_TYPE nodeObject = builder.getNodeObject(node);
            if (nodeObject != null) {
                selectedNodes.add(nodeObject);
            }
            nc.next();
        }
        return selectedNodes;
    }

    /*
     * WARNING - void declaration
     */
    public static <N, E> void filterSelectedNodesDependencies(GraphBuilder<N, E> builder, boolean updateGraph) {
        void var9_14;
        List<Object> selectedNodes = GraphUtil.getSelectedNodes(builder);
        if (selectedNodes.size() == 0) {
            return;
        }
        if (updateGraph) {
            builder.updateGraph();
        }
        HashSet<Object> edgesToShow = new HashSet<Object>();
        GraphDataModel<Object, Object> dataModel = builder.getGraphDataModel();
        for (Object[] selectedNode : selectedNodes) {
            for (Object edge : builder.getEdgeObjects()) {
                if (!selectedNode.equals(dataModel.getSourceNode(edge)) && !selectedNode.equals(dataModel.getTargetNode(edge))) continue;
                edgesToShow.add(edge);
            }
        }
        Collection<Object> edgeObjects = builder.getEdgeObjects();
        for (Object object : ArrayUtil.toObjectArray(edgeObjects)) {
            if (edgesToShow.contains(object)) continue;
            builder.removeEdge(object);
        }
        Collection<Object> nodeObjects = builder.getNodeObjects();
        Object[] objectArray = ArrayUtil.toObjectArray(nodeObjects);
        int n = objectArray.length;
        boolean bl = false;
        while (var9_14 < n) {
            Object currentNodeObject = objectArray[var9_14];
            if (!selectedNodes.contains(currentNodeObject)) {
                boolean toDelete = true;
                for (Object edgeObject : edgesToShow) {
                    if (!currentNodeObject.equals(dataModel.getSourceNode(edgeObject)) && !currentNodeObject.equals(dataModel.getTargetNode(edgeObject))) continue;
                    toDelete = false;
                    break;
                }
                if (toDelete) {
                    builder.removeNode(currentNodeObject);
                }
            }
            ++var9_14;
        }
        GraphUtil.doLayout(builder);
        builder.getView().fitContent();
    }

    public static void doLayout(GraphBuilder builder) {
        Graph2D graph = builder.getGraph();
        GraphSettings settings = GraphSettingsProvider.getInstance(builder.getProject()).getSettings(graph);
        Layouter layouter = settings.getCurrentLayouter();
        if (layouter == null || !layouter.canLayout(graph)) {
            layouter = settings.getGroupLayouter();
        }
        GraphManager.getGraphManager().createBufferedLayouter(layouter).doLayout(graph);
    }
}

