/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.intellij.lang.reference;

import com.intellij.lang.properties.references.PropertyReference;
import com.intellij.openapi.paths.PathReferenceManager;
import com.intellij.openapi.paths.PathReferenceProvider;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.XmlAttributeValuePattern;
import com.intellij.patterns.XmlPatterns;
import com.intellij.patterns.XmlTagPattern;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.tapestry.core.TapestryProject;
import com.intellij.tapestry.core.java.IJavaField;
import com.intellij.tapestry.core.java.IJavaMethod;
import com.intellij.tapestry.core.model.presentation.Component;
import com.intellij.tapestry.core.model.presentation.Page;
import com.intellij.tapestry.core.model.presentation.PresentationLibraryElement;
import com.intellij.tapestry.core.model.presentation.TapestryParameter;
import com.intellij.tapestry.core.model.presentation.valueresolvers.ResolvedValue;
import com.intellij.tapestry.core.model.presentation.valueresolvers.ValueResolverChain;
import com.intellij.tapestry.core.resource.IResource;
import com.intellij.tapestry.intellij.TapestryModuleSupportLoader;
import com.intellij.tapestry.intellij.core.java.IntellijJavaClassType;
import com.intellij.tapestry.intellij.core.java.IntellijJavaField;
import com.intellij.tapestry.intellij.core.java.IntellijJavaMethod;
import com.intellij.tapestry.intellij.core.resource.IntellijResource;
import com.intellij.tapestry.intellij.lang.descriptor.TapestryXmlExtension;
import com.intellij.tapestry.intellij.lang.reference.PsiAttributeValueReference;
import com.intellij.tapestry.intellij.util.TapestryUtils;
import com.intellij.tapestry.psi.TmlFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TapestryReferenceContributor
extends PsiReferenceContributor {
    private static final PatternCondition<XmlElement> tapestryFileCondition = new PatternCondition<XmlElement>("tapestryFileCondition"){

        public boolean accepts(@NotNull XmlElement element, ProcessingContext context) {
            if (element == null) {
                1.$$$reportNull$$$0(0);
            }
            return element.getContainingFile() instanceof TmlFile;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/tapestry/intellij/lang/reference/TapestryReferenceContributor$1", "accepts"));
        }
    };
    private static final Key<XmlTag> TAG_KEY = Key.create((String)"TAG_KEY");

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            TapestryReferenceContributor.$$$reportNull$$$0(0);
        }
        String[] tapestryTemplateNamespaces = TapestryXmlExtension.tapestryTemplateNamespaces();
        TapestryReferenceContributor.registerTypeAttrValueReferenceProvider(registrar, tapestryTemplateNamespaces);
        TapestryReferenceContributor.registerIdAttrValueReferenceProvider(registrar, tapestryTemplateNamespaces);
        TapestryReferenceContributor.registerAttrValueReferenceProvider(registrar);
        TapestryReferenceContributor.registerLinkHrefReference(registrar);
    }

    private static void registerLinkHrefReference(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            TapestryReferenceContributor.$$$reportNull$$$0(1);
        }
        registrar.registerReferenceProvider((ElementPattern)((XmlAttributeValuePattern)XmlPatterns.xmlAttributeValue((String[])new String[]{"href"}).inside((ElementPattern)XmlPatterns.xmlTag().withName("link"))).with(tapestryFileCondition), new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    2.$$$reportNull$$$0(1);
                }
                PsiReference[] psiReferenceArray = PathReferenceManager.getInstance().createReferences(element, true, false, true, new PathReferenceProvider[0]);
                if (psiReferenceArray == null) {
                    2.$$$reportNull$$$0(2);
                }
                return psiReferenceArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/tapestry/intellij/lang/reference/TapestryReferenceContributor$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/tapestry/intellij/lang/reference/TapestryReferenceContributor$2";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReferencesByElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getReferencesByElement";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
    }

    private static void registerTypeAttrValueReferenceProvider(PsiReferenceRegistrar registrar, String[] tapestryTemplateNamespaces) {
        registrar.registerReferenceProvider((ElementPattern)XmlPatterns.xmlAttributeValue((String[])new String[]{"type"}).withNamespace(tapestryTemplateNamespaces).with(tapestryFileCondition), new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    3.$$$reportNull$$$0(1);
                }
                XmlAttributeValue typeAttrValue = (XmlAttributeValue)element;
                PsiReference[] psiReferenceArray = TapestryReferenceContributor.getReferenceToComponentClass(typeAttrValue, ElementManipulators.getValueTextRange((PsiElement)typeAttrValue));
                if (psiReferenceArray == null) {
                    3.$$$reportNull$$$0(2);
                }
                return psiReferenceArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/tapestry/intellij/lang/reference/TapestryReferenceContributor$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/tapestry/intellij/lang/reference/TapestryReferenceContributor$3";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReferencesByElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getReferencesByElement";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        registrar.registerReferenceProvider((ElementPattern)XmlPatterns.xmlAttributeValue((String[])new String[]{"alt"}).with(tapestryFileCondition), new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    4.$$$reportNull$$$0(1);
                }
                String value = StringUtil.stripQuotesAroundValue((String)element.getText());
                String prefix = "message:";
                if (value.startsWith("message:")) {
                    String key = value.substring("message:".length());
                    int valueStart = "message:".length() + 1;
                    PsiReference[] psiReferenceArray = new PsiReference[]{new PropertyReference(key, element, null, true, new TextRange(valueStart, valueStart + key.length()))};
                    if (psiReferenceArray == null) {
                        4.$$$reportNull$$$0(2);
                    }
                    return psiReferenceArray;
                }
                if (PsiReference.EMPTY_ARRAY == null) {
                    4.$$$reportNull$$$0(3);
                }
                return PsiReference.EMPTY_ARRAY;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: 
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: 
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/tapestry/intellij/lang/reference/TapestryReferenceContributor$4";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/tapestry/intellij/lang/reference/TapestryReferenceContributor$4";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReferencesByElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getReferencesByElement";
                        break;
                    }
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: 
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
    }

    private static void registerIdAttrValueReferenceProvider(PsiReferenceRegistrar registrar, String[] tapestryTemplateNamespaces) {
        registrar.registerReferenceProvider((ElementPattern)XmlPatterns.xmlAttributeValue((String[])new String[]{"id"}).withNamespace(tapestryTemplateNamespaces).with(tapestryFileCondition), new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    5.$$$reportNull$$$0(1);
                }
                XmlAttributeValue idAttrValue = (XmlAttributeValue)element;
                XmlElement identifier = TapestryUtils.getComponentIdentifier(TapestryReferenceContributor.parentTag(idAttrValue));
                TextRange valueTextRange = ElementManipulators.getValueTextRange((PsiElement)idAttrValue);
                PsiReference[] psiReferenceArray = identifier == idAttrValue.getParent() ? TapestryReferenceContributor.getReferenceToEmbeddedComponent(idAttrValue, valueTextRange) : TapestryReferenceContributor.getReferenceByComponentId(idAttrValue, valueTextRange);
                if (psiReferenceArray == null) {
                    5.$$$reportNull$$$0(2);
                }
                return psiReferenceArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/tapestry/intellij/lang/reference/TapestryReferenceContributor$5";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/tapestry/intellij/lang/reference/TapestryReferenceContributor$5";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReferencesByElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getReferencesByElement";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
    }

    private static XmlTag parentTag(XmlAttributeValue value) {
        PsiElement parent = value.getParent();
        if (parent instanceof XmlAttribute) {
            return ((XmlAttribute)parent).getParent();
        }
        return null;
    }

    private static void registerAttrValueReferenceProvider(PsiReferenceRegistrar registrar) {
        PatternCondition<XmlTag> tapestryTagCondition = new PatternCondition<XmlTag>("tapestryTagCondition"){

            public boolean accepts(@NotNull XmlTag tag, ProcessingContext context) {
                if (tag == null) {
                    6.$$$reportNull$$$0(0);
                }
                return tag.getContainingFile() instanceof TmlFile && TapestryUtils.getTypeOfTag(tag) != null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/tapestry/intellij/lang/reference/TapestryReferenceContributor$6", "accepts"));
            }
        };
        XmlAttributeValuePattern tapestryAttributeValuePattern = (XmlAttributeValuePattern)XmlPatterns.xmlAttributeValue().withSuperParent(2, (ElementPattern)((XmlTagPattern.Capture)XmlPatterns.xmlTag().with((PatternCondition)tapestryTagCondition)).save(TAG_KEY));
        registrar.registerReferenceProvider((ElementPattern)tapestryAttributeValuePattern, new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    7.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    7.$$$reportNull$$$0(1);
                }
                XmlAttributeValue attrValue = (XmlAttributeValue)element;
                XmlTag tag = (XmlTag)context.get(TAG_KEY);
                Component component = TapestryUtils.getTypeOfTag(tag);
                if (component == null) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        7.$$$reportNull$$$0(2);
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                PsiElement parent = attrValue.getParent();
                if (!(parent instanceof XmlAttribute)) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        7.$$$reportNull$$$0(3);
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                String localName = ((XmlAttribute)parent).getLocalName();
                TapestryParameter parameter = component.getParameters().get(localName);
                if (parameter == null) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        7.$$$reportNull$$$0(4);
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                PsiReference[] psiReferenceArray = localName.equals("page") ? TapestryReferenceContributor.getReferenceToPage(component, attrValue) : TapestryReferenceContributor.getAttrValueReference(attrValue, component.getProject(), parameter);
                if (psiReferenceArray == null) {
                    7.$$$reportNull$$$0(5);
                }
                return psiReferenceArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/tapestry/intellij/lang/reference/TapestryReferenceContributor$7";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/tapestry/intellij/lang/reference/TapestryReferenceContributor$7";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReferencesByElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getReferencesByElement";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
    }

    private static PsiReference[] getAttrValueReference(XmlAttributeValue attrValue, TapestryProject project, TapestryParameter parameter) {
        ResolvedValue resolvedValue;
        PresentationLibraryElement element = project.findElementByTemplate(attrValue.getContainingFile());
        if (element == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        IntellijJavaClassType elementClass = (IntellijJavaClassType)element.getElementClass();
        try {
            resolvedValue = ValueResolverChain.getInstance().resolve(project, elementClass, attrValue.getValue(), parameter.getDefaultPrefix());
        }
        catch (Exception ex) {
            return PsiReference.EMPTY_ARRAY;
        }
        if (resolvedValue == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        if (resolvedValue.getCodeBind() instanceof IJavaMethod) {
            return new PsiReference[]{new PsiAttributeValueReference(attrValue, (PsiElement)((IntellijJavaMethod)resolvedValue.getCodeBind()).getPsiMethod())};
        }
        if (resolvedValue.getCodeBind() instanceof IJavaField) {
            return new PsiReference[]{new PsiAttributeValueReference(attrValue, (PsiElement)((IntellijJavaField)resolvedValue.getCodeBind()).getPsiField())};
        }
        return PsiReference.EMPTY_ARRAY;
    }

    @NotNull
    private static PsiReference[] getReferenceToComponentClass(@NotNull XmlAttributeValue attributeValue, @Nullable TextRange range) {
        if (attributeValue == null) {
            TapestryReferenceContributor.$$$reportNull$$$0(2);
        }
        if (range == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                TapestryReferenceContributor.$$$reportNull$$$0(3);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        final XmlTag tag = TapestryReferenceContributor.parentTag(attributeValue);
        if (tag == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                TapestryReferenceContributor.$$$reportNull$$$0(4);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        Component component = TapestryUtils.getTypeOfTag(tag);
        final IntellijJavaClassType elementClass = component == null ? null : (IntellijJavaClassType)component.getElementClass();
        PsiReference[] psiReferenceArray = new PsiReference[]{new PsiReferenceBase<PsiElement>((PsiElement)attributeValue, range){

            @Nullable
            public PsiElement resolve() {
                return elementClass == null ? null : elementClass.getPsiClass();
            }

            @NotNull
            public Object[] getVariants() {
                TapestryProject project = TapestryModuleSupportLoader.getTapestryProject((XmlElement)tag);
                Object[] objectArray = project == null ? EMPTY_ARRAY : project.getAvailableComponentNames();
                if (objectArray == null) {
                    8.$$$reportNull$$$0(0);
                }
                return objectArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/intellij/lang/reference/TapestryReferenceContributor$8", "getVariants"));
            }
        }};
        if (psiReferenceArray == null) {
            TapestryReferenceContributor.$$$reportNull$$$0(5);
        }
        return psiReferenceArray;
    }

    @NotNull
    private static PsiReference[] getReferenceToEmbeddedComponent(@NotNull XmlAttributeValue attr, TextRange range) {
        if (attr == null) {
            TapestryReferenceContributor.$$$reportNull$$$0(6);
        }
        if (range == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                TapestryReferenceContributor.$$$reportNull$$$0(7);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        final XmlTag tag = TapestryReferenceContributor.parentTag(attr);
        final IntellijJavaField field = (IntellijJavaField)TapestryUtils.findIdentifyingField(tag);
        PsiReference[] psiReferenceArray = new PsiReference[]{new PsiReferenceBase<PsiElement>((PsiElement)attr, range){

            @Nullable
            public PsiElement resolve() {
                return field == null ? null : field.getPsiField();
            }

            @NotNull
            public Object[] getVariants() {
                List<String> fieldsIds = TapestryUtils.getEmbeddedComponentIds(tag);
                Object[] objectArray = ArrayUtil.toStringArray(fieldsIds);
                if (objectArray == null) {
                    9.$$$reportNull$$$0(0);
                }
                return objectArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/intellij/lang/reference/TapestryReferenceContributor$9", "getVariants"));
            }
        }};
        if (psiReferenceArray == null) {
            TapestryReferenceContributor.$$$reportNull$$$0(8);
        }
        return psiReferenceArray;
    }

    @NotNull
    private static PsiReference[] getReferenceByComponentId(final @NotNull XmlAttributeValue attrValue, TextRange range) {
        if (attrValue == null) {
            TapestryReferenceContributor.$$$reportNull$$$0(9);
        }
        if (range == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                TapestryReferenceContributor.$$$reportNull$$$0(10);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiReference[] psiReferenceArray = new PsiReference[]{new PsiReferenceBase<PsiElement>((PsiElement)attrValue, range){

            @Nullable
            public PsiElement resolve() {
                return attrValue;
            }

            @NotNull
            public Object[] getVariants() {
                if (EMPTY_ARRAY == null) {
                    10.$$$reportNull$$$0(0);
                }
                return EMPTY_ARRAY;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/intellij/lang/reference/TapestryReferenceContributor$10", "getVariants"));
            }
        }};
        if (psiReferenceArray == null) {
            TapestryReferenceContributor.$$$reportNull$$$0(11);
        }
        return psiReferenceArray;
    }

    @NotNull
    private static PsiReference[] getReferenceToPage(final Component component, @NotNull XmlAttributeValue pageAttrValue) {
        TextRange range;
        if (pageAttrValue == null) {
            TapestryReferenceContributor.$$$reportNull$$$0(12);
        }
        if ((range = ElementManipulators.getValueTextRange((PsiElement)pageAttrValue)) == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                TapestryReferenceContributor.$$$reportNull$$$0(13);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        final Page page = component.getProject().findPage(pageAttrValue.getValue());
        PsiReference[] psiReferenceArray = new PsiReference[]{new PsiReferenceBase<PsiElement>((PsiElement)pageAttrValue, range){

            @Nullable
            public PsiElement resolve() {
                if (page == null) {
                    return null;
                }
                IResource[] templates = page.getTemplate();
                return templates.length == 0 ? null : ((IntellijResource)templates[0]).getPsiFile();
            }

            @NotNull
            public Object[] getVariants() {
                Object[] objectArray = component.getProject().getAvailablePageNames();
                if (objectArray == null) {
                    11.$$$reportNull$$$0(0);
                }
                return objectArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/intellij/lang/reference/TapestryReferenceContributor$11", "getVariants"));
            }
        }};
        if (psiReferenceArray == null) {
            TapestryReferenceContributor.$$$reportNull$$$0(14);
        }
        return psiReferenceArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeValue";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tapestry/intellij/lang/reference/TapestryReferenceContributor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attr";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrValue";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pageAttrValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tapestry/intellij/lang/reference/TapestryReferenceContributor";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceToComponentClass";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceToEmbeddedComponent";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceByComponentId";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceToPage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerReferenceProviders";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "registerLinkHrefReference";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceToComponentClass";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceToEmbeddedComponent";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceByComponentId";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceToPage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

