/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.j2ee.web.resin;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.javaee.artifact.JavaeeArtifactUtil;
import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.run.configuration.JavaCommandLineStartupPolicy;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.util.PathsList;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.intellij.j2ee.web.resin.ResinBundle;
import org.intellij.j2ee.web.resin.ResinModel;
import org.intellij.j2ee.web.resin.resin.ResinConfiguration;
import org.intellij.j2ee.web.resin.resin.ResinInstallation;
import org.intellij.j2ee.web.resin.resin.version.ResinVersion;
import org.jetbrains.annotations.NonNls;

public class ResinStartupPolicy
implements JavaCommandLineStartupPolicy {
    private static final Logger LOG = Logger.getInstance(ResinStartupPolicy.class);
    @NonNls
    private static final String RESIN_RUN_PROP_FILE = "ResinRun.properties";
    @NonNls
    private static final String DEBUG_VM_PARAMS_PROP = "resin.debug.vm.param";
    @NonNls
    private static final String JMX_VM_PARAMS_PROP = "resin.jmx.vm.param";
    @NonNls
    private static final String RESINHOME_VM_PARAMS_PROP = "resin.home.vm.param";
    @NonNls
    private static final String JAVA_LIB_PATH_VM_PARAMS_PROP = "java.lib.path.vm.param";
    @NonNls
    private static final String SERVER_ID_VM_PARAMS_PROP = "server.id.vm.param";
    @NonNls
    private static final String COMMAND_LINE_CONF_ARG_PROP = "resin.command.line.conf.arg.name";
    @NonNls
    private static final String COMMAND_LINE_SERVER_ID_ARG_PROP = "resin.command.line.server.id.arg.name";
    @NonNls
    private static final String RESIN_VERSIONS_INVALID_PATHS_PROP = "resin.versions.not.allow.white.spaces";
    @NonNls
    private static final String RESIN_PROPERTIES_FILE_PATH = "/conf/resin.properties";
    @NonNls
    private static final String RESIN_JVM_ARGS_PROP = "jvm_args";
    private Properties resinRunProps = null;

    public JavaParameters createCommandLine(CommonModel commonModel) throws ExecutionException {
        File[] allJars;
        VirtualFile[] files;
        String additionalParameters;
        ResinModel resinModel = (ResinModel)commonModel.getServerModel();
        ResinConfiguration resinConfiguration = resinModel.getOrCreateResinConfiguration(true);
        ResinInstallation installation = resinConfiguration.getInstallation();
        String homePath = FileUtil.toSystemDependentName((String)installation.getResinHome().getPath());
        JavaParameters parameters = new JavaParameters();
        String charset = resinModel.getCharset();
        if (!"".equals(charset)) {
            parameters.setCharset(Charset.forName(resinModel.getCharset()));
        }
        if (resinConfiguration.getInstallation().getVersion().allowXdebug()) {
            this.loadResinRunProp(DEBUG_VM_PARAMS_PROP, parameters, new Object[0]);
        }
        ResinVersion resinVersion = resinConfiguration.getInstallation().getVersion();
        parameters.setWorkingDirectory(homePath);
        parameters.setMainClass(resinVersion.getStartupClass());
        if (resinModel.hasJmxStrategy()) {
            this.loadResinRunProp(JMX_VM_PARAMS_PROP, parameters, String.valueOf(resinModel.getJmxPort()));
        }
        this.loadResinRunProp(RESINHOME_VM_PARAMS_PROP, parameters, homePath);
        if (homePath.indexOf(32) != -1 && !this.allowsRunWithWhiteSpace(resinVersion)) {
            throw new ExecutionException(ResinBundle.message("resin.run.error.invalid.path", homePath));
        }
        this.loadResinRunProp(JAVA_LIB_PATH_VM_PARAMS_PROP, parameters, homePath);
        ParametersList parametersList = parameters.getProgramParametersList();
        parametersList.add(this.getResinRunProperty(COMMAND_LINE_CONF_ARG_PROP, new Object[0])[0], resinConfiguration.getConfigFile().getAbsolutePath());
        String serverId = resinConfiguration.getServerId();
        if (!StringUtil.isEmpty((String)serverId)) {
            parametersList.add(this.getResinRunProperty(COMMAND_LINE_SERVER_ID_ARG_PROP, new Object[0])[0], serverId);
            this.loadResinRunProp(SERVER_ID_VM_PARAMS_PROP, parameters, serverId);
        }
        if (!"".equals(additionalParameters = resinModel.getAdditionalParameters())) {
            parametersList.addParametersString(additionalParameters);
        }
        ResinStartupPolicy.loadResinConfProperties(homePath, parameters);
        PathsList classpath = parameters.getClassPath();
        for (VirtualFile file : files = commonModel.getApplicationServer().getLibrary().getFiles(OrderRootType.CLASSES)) {
            classpath.add(file.getPresentableUrl());
        }
        for (File jar : allJars = resinConfiguration.getInstallation().getLibFiles(true)) {
            String s = jar.getAbsolutePath();
            if (classpath.getPathList().contains(s)) continue;
            classpath.add(s);
        }
        if (resinModel.isAutoBuildClassPath()) {
            ArrayList outputAndLibs = new ArrayList();
            for (DeploymentModel model : commonModel.getDeploymentModels()) {
                Artifact artifact = model.getArtifact();
                if (artifact == null) continue;
                Collection webFacets = JavaeeArtifactUtil.getInstance().getFacetsIncludedInArtifact(commonModel.getProject(), artifact, WebFacet.ID);
                for (WebFacet webFacet : webFacets) {
                    ModuleRootManager mrm = ModuleRootManager.getInstance((Module)webFacet.getModule());
                    VirtualFile[] roots = mrm.orderEntries().withoutSdk().recursively().exportedOnly().getClassesRoots();
                    Collections.addAll(outputAndLibs, roots);
                }
            }
            for (VirtualFile vfile : outputAndLibs) {
                classpath.add(vfile);
            }
        }
        return parameters;
    }

    private boolean allowsRunWithWhiteSpace(ResinVersion resinVersion) throws ExecutionException {
        String[] tocheck;
        String verNumber;
        String[] value = this.getResinRunProperty(RESIN_VERSIONS_INVALID_PATHS_PROP, new Object[0]);
        List<String> invalids = Arrays.asList(value);
        if (invalids.contains(verNumber = resinVersion.getVersionNumber())) {
            return false;
        }
        for (String actual : tocheck = verNumber.split("\\.")) {
            if (!invalids.contains(actual + ".x")) continue;
            return false;
        }
        return true;
    }

    private void loadResinRunProp(String prop, JavaParameters parameters, Object ... substitution) throws ExecutionException {
        String[] values;
        for (String value : values = this.getResinRunProperty(prop, substitution)) {
            parameters.getVMParametersList().add(value);
        }
    }

    private String[] getResinRunProperty(String prop, Object ... substitution) throws ExecutionException {
        this.loadResinRunProperties();
        String value = this.resinRunProps.getProperty(prop);
        if (value == null) {
            throw new ExecutionException(ResinBundle.message("resin.run.property.missing", prop));
        }
        String[] res = value.split(" ");
        if (substitution != null) {
            for (int i = 0; i < res.length; ++i) {
                res[i] = MessageFormat.format(res[i], substitution);
            }
        }
        return res;
    }

    private void loadResinRunProperties() throws ExecutionException {
        if (this.resinRunProps != null) {
            return;
        }
        this.resinRunProps = new Properties();
        try {
            this.resinRunProps.load(this.getClass().getResourceAsStream(RESIN_RUN_PROP_FILE));
        }
        catch (IOException e) {
            throw new ExecutionException(ResinBundle.message("resin.run.startup.no.prop", new Object[0]));
        }
    }

    private static void loadResinConfProperties(String homePath, JavaParameters parameters) {
        File propertiesFile = new File(FileUtil.toSystemDependentName((String)(homePath + RESIN_PROPERTIES_FILE_PATH)));
        if (!propertiesFile.exists()) {
            return;
        }
        Properties props = new Properties();
        try {
            props.load(new FileReader(propertiesFile));
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
        parameters.getVMParametersList().addParametersString(props.getProperty(RESIN_JVM_ARGS_PROP));
    }
}

