/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeEditor.printing;

import com.intellij.codeEditor.printing.CodeEditorBundle;
import com.intellij.codeEditor.printing.PrintOption;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReference;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HyperlinksToClassesOption
extends PrintOption {
    private JCheckBox myCbGenerateHyperlinksToClasses;
    private boolean isGenerateHyperlinksToClasses;

    @Nullable
    public TreeMap<Integer, PsiReference> collectReferences(PsiFile psiFile, Map<PsiFile, PsiFile> filesMap) {
        FileType fileType;
        if (this.isGenerateHyperlinksToClasses && (StdFileTypes.JAVA == (fileType = psiFile.getFileType()) || StdFileTypes.JSP == fileType)) {
            TreeMap<Integer, PsiReference> refMap = new TreeMap<Integer, PsiReference>();
            HyperlinksToClassesOption.findClassReferences((PsiElement)psiFile, refMap, filesMap, psiFile);
            return refMap;
        }
        return null;
    }

    @NotNull
    public UnnamedConfigurable createConfigurable() {
        HyperlinksToClassesConfigurable hyperlinksToClassesConfigurable = new HyperlinksToClassesConfigurable();
        if (hyperlinksToClassesConfigurable == null) {
            HyperlinksToClassesOption.$$$reportNull$$$0(0);
        }
        return hyperlinksToClassesConfigurable;
    }

    private static void findClassReferences(PsiElement psiElement, TreeMap<Integer, PsiReference> refMap, Map<PsiFile, PsiFile> filesMap, PsiFile psiFile) {
        PsiElement[] children;
        PsiElement refElement;
        PsiReference ref = psiElement.getReference();
        if (ref instanceof PsiJavaCodeReferenceElement && (refElement = ref.resolve()) instanceof PsiClass) {
            PsiFile containingFile = refElement.getContainingFile();
            if (!containingFile.equals(psiFile) && filesMap.get(containingFile) != null) {
                refMap.put(psiElement.getTextRange().getStartOffset(), ref);
            }
            return;
        }
        for (PsiElement aChildren : children = psiElement.getChildren()) {
            HyperlinksToClassesOption.findClassReferences(aChildren, refMap, filesMap, psiFile);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeEditor/printing/HyperlinksToClassesOption", "createConfigurable"));
    }

    private class HyperlinksToClassesConfigurable
    implements UnnamedConfigurable {
        private HyperlinksToClassesConfigurable() {
        }

        public JComponent createComponent() {
            HyperlinksToClassesOption.this.myCbGenerateHyperlinksToClasses = new JCheckBox(CodeEditorBundle.message((String)"export.to.html.generate.hyperlinks.checkbox", (Object[])new Object[0]), HyperlinksToClassesOption.this.isGenerateHyperlinksToClasses);
            return HyperlinksToClassesOption.this.myCbGenerateHyperlinksToClasses;
        }

        public boolean isModified() {
            return HyperlinksToClassesOption.this.myCbGenerateHyperlinksToClasses.isSelected() != HyperlinksToClassesOption.this.isGenerateHyperlinksToClasses;
        }

        public void apply() throws ConfigurationException {
            HyperlinksToClassesOption.this.isGenerateHyperlinksToClasses = HyperlinksToClassesOption.this.myCbGenerateHyperlinksToClasses.isSelected();
        }

        public void reset() {
            HyperlinksToClassesOption.this.myCbGenerateHyperlinksToClasses.setSelected(HyperlinksToClassesOption.this.isGenerateHyperlinksToClasses);
        }

        public void disposeUIResources() {
        }
    }
}

