/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CastingLookupElementDecorator;
import com.intellij.codeInsight.completion.CollectionsUtilityMethodsProvider;
import com.intellij.codeInsight.completion.JavaKeywordCompletion;
import com.intellij.codeInsight.completion.JavaMethodCallElement;
import com.intellij.codeInsight.completion.JavaSmartCompletionParameters;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.SmartCompletionTemplateItem;
import com.intellij.codeInsight.guess.GuessManager;
import com.intellij.codeInsight.lookup.ExpressionLookupItem;
import com.intellij.codeInsight.lookup.KeywordLookupItem;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.VariableLookupItem;
import com.intellij.codeInsight.template.SmartCompletionContextType;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.filters.getters.ClassLiteralGetter;
import com.intellij.psi.filters.getters.ThisGetter;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.MultiMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasicExpressionCompletionContributor {
    private static void addKeyword(Consumer<LookupElement> result, PsiElement element, String s) {
        result.consume((Object)BasicExpressionCompletionContributor.createKeywordLookupItem(element, s));
    }

    public static LookupElement createKeywordLookupItem(PsiElement element, String s) {
        return new KeywordLookupItem(JavaPsiFacade.getElementFactory((Project)element.getProject()).createKeyword(s, element), element);
    }

    public static void fillCompletionVariants(JavaSmartCompletionParameters parameters2, Consumer<LookupElement> result, PrefixMatcher matcher) {
        PsiElement element = parameters2.getPosition();
        if (JavaKeywordCompletion.isAfterTypeDot(element)) {
            BasicExpressionCompletionContributor.addKeyword(result, element, "class");
            BasicExpressionCompletionContributor.addKeyword(result, element, "this");
        }
        if (!JavaKeywordCompletion.AFTER_DOT.accepts((Object)element)) {
            if (parameters2.getParameters().getInvocationCount() <= 1) {
                new CollectionsUtilityMethodsProvider(parameters2.getPosition(), parameters2.getExpectedType(), parameters2.getDefaultType(), result).addCompletions(StringUtil.isNotEmpty((String)matcher.getPrefix()));
            }
            ClassLiteralGetter.addCompletions(parameters2, result, matcher);
            PsiElement position = parameters2.getPosition();
            PsiType expectedType = parameters2.getExpectedType();
            for (TemplateImpl template : TemplateSettings.getInstance().getTemplates()) {
                if (template.isDeactivated() || !template.getTemplateContext().isEnabled((TemplateContextType)new SmartCompletionContextType())) continue;
                result.consume((Object)new SmartCompletionTemplateItem(template, position));
            }
            BasicExpressionCompletionContributor.addKeyword(result, position, "true");
            BasicExpressionCompletionContributor.addKeyword(result, position, "false");
            PsiElement parent = position.getParent();
            if (parent != null && !(parent.getParent() instanceof PsiSwitchLabelStatement)) {
                for (PsiExpression expression2 : ThisGetter.getThisExpressionVariants(position)) {
                    result.consume((Object)new ExpressionLookupItem(expression2));
                }
            }
            BasicExpressionCompletionContributor.processDataflowExpressionTypes(position, expectedType, matcher, result);
        }
    }

    public static void processDataflowExpressionTypes(PsiElement position, @Nullable PsiType expectedType, final PrefixMatcher matcher, Consumer<LookupElement> consumer) {
        PsiExpression context = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)position, PsiExpression.class);
        if (context == null) {
            return;
        }
        final MultiMap<PsiExpression, PsiType> map = GuessManager.getInstance(position.getProject()).getControlFlowExpressionTypes(context);
        if (map.isEmpty()) {
            return;
        }
        PsiScopesUtil.treeWalkUp(new PsiScopeProcessor(){

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (state == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (element instanceof PsiLocalVariable) {
                    PsiTypeCastExpression typeCastExpression;
                    PsiExpression operand2;
                    if (!matcher.prefixMatches(((PsiLocalVariable)element).getName())) {
                        return true;
                    }
                    PsiExpression expression2 = ((PsiLocalVariable)element).getInitializer();
                    if (expression2 instanceof PsiTypeCastExpression && (operand2 = (typeCastExpression = (PsiTypeCastExpression)expression2).getOperand()) != null && map.get((Object)operand2).contains(typeCastExpression.getType())) {
                        map.remove((Object)operand2);
                    }
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/codeInsight/completion/BasicExpressionCompletionContributor$1";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (PsiElement)context, (PsiElement)context.getContainingFile());
        for (PsiExpression expression2 : map.keySet()) {
            for (PsiType castType : map.get((Object)expression2)) {
                PsiType baseType = expression2.getType();
                if (expectedType != null && (!expectedType.isAssignableFrom(castType) || baseType != null && expectedType.isAssignableFrom(baseType))) continue;
                consumer.consume((Object)CastingLookupElementDecorator.createCastingElement(BasicExpressionCompletionContributor.expressionToLookupElement(expression2), castType));
            }
        }
    }

    @NotNull
    private static LookupElement expressionToLookupElement(@NotNull PsiExpression expression2) {
        PsiMethod method;
        PsiMethodCallExpression call;
        PsiElement target;
        PsiReferenceExpression refExpr;
        if (expression2 == null) {
            BasicExpressionCompletionContributor.$$$reportNull$$$0(0);
        }
        if (expression2 instanceof PsiReferenceExpression && !(refExpr = (PsiReferenceExpression)expression2).isQualified() && (target = refExpr.resolve()) instanceof PsiVariable) {
            VariableLookupItem item = new VariableLookupItem((PsiVariable)target);
            item.setSubstitutor(PsiSubstitutor.EMPTY);
            VariableLookupItem variableLookupItem = item;
            if (variableLookupItem == null) {
                BasicExpressionCompletionContributor.$$$reportNull$$$0(1);
            }
            return variableLookupItem;
        }
        if (expression2 instanceof PsiMethodCallExpression && !(call = (PsiMethodCallExpression)expression2).getMethodExpression().isQualified() && (method = call.resolveMethod()) != null) {
            JavaMethodCallElement javaMethodCallElement = new JavaMethodCallElement(method);
            if (javaMethodCallElement == null) {
                BasicExpressionCompletionContributor.$$$reportNull$$$0(2);
            }
            return javaMethodCallElement;
        }
        ExpressionLookupItem expressionLookupItem = new ExpressionLookupItem(expression2);
        if (expressionLookupItem == null) {
            BasicExpressionCompletionContributor.$$$reportNull$$$0(3);
        }
        return expressionLookupItem;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/BasicExpressionCompletionContributor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/BasicExpressionCompletionContributor";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "expressionToLookupElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "expressionToLookupElement";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

