/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.ExpectedTypesProvider;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaMethodCallElement;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.TypedLookupItem;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Consumer;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collector;
import org.jetbrains.annotations.NotNull;

class CollectConversion {
    CollectConversion() {
    }

    static void addCollectConversion(PsiReferenceExpression ref, Collection<ExpectedTypeInfo> expectedTypes, Consumer<LookupElement> consumer) {
        PsiClass collectors = JavaPsiFacade.getInstance((Project)ref.getProject()).findClass("java.util.stream.Collectors", ref.getResolveScope());
        if (collectors == null) {
            return;
        }
        PsiExpression qualifier = ref.getQualifierExpression();
        if (qualifier == null) {
            if (ref.getParent() instanceof PsiExpressionList && ref.getParent().getParent() instanceof PsiMethodCallExpression) {
                PsiReferenceExpression methodExpression = ((PsiMethodCallExpression)ref.getParent().getParent()).getMethodExpression();
                qualifier = methodExpression.getQualifierExpression();
                if ("collect".equals(methodExpression.getReferenceName()) && qualifier != null) {
                    CollectConversion.suggestCollectorsArgument(expectedTypes, consumer, collectors, qualifier);
                }
            }
            return;
        }
        CollectConversion.convertQualifierViaCollectors(ref, expectedTypes, consumer, qualifier);
    }

    private static void suggestCollectorsArgument(Collection<ExpectedTypeInfo> expectedTypes, Consumer<LookupElement> consumer, PsiClass collectors, PsiExpression qualifier) {
        PsiType matchingExpectation = (PsiType)JBIterable.from(expectedTypes).map(ExpectedTypeInfo::getType).find(t -> TypeConversionUtil.erasure((PsiType)t).equalsToText(Collector.class.getName()));
        if (matchingExpectation == null) {
            return;
        }
        for (Pair<String, PsiType> pair : CollectConversion.suggestCollectors(Arrays.asList(ExpectedTypesProvider.getExpectedTypes(qualifier, true)), qualifier)) {
            PsiMethod[] methods = collectors.findMethodsByName((String)pair.first, false);
            if (methods.length == 0) continue;
            JavaMethodCallElement item = new JavaMethodCallElement(methods[0], false, false);
            item.setAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE);
            item.setInferenceSubstitutorFromExpectedType((PsiElement)qualifier, matchingExpectation);
            consumer.consume((Object)PrioritizedLookupElement.withPriority((LookupElement)item, (double)1.0));
        }
    }

    private static void convertQualifierViaCollectors(PsiReferenceExpression ref, Collection<ExpectedTypeInfo> expectedTypes, Consumer<LookupElement> consumer, PsiExpression qualifier) {
        for (Pair<String, PsiType> pair : CollectConversion.suggestCollectors(expectedTypes, qualifier)) {
            consumer.consume((Object)new MyLookupElement((String)pair.first, (PsiType)pair.second, (PsiElement)ref));
        }
    }

    private static List<Pair<String, PsiType>> suggestCollectors(Collection<ExpectedTypeInfo> expectedTypes, PsiExpression qualifier) {
        PsiType component = PsiUtil.substituteTypeParameter((PsiType)qualifier.getType(), (String)"java.util.stream.Stream", (int)0, (boolean)true);
        if (component == null) {
            return Collections.emptyList();
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)qualifier.getProject());
        PsiElementFactory factory = facade.getElementFactory();
        GlobalSearchScope scope = qualifier.getResolveScope();
        PsiClass list = facade.findClass("java.util.List", scope);
        PsiClass set = facade.findClass("java.util.Set", scope);
        PsiClass collection = facade.findClass("java.util.Collection", scope);
        if (list == null || set == null || collection == null) {
            return Collections.emptyList();
        }
        PsiClassType listType = null;
        PsiClassType setType = null;
        boolean hasIterable = false;
        for (ExpectedTypeInfo info : expectedTypes) {
            PsiType type2 = info.getDefaultType();
            PsiClass expectedClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)type2);
            PsiType expectedComponent = PsiUtil.extractIterableTypeParameter((PsiType)type2, (boolean)true);
            if (expectedClass == null || expectedComponent == null || !TypeConversionUtil.isAssignable((PsiType)expectedComponent, (PsiType)component)) continue;
            hasIterable = true;
            if (InheritanceUtil.isInheritorOrSelf((PsiClass)list, (PsiClass)expectedClass, (boolean)true)) {
                listType = type2;
            }
            if (!InheritanceUtil.isInheritorOrSelf((PsiClass)set, (PsiClass)expectedClass, (boolean)true)) continue;
            setType = type2;
        }
        if (expectedTypes.isEmpty()) {
            listType = factory.createType(list, component);
            setType = factory.createType(set, component);
        }
        ArrayList<Pair<String, PsiType>> result = new ArrayList<Pair<String, PsiType>>();
        if (listType != null) {
            result.add(Pair.create((Object)"toList", (Object)listType));
        }
        if (setType != null) {
            result.add(Pair.create((Object)"toSet", (Object)setType));
        }
        if (expectedTypes.isEmpty() || hasIterable) {
            result.add((Pair<String, PsiType>)Pair.create((Object)"toCollection", (Object)factory.createType(collection, component)));
        }
        return result;
    }

    private static class MyLookupElement
    extends LookupElement
    implements TypedLookupItem {
        private final String myLookupString;
        private final String myTypeText;
        private final String myMethodName;
        @NotNull
        private final PsiType myExpectedType;
        private final boolean myHasImport;

        MyLookupElement(String methodName, @NotNull PsiType expectedType, @NotNull PsiElement context) {
            if (expectedType == null) {
                MyLookupElement.$$$reportNull$$$0(0);
            }
            if (context == null) {
                MyLookupElement.$$$reportNull$$$0(1);
            }
            this.myMethodName = methodName;
            this.myExpectedType = expectedType;
            this.myTypeText = this.myExpectedType.getPresentableText();
            PsiMethodCallExpression call = (PsiMethodCallExpression)JavaPsiFacade.getElementFactory((Project)context.getProject()).createExpressionFromText(methodName + "()", context);
            this.myHasImport = ContainerUtil.or((Object[])call.getMethodExpression().multiResolve(true), result -> {
                PsiElement element = result.getElement();
                return element instanceof PsiMember && ("java.util.stream.Collectors." + this.myMethodName).equals(PsiUtil.getMemberQualifiedName((PsiMember)((PsiMember)element)));
            });
            this.myLookupString = "collect(" + (this.myHasImport ? "" : "Collectors.") + this.myMethodName + "())";
        }

        @NotNull
        public String getLookupString() {
            String string = this.myLookupString;
            if (string == null) {
                MyLookupElement.$$$reportNull$$$0(2);
            }
            return string;
        }

        public Set<String> getAllLookupStrings() {
            return ContainerUtil.newHashSet((Object[])new String[]{this.myLookupString, this.myMethodName});
        }

        public void renderElement(LookupElementPresentation presentation) {
            super.renderElement(presentation);
            presentation.setTypeText(this.myTypeText);
            presentation.setIcon(PlatformIcons.METHOD_ICON);
        }

        public void handleInsert(InsertionContext context) {
            context.getDocument().replaceString(context.getStartOffset(), context.getTailOffset(), (CharSequence)this.getInsertString());
            context.commitDocument();
            PsiMethodCallExpression call = (PsiMethodCallExpression)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)context.getFile(), (int)context.getStartOffset(), PsiMethodCallExpression.class, (boolean)false);
            if (call == null) {
                return;
            }
            PsiExpression[] args = call.getArgumentList().getExpressions();
            if (args.length != 1 || !(args[0] instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression innerCall = (PsiMethodCallExpression)args[0];
            PsiMethod collectorMethod = innerCall.resolveMethod();
            if (collectorMethod != null && collectorMethod.getParameterList().getParametersCount() > 0) {
                context.getEditor().getCaretModel().moveToOffset(innerCall.getArgumentList().getFirstChild().getTextRange().getEndOffset());
            }
            JavaCodeStyleManager.getInstance((Project)context.getProject()).shortenClassReferences((PsiElement)innerCall);
        }

        @NotNull
        private String getInsertString() {
            String string = "collect(" + (this.myHasImport ? "" : "java.util.stream.Collectors.") + this.myMethodName + "())";
            if (string == null) {
                MyLookupElement.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        public PsiType getType() {
            return this.myExpectedType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expectedType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/completion/CollectConversion$MyLookupElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/completion/CollectConversion$MyLookupElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLookupString";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInsertString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

