/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nH\u0002J \u0010\u0010\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0002J\u0018\u0010\u001d\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0016H\u0007R(\u0010\u0003\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0006 \u0007*\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\b\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\n \u0007*\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t0\t0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/codeInsight/completion/CompletionMemory;", "", "()V", "CHOSEN_METHODS", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lcom/intellij/psi/PsiMethod;", "kotlin.jvm.PlatformType", "LAST_CHOSEN_METHODS", "Ljava/util/LinkedList;", "Lcom/intellij/openapi/editor/RangeMarker;", "addToMemory", "", "document", "Lcom/intellij/openapi/editor/Document;", "marker", "createChosenMethodMarker", "method", "nameRange", "Lcom/intellij/openapi/util/TextRange;", "getAnchorRange", "call", "Lcom/intellij/psi/PsiCall;", "getChosenMethod", "haveSameRange", "", "s1", "Lcom/intellij/openapi/util/Segment;", "s2", "registerChosenMethod", "java-impl"})
public final class CompletionMemory {
    private static final Key<LinkedList<RangeMarker>> LAST_CHOSEN_METHODS;
    private static final Key<SmartPsiElementPointer<PsiMethod>> CHOSEN_METHODS;
    public static final CompletionMemory INSTANCE;

    @JvmStatic
    public static final void registerChosenMethod(@NotNull PsiMethod method, @NotNull PsiCall call) {
        Document document;
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
        TextRange textRange = INSTANCE.getAnchorRange(call);
        if (textRange == null) {
            return;
        }
        TextRange nameRange = textRange;
        Document document2 = call.getContainingFile().getViewProvider().getDocument();
        if (document2 == null) {
            return;
        }
        Document document3 = document = document2;
        Intrinsics.checkExpressionValueIsNotNull((Object)document3, (String)"document");
        PsiElement psiElement = CompletionUtil.getOriginalOrSelf((PsiElement)((PsiElement)method));
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"CompletionUtil.getOriginalOrSelf(method)");
        INSTANCE.addToMemory(document3, INSTANCE.createChosenMethodMarker(document, (PsiMethod)psiElement, nameRange));
    }

    private final TextRange getAnchorRange(PsiCall call) {
        Object object;
        PsiCall psiCall = call;
        if (psiCall instanceof PsiMethodCallExpression) {
            PsiElement psiElement = ((PsiMethodCallExpression)call).getMethodExpression().getReferenceNameElement();
            object = psiElement != null ? psiElement.getTextRange() : null;
        } else {
            PsiJavaCodeReferenceElement psiJavaCodeReferenceElement;
            object = psiCall instanceof PsiNewExpression ? ((psiJavaCodeReferenceElement = ((PsiNewExpression)call).getClassOrAnonymousClassReference()) != null && (psiJavaCodeReferenceElement = psiJavaCodeReferenceElement.getReferenceNameElement()) != null ? psiJavaCodeReferenceElement.getTextRange() : null) : null;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final void addToMemory(Document document, RangeMarker marker) {
        LinkedList<RangeMarker> completedMethods = new LinkedList<RangeMarker>();
        LinkedList linkedList = (LinkedList)document.getUserData(LAST_CHOSEN_METHODS);
        if (linkedList != null) {
            void $receiver$iv$iv;
            void $receiver$iv;
            LinkedList linkedList2;
            LinkedList it = linkedList2 = linkedList;
            Iterable iterable = it;
            LinkedList<RangeMarker> linkedList3 = completedMethods;
            void var8_8 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                RangeMarker it2 = (RangeMarker)element$iv$iv;
                if (!(it2.isValid() && !INSTANCE.haveSameRange((Segment)it2, (Segment)marker))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list = (List)destination$iv$iv;
            linkedList3.addAll(list);
        }
        while (completedMethods.size() > 10) {
            completedMethods.remove(0);
        }
        document.putUserData(LAST_CHOSEN_METHODS, completedMethods);
        completedMethods.add(marker);
    }

    private final RangeMarker createChosenMethodMarker(Document document, PsiMethod method, TextRange nameRange) {
        RangeMarker marker = document.createRangeMarker(nameRange.getStartOffset(), nameRange.getEndOffset());
        marker.putUserData(CHOSEN_METHODS, (Object)SmartPointerManager.getInstance((Project)method.getProject()).createSmartPsiElementPointer((PsiElement)method));
        RangeMarker rangeMarker = marker;
        Intrinsics.checkExpressionValueIsNotNull((Object)rangeMarker, (String)"marker");
        return rangeMarker;
    }

    @JvmStatic
    @Nullable
    public static final PsiMethod getChosenMethod(@NotNull PsiCall call) {
        SmartPsiElementPointer marker;
        SmartPsiElementPointer smartPsiElementPointer;
        SmartPsiElementPointer smartPsiElementPointer2;
        LinkedList completedMethods;
        Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
        TextRange textRange = INSTANCE.getAnchorRange(call);
        if (textRange == null) {
            return null;
        }
        TextRange range = textRange;
        Document document = call.getContainingFile().getViewProvider().getDocument();
        LinkedList linkedList = completedMethods = document != null ? (LinkedList)document.getUserData(LAST_CHOSEN_METHODS) : null;
        if (linkedList != null) {
            Object v3;
            block4: {
                Iterable iterable;
                LinkedList linkedList2;
                LinkedList it = linkedList2 = linkedList;
                Iterable iterable2 = iterable = (Iterable)it;
                for (Object t : iterable2) {
                    RangeMarker m = (RangeMarker)t;
                    if (!INSTANCE.haveSameRange((Segment)m, (Segment)range)) continue;
                    v3 = t;
                    break block4;
                }
                v3 = null;
            }
            smartPsiElementPointer2 = v3;
        } else {
            smartPsiElementPointer2 = null;
        }
        return (smartPsiElementPointer = (marker = smartPsiElementPointer2)) != null && (smartPsiElementPointer = (SmartPsiElementPointer)smartPsiElementPointer.getUserData(CHOSEN_METHODS)) != null ? (PsiMethod)smartPsiElementPointer.getElement() : null;
    }

    private final boolean haveSameRange(Segment s1, Segment s2) {
        return s1.getStartOffset() == s2.getStartOffset() && s1.getEndOffset() == s2.getEndOffset();
    }

    private CompletionMemory() {
    }

    static {
        CompletionMemory completionMemory;
        INSTANCE = completionMemory = new CompletionMemory();
        LAST_CHOSEN_METHODS = Key.create((String)"COMPLETED_METHODS");
        CHOSEN_METHODS = Key.create((String)"CHOSEN_METHODS");
    }
}

