/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInsight.daemon.QuickFixActionRegistrar;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.analysis.JavaModuleGraphUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.AddExportsDirectiveFix;
import com.intellij.codeInsight.daemon.impl.quickfix.AddUsesDirectiveFix;
import com.intellij.codeInsight.daemon.impl.quickfix.GoToSymbolFix;
import com.intellij.codeInsight.daemon.impl.quickfix.MergeModuleStatementsFix;
import com.intellij.codeInsight.daemon.impl.quickfix.MoveFileFix;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixActionRegistrarImpl;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaModuleReferenceElement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiProvidesStatement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.light.LightJavaModule;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import gnu.trove.THashSet;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class ModuleHighlightUtil {
    private static final Attributes.Name MULTI_RELEASE = new Attributes.Name("Multi-Release");

    @Nullable
    static PsiJavaModule getModuleDescriptor(@Nullable VirtualFile file, @NotNull Project project) {
        if (project == null) {
            ModuleHighlightUtil.$$$reportNull$$$0(0);
        }
        if (file == null) {
            return null;
        }
        ProjectFileIndex index = ProjectFileIndex.SERVICE.getInstance((Project)project);
        if (index.isInLibrary(file)) {
            VirtualFile root2 = index.getClassRootForFile(file);
            if (root2 != null) {
                VirtualFile alt;
                VirtualFile descriptorFile = root2.findChild("module-info.class");
                if (descriptorFile == null && (alt = root2.findFileByRelativePath("META-INF/versions/9/module-info.class")) != null && ModuleHighlightUtil.isMultiReleaseJar(root2)) {
                    descriptorFile = alt;
                }
                if (descriptorFile != null) {
                    PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(descriptorFile);
                    if (psiFile instanceof PsiJavaFile) {
                        return ((PsiJavaFile)psiFile).getModuleDeclaration();
                    }
                } else if (root2.getFileSystem() instanceof JarFileSystem && "jar".equalsIgnoreCase(root2.getExtension())) {
                    return LightJavaModule.getModule(PsiManager.getInstance((Project)project), root2);
                }
            } else {
                PsiFile psiFile;
                VirtualFile descriptorFile;
                root2 = index.getSourceRootForFile(file);
                if (root2 != null && (descriptorFile = root2.findChild("module-info.java")) != null && (psiFile = PsiManager.getInstance((Project)project).findFile(descriptorFile)) instanceof PsiJavaFile) {
                    return ((PsiJavaFile)psiFile).getModuleDeclaration();
                }
            }
        } else {
            Module module = index.getModuleForFile(file);
            if (module != null) {
                PsiFile psiFile;
                JavaSourceRootType rootType = index.isInTestSourceContent(file) ? JavaSourceRootType.TEST_SOURCE : JavaSourceRootType.SOURCE;
                List files = ModuleRootManager.getInstance((Module)module).getSourceRoots((JpsModuleSourceRootType)rootType).stream().map(root -> root.findChild("module-info.java")).filter(Objects::nonNull).collect(Collectors.toList());
                if (files.size() == 1 && (psiFile = PsiManager.getInstance((Project)project).findFile((VirtualFile)files.get(0))) instanceof PsiJavaFile) {
                    return ((PsiJavaFile)psiFile).getModuleDeclaration();
                }
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isMultiReleaseJar(VirtualFile root) {
        if (!(root.getFileSystem() instanceof JarFileSystem)) return false;
        VirtualFile manifest = root.findFileByRelativePath("META-INF/MANIFEST.MF");
        if (manifest == null) return false;
        try (InputStream stream = manifest.getInputStream();){
            boolean bl = Boolean.valueOf(new Manifest(stream).getMainAttributes().getValue(MULTI_RELEASE));
            return bl;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    static HighlightInfo checkPackageStatement(@NotNull PsiPackageStatement statement, @NotNull PsiFile file, @Nullable PsiJavaModule module) {
        PsiJavaModule origin;
        String packageName;
        if (statement == null) {
            ModuleHighlightUtil.$$$reportNull$$$0(1);
        }
        if (file == null) {
            ModuleHighlightUtil.$$$reportNull$$$0(2);
        }
        if (PsiUtil.isModuleFile((PsiFile)file)) {
            String message2 = JavaErrorMessages.message("module.no.package", new Object[0]);
            HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)statement).descriptionAndTooltip(message2).create();
            QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)ModuleHighlightUtil.factory().createDeleteFix((PsiElement)statement));
            return info;
        }
        if (module != null && (packageName = statement.getPackageName()) != null && (origin = JavaModuleGraphUtil.findOrigin(module, packageName)) != null) {
            String message3 = JavaErrorMessages.message("module.conflicting.packages", packageName, origin.getName());
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)statement).descriptionAndTooltip(message3).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkFileName(@NotNull PsiJavaModule element, @NotNull PsiFile file) {
        if (element == null) {
            ModuleHighlightUtil.$$$reportNull$$$0(3);
        }
        if (file == null) {
            ModuleHighlightUtil.$$$reportNull$$$0(4);
        }
        if (!"module-info.java".equals(file.getName())) {
            String message2 = JavaErrorMessages.message("module.file.wrong.name", new Object[0]);
            HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(element)).descriptionAndTooltip(message2).create();
            QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)ModuleHighlightUtil.factory().createRenameFileFix("module-info.java"));
            return info;
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkFileDuplicates(@NotNull PsiJavaModule element, @NotNull PsiFile file) {
        Project project;
        Collection others;
        Module module;
        if (element == null) {
            ModuleHighlightUtil.$$$reportNull$$$0(5);
        }
        if (file == null) {
            ModuleHighlightUtil.$$$reportNull$$$0(6);
        }
        if ((module = ModuleUtilCore.findModuleForFile((PsiFile)file)) != null && (others = FilenameIndex.getVirtualFilesByName((Project)(project = file.getProject()), (String)"module-info.java", (GlobalSearchScope)module.getModuleScope())).size() > 1) {
            String message2 = JavaErrorMessages.message("module.file.duplicate", new Object[0]);
            HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(element)).descriptionAndTooltip(message2).create();
            others.stream().map(f -> PsiManager.getInstance((Project)project).findFile(f)).filter(f -> {
                if (file == null) {
                    ModuleHighlightUtil.$$$reportNull$$$0(23);
                }
                return f != file;
            }).findFirst().ifPresent(duplicate -> QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)new GoToSymbolFix((NavigatablePsiElement)duplicate, JavaErrorMessages.message("module.open.duplicate.text", new Object[0]))));
            return info;
        }
        return null;
    }

    @NotNull
    static List<HighlightInfo> checkDuplicateStatements(@NotNull PsiJavaModule module) {
        if (module == null) {
            ModuleHighlightUtil.$$$reportNull$$$0(7);
        }
        List results = ContainerUtil.newSmartList();
        ModuleHighlightUtil.checkDuplicateRefs(module.getRequires(), st -> st.getModuleName(), "module.duplicate.requires", results);
        ModuleHighlightUtil.checkDuplicateRefs(module.getExports(), st -> st.getPackageName(), "module.duplicate.exports", results);
        ModuleHighlightUtil.checkDuplicateRefs(module.getOpens(), st -> st.getPackageName(), "module.duplicate.opens", results);
        ModuleHighlightUtil.checkDuplicateRefs(module.getUses(), st -> ModuleHighlightUtil.qName(st.getClassReference()), "module.duplicate.uses", results);
        ModuleHighlightUtil.checkDuplicateRefs(module.getProvides(), st -> ModuleHighlightUtil.qName(st.getInterfaceReference()), "module.duplicate.provides", results);
        List list = results;
        if (list == null) {
            ModuleHighlightUtil.$$$reportNull$$$0(8);
        }
        return list;
    }

    private static <T extends PsiStatement> void checkDuplicateRefs(Iterable<T> statements, Function<T, String> ref, @PropertyKey(resourceBundle="messages.JavaErrorMessages") String key2, List<HighlightInfo> results) {
        THashSet filter = ContainerUtil.newTroveSet();
        for (PsiStatement statement : statements) {
            String refText = ref.apply(statement);
            if (refText == null || filter.add(refText)) continue;
            String message2 = JavaErrorMessages.message(key2, refText);
            HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)statement).descriptionAndTooltip(message2).create();
            QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)ModuleHighlightUtil.factory().createDeleteFix((PsiElement)statement));
            QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)MergeModuleStatementsFix.createFix((PsiElement)statement));
            results.add(info);
        }
    }

    @NotNull
    static List<HighlightInfo> checkUnusedServices(@NotNull PsiJavaModule module, @NotNull PsiFile file) {
        List provides;
        if (module == null) {
            ModuleHighlightUtil.$$$reportNull$$$0(9);
        }
        if (file == null) {
            ModuleHighlightUtil.$$$reportNull$$$0(10);
        }
        List results = ContainerUtil.newSmartList();
        Module host = ModuleUtilCore.findModuleForFile((PsiFile)file);
        if (host != null && !(provides = JBIterable.from((Iterable)module.getProvides()).toList()).isEmpty()) {
            Set exports = JBIterable.from((Iterable)module.getExports()).map(PsiPackageAccessibilityStatement::getPackageName).filter(Objects::nonNull).toSet();
            Set uses = JBIterable.from((Iterable)module.getUses()).map(st -> ModuleHighlightUtil.qName(st.getClassReference())).filter(Objects::nonNull).toSet();
            for (PsiProvidesStatement statement : provides) {
                String className;
                String packageName;
                PsiElement target;
                PsiJavaCodeReferenceElement ref = statement.getInterfaceReference();
                if (ref == null || !((target = ref.resolve()) instanceof PsiClass) || ModuleUtilCore.findModuleForFile((PsiFile)target.getContainingFile()) != host || exports.contains(packageName = StringUtil.getPackageName((String)(className = ModuleHighlightUtil.qName(ref)))) || uses.contains(className)) continue;
                String message2 = JavaErrorMessages.message("module.service.unused", new Object[0]);
                HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.WARNING).range(ModuleHighlightUtil.range(ref)).descriptionAndTooltip(message2).create();
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)new AddExportsDirectiveFix(module, packageName, ""));
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)new AddUsesDirectiveFix(module, className));
                results.add(info);
            }
        }
        List list = results;
        if (list == null) {
            ModuleHighlightUtil.$$$reportNull$$$0(11);
        }
        return list;
    }

    private static String qName(PsiJavaCodeReferenceElement ref) {
        return ref != null ? ref.getQualifiedName() : null;
    }

    @Nullable
    static HighlightInfo checkFileLocation(@NotNull PsiJavaModule element, @NotNull PsiFile file) {
        VirtualFile root;
        VirtualFile vFile;
        if (element == null) {
            ModuleHighlightUtil.$$$reportNull$$$0(12);
        }
        if (file == null) {
            ModuleHighlightUtil.$$$reportNull$$$0(13);
        }
        if ((vFile = file.getVirtualFile()) != null && (root = ProjectFileIndex.SERVICE.getInstance((Project)file.getProject()).getSourceRootForFile(vFile)) != null && !root.equals(vFile.getParent())) {
            String message2 = JavaErrorMessages.message("module.file.wrong.location", new Object[0]);
            HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(element)).descriptionAndTooltip(message2).create();
            QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)new MoveFileFix(vFile, root, QuickFixBundle.message("move.file.to.source.root.text", new Object[0])));
            return info;
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkModuleReference(@Nullable PsiJavaModuleReferenceElement refElement, @NotNull PsiJavaModule container) {
        if (container == null) {
            ModuleHighlightUtil.$$$reportNull$$$0(14);
        }
        if (refElement != null) {
            PsiPolyVariantReference ref = refElement.getReference();
            assert (ref != null) : refElement.getParent();
            PsiElement target = ref.resolve();
            if (!(target instanceof PsiJavaModule)) {
                return ModuleHighlightUtil.moduleResolveError(refElement, ref);
            }
            if (target == container) {
                String message2 = JavaErrorMessages.message("module.cyclic.dependence", container.getName());
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)refElement).descriptionAndTooltip(message2).create();
            }
            Collection<PsiJavaModule> cycle = JavaModuleGraphUtil.findCycle((PsiJavaModule)target);
            if (cycle != null && cycle.contains(container)) {
                Stream<String> stream = cycle.stream().map(PsiJavaModule::getName);
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    stream = stream.sorted();
                }
                String message3 = JavaErrorMessages.message("module.cyclic.dependence", stream.collect(Collectors.joining(", ")));
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)refElement).descriptionAndTooltip(message3).create();
            }
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkHostModuleStrength(@NotNull PsiPackageAccessibilityStatement statement) {
        PsiElement parent;
        if (statement == null) {
            ModuleHighlightUtil.$$$reportNull$$$0(15);
        }
        if (statement.getRole() == PsiPackageAccessibilityStatement.Role.OPENS && (parent = statement.getParent()) instanceof PsiJavaModule && ((PsiJavaModule)parent).hasModifierProperty("open")) {
            String message2 = JavaErrorMessages.message("module.opens.in.weak.module", new Object[0]);
            HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)statement).descriptionAndTooltip(message2).create();
            QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)ModuleHighlightUtil.factory().createModifierListFix((PsiModifierListOwner)parent, "open", false, false));
            QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)ModuleHighlightUtil.factory().createDeleteFix((PsiElement)statement));
            return info;
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkPackageReference(@NotNull PsiPackageAccessibilityStatement statement, @NotNull PsiFile file) {
        Module module;
        PsiJavaCodeReferenceElement refElement;
        if (statement == null) {
            ModuleHighlightUtil.$$$reportNull$$$0(16);
        }
        if (file == null) {
            ModuleHighlightUtil.$$$reportNull$$$0(17);
        }
        if ((refElement = statement.getPackageReference()) != null && (module = ModuleUtilCore.findModuleForFile((PsiFile)file)) != null) {
            HighlightInfoType type2;
            PsiElement target = refElement.resolve();
            PsiDirectory[] directories = target instanceof PsiPackage ? ((PsiPackage)target).getDirectories(module.getModuleScope(false)) : null;
            String packageName = statement.getPackageName();
            HighlightInfoType highlightInfoType = type2 = statement.getRole() == PsiPackageAccessibilityStatement.Role.OPENS ? HighlightInfoType.WARNING : HighlightInfoType.ERROR;
            if (directories == null || directories.length == 0) {
                String message2 = JavaErrorMessages.message("package.not.found", packageName);
                HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)type2).range((PsiElement)refElement).descriptionAndTooltip(message2).create();
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)ModuleHighlightUtil.factory().createCreateClassInPackageInModuleFix(module, packageName));
                return info;
            }
            if (packageName != null && PsiUtil.isPackageEmpty((PsiDirectory[])directories, (String)packageName)) {
                String message3 = JavaErrorMessages.message("package.is.empty", packageName);
                HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)type2).range((PsiElement)refElement).descriptionAndTooltip(message3).create();
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)ModuleHighlightUtil.factory().createCreateClassInPackageInModuleFix(module, packageName));
                return info;
            }
        }
        return null;
    }

    @NotNull
    static List<HighlightInfo> checkPackageAccessTargets(@NotNull PsiPackageAccessibilityStatement statement) {
        if (statement == null) {
            ModuleHighlightUtil.$$$reportNull$$$0(18);
        }
        List results = ContainerUtil.newSmartList();
        THashSet targets = ContainerUtil.newTroveSet();
        for (PsiJavaModuleReferenceElement refElement : statement.getModuleReferences()) {
            String refText = refElement.getReferenceText();
            PsiPolyVariantReference ref = refElement.getReference();
            assert (ref != null) : statement;
            if (!targets.add(refText)) {
                boolean exports = statement.getRole() == PsiPackageAccessibilityStatement.Role.EXPORTS;
                String message2 = JavaErrorMessages.message(exports ? "module.duplicate.exports.target" : "module.duplicate.opens.target", refText);
                HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)refElement).descriptionAndTooltip(message2).create();
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)ModuleHighlightUtil.factory().createDeleteFix((PsiElement)refElement, QuickFixBundle.message("delete.reference.fix.text", new Object[0])));
                results.add(info);
                continue;
            }
            if (ref.multiResolve(true).length != 0) continue;
            String message3 = JavaErrorMessages.message("module.not.found", refElement.getReferenceText());
            results.add(HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.WARNING).range((PsiElement)refElement).descriptionAndTooltip(message3).create());
        }
        List list = results;
        if (list == null) {
            ModuleHighlightUtil.$$$reportNull$$$0(19);
        }
        return list;
    }

    @Nullable
    static HighlightInfo checkServiceReference(@Nullable PsiJavaCodeReferenceElement refElement) {
        if (refElement != null) {
            PsiElement target = refElement.resolve();
            if (!(target instanceof PsiClass)) {
                String message2 = JavaErrorMessages.message("cannot.resolve.symbol", refElement.getReferenceName());
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(refElement)).descriptionAndTooltip(message2).create();
            }
            if (((PsiClass)target).isEnum()) {
                String message3 = JavaErrorMessages.message("module.service.enum", ((PsiClass)target).getName());
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(refElement)).descriptionAndTooltip(message3).create();
            }
        }
        return null;
    }

    @Nullable
    static List<HighlightInfo> checkServiceImplementations(@NotNull PsiProvidesStatement statement, @NotNull PsiFile file) {
        PsiReferenceList implRefList;
        if (statement == null) {
            ModuleHighlightUtil.$$$reportNull$$$0(20);
        }
        if (file == null) {
            ModuleHighlightUtil.$$$reportNull$$$0(21);
        }
        if ((implRefList = statement.getImplementationList()) == null) {
            return null;
        }
        List results = ContainerUtil.newSmartList();
        PsiJavaCodeReferenceElement intRef = statement.getInterfaceReference();
        PsiElement intTarget = intRef != null ? intRef.resolve() : null;
        THashSet filter = ContainerUtil.newTroveSet();
        for (PsiJavaCodeReferenceElement implRef : implRefList.getReferenceElements()) {
            String message2;
            PsiMethod provider;
            PsiElement implTarget;
            String refText = implRef.getQualifiedName();
            if (!filter.add(refText)) {
                String message3 = JavaErrorMessages.message("module.duplicate.impl", refText);
                HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)implRef).descriptionAndTooltip(message3).create();
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)ModuleHighlightUtil.factory().createDeleteFix((PsiElement)implRef, QuickFixBundle.message("delete.reference.fix.text", new Object[0])));
                results.add(info);
                continue;
            }
            if (!(intTarget instanceof PsiClass) || !((implTarget = implRef.resolve()) instanceof PsiClass)) continue;
            PsiClass implClass = (PsiClass)implTarget;
            if (ModuleUtilCore.findModuleForFile((PsiFile)file) != ModuleUtilCore.findModuleForFile((PsiFile)implClass.getContainingFile())) {
                String message4 = JavaErrorMessages.message("module.service.alien", new Object[0]);
                results.add(HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(implRef)).descriptionAndTooltip(message4).create());
            }
            if ((provider = (PsiMethod)ContainerUtil.find((Object[])implClass.findMethodsByName("provider", false), m -> m.hasModifierProperty("public") && m.hasModifierProperty("static") && m.getParameterList().getParametersCount() == 0)) != null) {
                PsiClass typeClass;
                PsiType type2 = provider.getReturnType();
                PsiClass psiClass = typeClass = type2 instanceof PsiClassType ? ((PsiClassType)type2).resolve() : null;
                if (InheritanceUtil.isInheritorOrSelf((PsiClass)typeClass, (PsiClass)((PsiClass)intTarget), (boolean)true)) continue;
                String message5 = JavaErrorMessages.message("module.service.provider.type", implClass.getName());
                results.add(HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(implRef)).descriptionAndTooltip(message5).create());
                continue;
            }
            if (InheritanceUtil.isInheritorOrSelf((PsiClass)implClass, (PsiClass)((PsiClass)intTarget), (boolean)true)) {
                if (implClass.hasModifierProperty("abstract")) {
                    message2 = JavaErrorMessages.message("module.service.abstract", implClass.getName());
                    results.add(HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(implRef)).descriptionAndTooltip(message2).create());
                    continue;
                }
                if (!ClassUtil.isTopLevelClass((PsiClass)implClass) && !implClass.hasModifierProperty("static")) {
                    message2 = JavaErrorMessages.message("module.service.inner", implClass.getName());
                    results.add(HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(implRef)).descriptionAndTooltip(message2).create());
                    continue;
                }
                if (PsiUtil.hasDefaultConstructor((PsiClass)implClass)) continue;
                message2 = JavaErrorMessages.message("module.service.no.ctor", implClass.getName());
                results.add(HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(implRef)).descriptionAndTooltip(message2).create());
                continue;
            }
            message2 = JavaErrorMessages.message("module.service.impl", new Object[0]);
            results.add(HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(implRef)).descriptionAndTooltip(message2).create());
        }
        return results;
    }

    @Nullable
    static HighlightInfo checkClashingReads(@NotNull PsiJavaModule module) {
        Trinity<String, PsiJavaModule, PsiJavaModule> conflict;
        if (module == null) {
            ModuleHighlightUtil.$$$reportNull$$$0(22);
        }
        if ((conflict = JavaModuleGraphUtil.findConflict(module)) != null) {
            String message2 = JavaErrorMessages.message("module.conflicting.reads", module.getName(), conflict.first, ((PsiJavaModule)conflict.second).getName(), ((PsiJavaModule)conflict.third).getName());
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(module)).descriptionAndTooltip(message2).create();
        }
        return null;
    }

    private static HighlightInfo moduleResolveError(PsiJavaModuleReferenceElement refElement, PsiPolyVariantReference ref) {
        if (ref.multiResolve(true).length == 0) {
            String message2 = JavaErrorMessages.message("module.not.found", refElement.getReferenceText());
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.WRONG_REF).range((PsiElement)refElement).descriptionAndTooltip(message2).create();
        }
        if (ref.multiResolve(false).length > 1) {
            String message3 = JavaErrorMessages.message("module.ambiguous", refElement.getReferenceText());
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.WARNING).range((PsiElement)refElement).descriptionAndTooltip(message3).create();
        }
        String message4 = JavaErrorMessages.message("module.not.on.path", refElement.getReferenceText());
        HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.WRONG_REF).range((PsiElement)refElement).descriptionAndTooltip(message4).create();
        ModuleHighlightUtil.factory().registerOrderEntryFixes((QuickFixActionRegistrar)new QuickFixActionRegistrarImpl(info), (PsiReference)ref);
        return info;
    }

    private static QuickFixFactory factory() {
        return QuickFixFactory.getInstance();
    }

    private static TextRange range(PsiJavaModule module) {
        PsiKeyword kw = (PsiKeyword)PsiTreeUtil.getChildOfType((PsiElement)module, PsiKeyword.class);
        return new TextRange(kw != null ? kw.getTextOffset() : module.getTextOffset(), module.getNameIdentifier().getTextRange().getEndOffset());
    }

    private static PsiElement range(PsiJavaCodeReferenceElement refElement) {
        return (PsiElement)ObjectUtils.notNull((Object)refElement.getReferenceNameElement(), (Object)refElement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 11: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 11: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 15: 
            case 16: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 10: 
            case 13: 
            case 17: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: 
            case 9: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 8: 
            case 11: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/ModuleHighlightUtil";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/ModuleHighlightUtil";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "checkDuplicateStatements";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "checkUnusedServices";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "checkPackageAccessTargets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getModuleDescriptor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkPackageStatement";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkFileName";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkFileDuplicates";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkDuplicateStatements";
                break;
            }
            case 8: 
            case 11: 
            case 19: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "checkUnusedServices";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "checkFileLocation";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "checkModuleReference";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "checkHostModuleStrength";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "checkPackageReference";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "checkPackageAccessTargets";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "checkServiceImplementations";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "checkClashingReads";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "lambda$checkFileDuplicates$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 11: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

